/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.sound;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import org.lwjgl.BufferUtils;
import org.lwjgl.Sys;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.newdawn.sound.DeferredSound;
import org.newdawn.sound.MODSound;
import org.newdawn.sound.OggData;
import org.newdawn.sound.OggDecoder;
import org.newdawn.sound.Sound;
import org.newdawn.state.loading.Loadable;
import org.newdawn.state.loading.LoadingList;
import org.newdawn.util.Log;
import org.newdawn.util.ResourceLoader;

public class SoundStore {
    private static final SoundStore store = new SoundStore();
    private boolean sounds;
    private boolean music;
    private boolean soundWorks;
    private int sourceCount;
    private HashMap loaded = new HashMap();
    private int currentMusic = -1;
    private IntBuffer sources;
    private int nextSource;
    private boolean inited = false;
    private MODSound mod;
    private float musicVolume = 1.0f;
    private float soundVolume = 1.0f;
    private float lastMusicGain = 1.0f;
    private boolean deferredLoading = false;
    private boolean fadeIn;
    private float fade;

    private SoundStore() {
    }

    public void setDeferredLoading(boolean deferredLoading) {
        this.deferredLoading = deferredLoading;
    }

    public void setMusicOn(boolean music) {
        if (this.soundWorks) {
            this.music = music;
            if (music) {
                this.restartLoop();
            } else {
                this.pauseLoop();
            }
        }
    }

    public boolean isMusicOn() {
        return this.music;
    }

    public void setMusicVolume(float volume) {
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        this.musicVolume = volume;
        if (this.soundWorks) {
            if (volume == 0.0f) {
                volume = 0.001f;
            }
            AL10.alSourcef((int)this.sources.get(0), (int)4106, (float)(this.lastMusicGain * volume));
        }
    }

    public void setSoundVolume(float volume) {
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        this.soundVolume = volume;
    }

    public boolean soundWorks() {
        return this.soundWorks;
    }

    public boolean musicOn() {
        return this.music;
    }

    public float getSoundVolume() {
        return this.soundVolume;
    }

    public float getMusicVolume() {
        return this.musicVolume;
    }

    public int getSource(int index) {
        return this.sources.get(index);
    }

    public void setSoundsOn(boolean sounds) {
        if (this.soundWorks) {
            this.sounds = sounds;
        }
    }

    public boolean soundsOn() {
        return this.sounds;
    }

    public void init() {
        Log.log((String)"Initialising sounds..");
        this.inited = true;
        try {
            AL.create();
            this.soundWorks = true;
            this.sounds = true;
            this.music = true;
            Log.log((String)"- Sound works");
        }
        catch (Exception e) {
            Log.log((String)"Sound initialisation failure.");
            Log.log((Throwable)e);
            this.soundWorks = false;
            this.sounds = false;
            this.music = false;
        }
        if (this.soundWorks) {
            this.sourceCount = 8;
            this.sources = BufferUtils.createIntBuffer((int)this.sourceCount);
            AL10.alGenSources((IntBuffer)this.sources);
            if (AL10.alGetError() != 0) {
                this.sounds = false;
                this.music = false;
                this.soundWorks = false;
                Log.log((String)"- AL init failed");
            } else {
                Log.log((String)"- Sounds source generated");
            }
        }
    }

    void playAsSound(int buffer, float pitch, float gain) {
        if ((gain *= this.soundVolume) == 0.0f) {
            gain = 0.001f;
        }
        if (this.soundWorks && this.sounds) {
            ++this.nextSource;
            if (this.nextSource > this.sourceCount - 1) {
                this.nextSource = 1;
            }
            AL10.alSourceStop((int)this.sources.get(this.nextSource));
            AL10.alSourcei((int)this.sources.get(this.nextSource), (int)4105, (int)buffer);
            AL10.alSourcef((int)this.sources.get(this.nextSource), (int)4099, (float)pitch);
            AL10.alSourcef((int)this.sources.get(this.nextSource), (int)4106, (float)gain);
            AL10.alSourcePlay((int)this.sources.get(this.nextSource));
        }
    }

    void playAsMusic(int buffer, float pitch, float gain) {
        this.lastMusicGain = gain;
        if ((gain *= this.musicVolume) == 0.0f) {
            gain = 0.001f;
        }
        this.setMOD(null);
        if (this.soundWorks) {
            if (this.currentMusic != -1) {
                AL10.alSourceStop((int)this.sources.get(0));
            }
            AL10.alSourcei((int)this.sources.get(0), (int)4105, (int)buffer);
            AL10.alSourcef((int)this.sources.get(0), (int)4099, (float)pitch);
            AL10.alSourcef((int)this.sources.get(0), (int)4106, (float)gain);
            AL10.alSourcei((int)this.sources.get(0), (int)4103, (int)1);
            this.currentMusic = this.sources.get(0);
            if (!this.music) {
                this.pauseLoop();
            } else {
                AL10.alSourcePlay((int)this.sources.get(0));
            }
        }
    }

    public void setMusicPitch(float pitch) {
        if (this.soundWorks) {
            AL10.alSourcef((int)this.sources.get(0), (int)4099, (float)pitch);
        }
    }

    public void pauseLoop() {
        if (this.soundWorks && this.currentMusic != -1) {
            AL10.alSourcePause((int)this.currentMusic);
        }
    }

    public void restartLoop() {
        if (this.music && this.soundWorks && this.currentMusic != -1) {
            AL10.alSourcePlay((int)this.currentMusic);
        }
    }

    public Sound getMOD(String ref) throws IOException {
        if (!this.soundWorks) {
            return new Sound(this, 0);
        }
        if (this.deferredLoading) {
            DeferredSound sound = new DeferredSound(ref, true);
            LoadingList.addLoadable((Loadable)sound);
            return sound;
        }
        return new MODSound(this, this.sources.get(0), ResourceLoader.getResourceAsStream((String)ref));
    }

    public Sound getOgg(String ref) throws IOException {
        if (!this.soundWorks) {
            return new Sound(this, 0);
        }
        if (this.deferredLoading) {
            DeferredSound sound = new DeferredSound(ref, false);
            LoadingList.addLoadable((Loadable)sound);
            return sound;
        }
        if (!this.inited) {
            throw new RuntimeException("Can't load sounds until SoundStore is init()");
        }
        int buffer = -1;
        if (this.loaded.get(ref) != null) {
            buffer = (Integer)this.loaded.get(ref);
        } else {
            Log.log((String)("Loading: " + ref));
            try {
                IntBuffer buf = BufferUtils.createIntBuffer((int)1);
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(ref);
                OggDecoder decoder = new OggDecoder();
                OggData ogg = decoder.getData(in);
                AL10.alGenBuffers((IntBuffer)buf);
                AL10.alBufferData((int)buf.get(0), (int)(ogg.channels > 1 ? 4355 : 4353), (ByteBuffer)ogg.data, (int)ogg.rate);
                this.loaded.put(ref, new Integer(buf.get(0)));
                buffer = buf.get(0);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                Sys.alert((String)"Error", (String)("Failed to load: " + ref + " - " + e.getMessage()));
                System.exit(0);
            }
        }
        if (buffer == -1) {
            throw new IOException("Unable to load: " + ref);
        }
        return new Sound(this, buffer);
    }

    void setMOD(MODSound sound) {
        if (!this.soundWorks) {
            return;
        }
        this.fadeIn = true;
        this.fade = 0.0f;
        this.currentMusic = this.sources.get(0);
        AL10.alSourcef((int)this.currentMusic, (int)4106, (float)(this.fade * this.musicVolume));
        this.mod = sound;
    }

    public void poll(int delta) {
        if (!this.soundWorks) {
            return;
        }
        if (this.music) {
            if (this.fadeIn && this.currentMusic != -1) {
                this.fade += 5.0E-4f * (float)delta;
                if (this.fade >= 1.0f) {
                    this.fade = 1.0f;
                    this.fadeIn = false;
                }
                AL10.alSourcef((int)this.currentMusic, (int)4106, (float)(this.fade * this.musicVolume));
            }
            if (this.mod != null) {
                this.mod.poll();
            }
        } else if (this.currentMusic != -1) {
            this.fadeIn = true;
            this.fade = 0.0f;
            AL10.alSourcef((int)this.currentMusic, (int)4106, (float)(this.fade * this.musicVolume));
        }
    }

    public static SoundStore get() {
        return store;
    }
}

