/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.sound;

import java.io.IOException;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.state.loading.Loadable;

public class DeferredSound
extends Sound
implements Loadable {
    private String ref;
    private boolean mod;
    private Sound target;

    public DeferredSound(String ref, boolean mod) {
        this.ref = ref;
        this.mod = mod;
    }

    public void load() throws IOException {
        SoundStore.get().setDeferredLoading(false);
        this.target = this.mod ? SoundStore.get().getMOD(this.ref) : SoundStore.get().getOgg(this.ref);
        SoundStore.get().setDeferredLoading(true);
    }

    public String getMessage() {
        return this.ref;
    }

    public void playAsMusic(float pitch, float gain) {
        this.checkTarget();
        this.target.playAsMusic(pitch, gain);
    }

    public void playAsSoundEffect(float pitch, float gain) {
        this.checkTarget();
        this.target.playAsSoundEffect(pitch, gain);
    }

    private void checkTarget() {
        if (this.target == null) {
            throw new RuntimeException("Deferred Loading requires a loading state to have completed init()");
        }
    }
}

