/*
 * Decompiled with CFR 0.152.
 */
package btthud.ui;

import btthud.data.MPrefs;
import btthud.ui.CustomCursors;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JToggleButton;

public class ToolPalette
extends JInternalFrame {
    public static final int TOOL_BUTTON_HEIGHT = 48;
    public static final int TOOL_BUTTON_WIDTH = 48;
    public static final Dimension TOOL_BUTTON_SIZE = new Dimension(48, 48);
    public static final int PAINT_TOOL = -10;
    public static final char PAINT_CHAR = 'p';
    public static final int SELECT_TOOL = -11;
    public static final char SELECT_CHAR = 's';
    public static final int SELECTIVE_UNDO_TOOL = -12;
    public static final char SELECTIVE_UNDO_CHAR = 'u';
    public static final int ERASE_TOOL = -13;
    public static final char ERASE_CHAR = 'e';
    int selectedTool;
    JToggleButton bPaint;
    JToggleButton bSelect;
    JToggleButton bSelectiveUndo;
    JToggleButton bErase;
    MPrefs prefs;

    public ToolPalette(MPrefs prefs) {
        super("Tools");
        this.prefs = prefs;
        this.setClosable(false);
        this.setResizable(false);
        this.setLayer(JLayeredPane.PALETTE_LAYER);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridLayout(2, 2, 0, 0));
        this.bPaint = new JToggleButton(CustomCursors.getPaintIcon());
        this.bPaint.setPreferredSize(new Dimension(32, 20));
        this.bPaint.setToolTipText("Paint Tool (p)");
        this.bPaint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ToolPalette.this.newToolSelected(-10);
            }
        });
        contentPane.add(this.bPaint);
        this.bSelect = new JToggleButton(CustomCursors.getSelectIcon());
        this.bSelect.setPreferredSize(new Dimension(32, 20));
        this.bSelect.setToolTipText("Select Tool (s)");
        this.bSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ToolPalette.this.newToolSelected(-11);
            }
        });
        contentPane.add(this.bSelect);
        this.bSelectiveUndo = new JToggleButton(CustomCursors.getSelectiveUndoIcon());
        this.bSelectiveUndo.setPreferredSize(new Dimension(32, 20));
        this.bSelectiveUndo.setToolTipText("Selective Undo Tool (u or right-click)");
        this.bSelectiveUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ToolPalette.this.newToolSelected(-12);
            }
        });
        contentPane.add(this.bSelectiveUndo);
        this.bErase = new JToggleButton(CustomCursors.getEraseIcon());
        this.bErase.setPreferredSize(new Dimension(32, 20));
        this.bErase.setToolTipText("Erase Tool (e)");
        this.bErase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ToolPalette.this.newToolSelected(-13);
            }
        });
        contentPane.add(this.bErase);
        this.selectedTool = -10;
        this.bPaint.setSelected(true);
        this.pack();
        this.setLocation(prefs.toolsLoc);
        this.show();
    }

    public int selectedTool() {
        return this.selectedTool;
    }

    public void newToolSelected(int tool) {
        this.buttonForTool(this.selectedTool).setSelected(false);
        this.buttonForTool(tool).setSelected(true);
        this.selectedTool = tool;
    }

    protected JToggleButton buttonForTool(int tool) {
        switch (tool) {
            case -10: {
                return this.bPaint;
            }
            case -11: {
                return this.bSelect;
            }
            case -12: {
                return this.bSelectiveUndo;
            }
            case -13: {
                return this.bErase;
            }
        }
        return null;
    }
}

