/*
 * Decompiled with CFR 0.152.
 */
package btthud.ui;

import btthud.data.MPrefs;
import btthud.ui.BrushToolOptions;
import btthud.ui.ElevationToolOptions;
import btthud.ui.InspectorPalette;
import btthud.ui.TerrainToolOptions;
import btthud.ui.ToolPalette;
import java.awt.Point;
import javax.swing.JDesktopPane;

public class ToolManager {
    ToolPalette mainTools;
    TerrainToolOptions terrTools;
    ElevationToolOptions elevTools;
    BrushToolOptions brushTools;
    InspectorPalette inspector;
    MPrefs prefs;
    boolean changeElevation = true;
    boolean changeTerrain = true;
    public static final int TERRAIN_AND_ELEVATION = -1;
    public static final int TERRAIN_ONLY = -2;
    public static final int ELEVATION_ONLY = -3;
    public static final int TOOL_PALETTE = 1;
    public static final int TERRAIN_PALETTE = 2;
    public static final int ELEVATION_PALETTE = 3;
    public static final int BRUSH_PALETTE = 4;
    public static final int INSPECTOR_PALETTE = 5;

    public ToolManager(JDesktopPane desktop, MPrefs prefs) {
        this.prefs = prefs;
        this.mainTools = new ToolPalette(prefs);
        this.mainTools.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.mainTools.setVisible(prefs.showTools);
        desktop.add(this.mainTools);
        this.terrTools = new TerrainToolOptions(prefs);
        this.terrTools.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.terrTools.setVisible(prefs.showTerrain);
        desktop.add(this.terrTools);
        this.elevTools = new ElevationToolOptions(prefs);
        this.elevTools.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.elevTools.setVisible(prefs.showElevation);
        desktop.add(this.elevTools);
        this.brushTools = new BrushToolOptions(prefs);
        this.brushTools.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.brushTools.setVisible(prefs.showBrush);
        desktop.add(this.brushTools);
        this.inspector = new InspectorPalette(prefs);
        this.inspector.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.inspector.setVisible(prefs.showInspector);
        desktop.add(this.inspector);
    }

    public int selectedTool() {
        return this.mainTools.selectedTool();
    }

    public void doSelectTool(int tool) {
        this.mainTools.newToolSelected(tool);
    }

    public int selectedTerrain() {
        return this.terrTools.selectedTerrain();
    }

    public void doSelectTerrain(char terr) {
        this.terrTools.selectToolForTerrain(terr);
    }

    public int selectedElevation() {
        return this.elevTools.selectedElevation();
    }

    public void doSelectElevation(int e) {
        this.elevTools.setElevation(e);
    }

    public int selectedBrushSize() {
        return this.brushTools.selectedBrush();
    }

    public void doSelectBrushSize(int size) {
        this.brushTools.selectBrushSize(size);
    }

    public boolean getChangeElevation() {
        return this.changeElevation;
    }

    public boolean getChangeTerrain() {
        return this.changeTerrain;
    }

    public void setChangeElevation(boolean b) {
        this.changeElevation = b;
    }

    public void setChangeTerrain(boolean b) {
        this.changeTerrain = b;
    }

    public void updatePaletteLocs() {
        this.prefs.toolsLoc = this.mainTools.getLocation();
        this.prefs.terrainToolsLoc = this.terrTools.getLocation();
        this.prefs.elevationToolsLoc = this.elevTools.getLocation();
        this.prefs.brushToolsLoc = this.brushTools.getLocation();
        this.prefs.inspectorLoc = this.inspector.getLocation();
    }

    public void setPaletteVisible(int palette, boolean vis) {
        switch (palette) {
            case 1: {
                this.mainTools.setVisible(vis);
                break;
            }
            case 2: {
                this.terrTools.setVisible(vis);
                break;
            }
            case 3: {
                this.elevTools.setVisible(vis);
                break;
            }
            case 4: {
                this.brushTools.setVisible(vis);
            }
        }
    }

    public void updateInspector(Point h) {
        this.inspector.updateLocation(h);
    }

    public String toString() {
        return "Main: " + this.mainTools.getLocation() + "\nTerr: " + this.terrTools.getLocation() + "\nElev: " + this.elevTools.getLocation() + "\nBrush: " + this.brushTools.getLocation() + "\nInsp: " + this.inspector.getLocation();
    }
}

