/*
 * Decompiled with CFR 0.152.
 */
package btthud.ui;

import btthud.data.MPrefs;
import btthud.data.MUXHex;
import btthud.ui.AboutBox;
import btthud.ui.CustomCursors;
import btthud.ui.ErrorHandler;
import btthud.ui.MUXMapFrame;
import btthud.ui.ReleaseNotesDialog;
import btthud.ui.ToolManager;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class Thump
extends JFrame
implements ActionListener,
InternalFrameListener,
WindowListener,
KeyListener {
    protected ResourceBundle resbundle;
    protected AboutBox aboutBox;
    static final JMenuBar mainMenuBar = new JMenuBar();
    protected JMenu fileMenu;
    protected JMenuItem miNew;
    protected JMenuItem miOpen;
    protected JMenuItem miClose;
    protected JMenuItem miSave;
    protected JMenuItem miSaveAs;
    protected JMenuItem miExportToPNG;
    protected JMenuItem miPageSetup;
    protected JMenuItem miPrint;
    protected JMenuItem miQuit;
    protected JMenu editMenu;
    protected JMenuItem miUndo;
    protected JMenuItem miCut;
    protected JMenuItem miCopy;
    protected JMenuItem miPaste;
    protected JMenuItem miDeselectAll;
    protected JMenu mapMenu;
    protected JMenuItem miZoomIn;
    protected JMenuItem miZoomOut;
    protected JMenu paintMenu;
    protected JCheckBoxMenuItem miTerrainAndElevation;
    protected JCheckBoxMenuItem miTerrainOnly;
    protected JCheckBoxMenuItem miElevationOnly;
    protected JMenu paletteMenu;
    protected JCheckBoxMenuItem miToolPalette;
    protected JCheckBoxMenuItem miTerrainToolPalette;
    protected JCheckBoxMenuItem miElevationToolPalette;
    protected JCheckBoxMenuItem miBrushToolPalette;
    protected JCheckBoxMenuItem miInspectorPalette;
    protected JMenu toolMenu;
    protected ButtonGroup toolGroup;
    protected JRadioButtonMenuItem miPaintTool;
    protected JRadioButtonMenuItem miSelectTool;
    protected JRadioButtonMenuItem miUndoTool;
    protected JRadioButtonMenuItem miEraseTool;
    protected JMenu elevationSubMenu;
    protected ButtonGroup elevationGroup;
    protected JRadioButtonMenuItem[] miElevations;
    protected JMenu terrainSubMenu;
    protected ButtonGroup terrainGroup;
    protected JRadioButtonMenuItem[] miTerrains;
    protected JMenu brushSizeSubMenu;
    protected ButtonGroup brushSizeGroup;
    protected JRadioButtonMenuItem[] miBrushSizes;
    protected JMenu helpMenu;
    protected JMenuItem miAbout;
    protected JMenuItem miHelp;
    JDesktopPane desktop;
    MPrefs prefs;
    ToolManager tools;
    LinkedList copyableHexes;
    Cursor crosshairCursor;
    Cursor terrainCursor;
    Cursor elevationCursor;
    Cursor pasteCursor;
    static final int DEFAULT_HEIGHT = 40;

    public void addFileMenuItems() {
        this.miNew = new JMenuItem("New...");
        this.miNew.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileMenu.add(this.miNew).setEnabled(true);
        this.miNew.addActionListener(this);
        this.miOpen = new JMenuItem("Open...");
        this.miOpen.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileMenu.add(this.miOpen).setEnabled(true);
        this.miOpen.addActionListener(this);
        this.miClose = new JMenuItem("Close");
        this.miClose.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileMenu.add(this.miClose).setEnabled(true);
        this.miClose.addActionListener(this);
        this.miSave = new JMenuItem("Save");
        this.miSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileMenu.add(this.miSave).setEnabled(true);
        this.miSave.addActionListener(this);
        this.miSaveAs = new JMenuItem("Save As...");
        this.fileMenu.add(this.miSaveAs).setEnabled(true);
        this.miSaveAs.addActionListener(this);
        this.miExportToPNG = new JMenuItem("Export to PNG...");
        this.fileMenu.add(this.miExportToPNG).setEnabled(true);
        this.miExportToPNG.addActionListener(this);
        this.fileMenu.addSeparator();
        this.miPageSetup = new JMenuItem("Page Setup...");
        this.miPageSetup.setAccelerator(KeyStroke.getKeyStroke(80, 1 + Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileMenu.add(this.miPageSetup).setEnabled(false);
        this.miPageSetup.addActionListener(this);
        this.miPrint = new JMenuItem("Print...");
        this.miPrint.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileMenu.add(this.miPrint).setEnabled(false);
        this.miPrint.addActionListener(this);
        this.fileMenu.addSeparator();
        this.miQuit = new JMenuItem("Quit");
        this.miQuit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileMenu.add(this.miQuit).setEnabled(true);
        this.miQuit.addActionListener(this);
        mainMenuBar.add(this.fileMenu);
    }

    public void addEditMenuItems() {
        this.miUndo = new JMenuItem("Undo");
        this.miUndo.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.editMenu.add(this.miUndo).setEnabled(false);
        this.miUndo.addActionListener(this);
        this.editMenu.addSeparator();
        this.miCut = new JMenuItem("Cut");
        this.miCut.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.editMenu.add(this.miCut).setEnabled(true);
        this.miCut.addActionListener(this);
        this.miCopy = new JMenuItem("Copy");
        this.miCopy.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.editMenu.add(this.miCopy).setEnabled(true);
        this.miCopy.addActionListener(this);
        this.miPaste = new JMenuItem("Paste");
        this.miPaste.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.editMenu.add(this.miPaste).setEnabled(true);
        this.miPaste.addActionListener(this);
        this.editMenu.addSeparator();
        this.miDeselectAll = new JMenuItem("Deselect All");
        this.miDeselectAll.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.editMenu.add(this.miDeselectAll).setEnabled(true);
        this.miDeselectAll.addActionListener(this);
        mainMenuBar.add(this.editMenu);
    }

    public void addMapMenuItems() {
        this.miZoomIn = new JMenuItem("Zoom In");
        this.miZoomIn.setAccelerator(KeyStroke.getKeyStroke(93, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.mapMenu.add(this.miZoomIn).setEnabled(true);
        this.miZoomIn.addActionListener(this);
        this.miZoomOut = new JMenuItem("Zoom Out");
        this.miZoomOut.setAccelerator(KeyStroke.getKeyStroke(91, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.mapMenu.add(this.miZoomOut).setEnabled(true);
        this.miZoomOut.addActionListener(this);
        mainMenuBar.add(this.mapMenu);
    }

    public void addPaintMenuItems() {
        this.miTerrainAndElevation = new JCheckBoxMenuItem("Terrain and Elevation", this.prefs.paintType == -1);
        this.miTerrainAndElevation.setAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.paintMenu.add(this.miTerrainAndElevation);
        this.miTerrainAndElevation.addActionListener(this);
        this.miTerrainOnly = new JCheckBoxMenuItem("Terrain Only", this.prefs.paintType == -2);
        this.miTerrainOnly.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.paintMenu.add(this.miTerrainOnly);
        this.miTerrainOnly.addActionListener(this);
        this.miElevationOnly = new JCheckBoxMenuItem("Elevation Only", this.prefs.paintType == -3);
        this.miElevationOnly.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.paintMenu.add(this.miElevationOnly);
        this.miElevationOnly.addActionListener(this);
        mainMenuBar.add(this.paintMenu);
    }

    public void addPaletteMenuItems() {
        this.miToolPalette = new JCheckBoxMenuItem("Show Tools Palette", this.prefs.showTools);
        this.paletteMenu.add(this.miToolPalette);
        this.miToolPalette.addActionListener(this);
        this.miTerrainToolPalette = new JCheckBoxMenuItem("Show Terrain Palette", this.prefs.showTerrain);
        this.paletteMenu.add(this.miTerrainToolPalette);
        this.miTerrainToolPalette.addActionListener(this);
        this.miElevationToolPalette = new JCheckBoxMenuItem("Show Elevation Palette", this.prefs.showElevation);
        this.paletteMenu.add(this.miElevationToolPalette);
        this.miElevationToolPalette.addActionListener(this);
        this.miBrushToolPalette = new JCheckBoxMenuItem("Show Brush Palette", this.prefs.showBrush);
        this.paletteMenu.add(this.miBrushToolPalette);
        this.miBrushToolPalette.addActionListener(this);
        this.miInspectorPalette = new JCheckBoxMenuItem("Show Inspector Palette", this.prefs.showInspector);
        this.paletteMenu.add(this.miInspectorPalette);
        this.miInspectorPalette.addActionListener(this);
        mainMenuBar.add(this.paletteMenu);
    }

    public void addToolMenuItems() {
        this.toolGroup = new ButtonGroup();
        this.miPaintTool = new JRadioButtonMenuItem("Paint Tool");
        this.miPaintTool.setAccelerator(KeyStroke.getKeyStroke('p'));
        this.miPaintTool.setSelected(true);
        this.toolGroup.add(this.miPaintTool);
        this.toolMenu.add(this.miPaintTool);
        this.miPaintTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Thump.this.tools.doSelectTool(-10);
                Thump.this.resetToolMenu();
            }
        });
        this.miSelectTool = new JRadioButtonMenuItem("Select Tool");
        this.miSelectTool.setAccelerator(KeyStroke.getKeyStroke('s'));
        this.toolGroup.add(this.miSelectTool);
        this.toolMenu.add(this.miSelectTool);
        this.miSelectTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Thump.this.tools.doSelectTool(-11);
                Thump.this.resetToolMenu();
            }
        });
        this.miUndoTool = new JRadioButtonMenuItem("Undo Tool");
        this.miUndoTool.setAccelerator(KeyStroke.getKeyStroke('u'));
        this.toolGroup.add(this.miUndoTool);
        this.toolMenu.add(this.miUndoTool);
        this.miUndoTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Thump.this.tools.doSelectTool(-12);
                Thump.this.resetToolMenu();
            }
        });
        this.miEraseTool = new JRadioButtonMenuItem("Erase Tool");
        this.miEraseTool.setAccelerator(KeyStroke.getKeyStroke('e'));
        this.toolGroup.add(this.miEraseTool);
        this.toolMenu.add(this.miEraseTool);
        this.miEraseTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Thump.this.tools.doSelectTool(-13);
                Thump.this.resetToolMenu();
            }
        });
        this.toolMenu.addSeparator();
        this.elevationSubMenu = new JMenu("Elevation");
        this.elevationGroup = new ButtonGroup();
        this.miElevations = new JRadioButtonMenuItem[10];
        int i = 0;
        while (i < 10) {
            this.miElevations[i] = new JRadioButtonMenuItem("Elevation " + i);
            this.miElevations[i].setAccelerator(KeyStroke.getKeyStroke(String.valueOf(i).charAt(0)));
            this.miElevations[i].setSelected(false);
            this.elevationGroup.add(this.miElevations[i]);
            this.elevationSubMenu.add(this.miElevations[i]);
            this.miElevations[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    JRadioButtonMenuItem m = (JRadioButtonMenuItem)event.getSource();
                    Thump.this.tools.doSelectElevation(Character.getNumericValue(m.getAccelerator().getKeyChar()));
                    Thump.this.resetToolMenu();
                }
            });
            ++i;
        }
        this.miElevations[0].setSelected(true);
        this.toolMenu.add(this.elevationSubMenu);
        this.toolMenu.addSeparator();
        this.terrainSubMenu = new JMenu("Terrain");
        this.terrainGroup = new ButtonGroup();
        this.miTerrains = new JRadioButtonMenuItem[11];
        int i2 = 0;
        while (i2 < 11) {
            this.miTerrains[i2] = new JRadioButtonMenuItem(MUXHex.nameForId(i2));
            this.miTerrains[i2].setAccelerator(KeyStroke.getKeyStroke(MUXHex.terrainForId(i2)));
            this.miTerrains[i2].setSelected(false);
            this.terrainGroup.add(this.miTerrains[i2]);
            this.terrainSubMenu.add(this.miTerrains[i2]);
            this.miTerrains[i2].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    JRadioButtonMenuItem m = (JRadioButtonMenuItem)event.getSource();
                    Thump.this.tools.doSelectTerrain(m.getAccelerator().getKeyChar());
                    Thump.this.resetToolMenu();
                }
            });
            ++i2;
        }
        this.miTerrains[MUXHex.idForTerrain('.')].setSelected(true);
        this.toolMenu.add(this.terrainSubMenu);
        this.toolMenu.addSeparator();
        this.brushSizeSubMenu = new JMenu("Brush Size");
        this.brushSizeGroup = new ButtonGroup();
        this.miBrushSizes = new JRadioButtonMenuItem[5];
        int i3 = 0;
        while (i3 < 5) {
            this.miBrushSizes[i3] = new JRadioButtonMenuItem("Brush Size " + (i3 + 1));
            this.miBrushSizes[i3].setAccelerator(KeyStroke.getKeyStroke((int)String.valueOf(i3 + 1).charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.miBrushSizes[i3].setSelected(false);
            this.brushSizeGroup.add(this.miBrushSizes[i3]);
            this.brushSizeSubMenu.add(this.miBrushSizes[i3]);
            this.miBrushSizes[i3].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    JRadioButtonMenuItem m = (JRadioButtonMenuItem)event.getSource();
                    String title = m.getText();
                    Thump.this.tools.doSelectBrushSize(Character.getNumericValue(title.charAt(title.length() - 1)));
                    Thump.this.resetToolMenu();
                }
            });
            ++i3;
        }
        this.miBrushSizes[0].setSelected(true);
        this.toolMenu.add(this.brushSizeSubMenu);
        mainMenuBar.add(this.toolMenu);
    }

    public void addHelpMenuItems() {
        this.miAbout = new JMenuItem("About Thump...");
        this.helpMenu.add(this.miAbout).setEnabled(true);
        this.miAbout.addActionListener(this);
        this.helpMenu.addSeparator();
        this.miHelp = new JMenuItem("Read Me / Help...");
        this.helpMenu.add(this.miHelp).setEnabled(true);
        this.miHelp.addActionListener(this);
        mainMenuBar.add(this.helpMenu);
    }

    public void addMenus() {
        this.editMenu = new JMenu("Edit");
        this.fileMenu = new JMenu("File");
        this.mapMenu = new JMenu("Map");
        this.paintMenu = new JMenu("Paint");
        this.paletteMenu = new JMenu("Palette");
        this.toolMenu = new JMenu("Tool");
        this.helpMenu = new JMenu("Help");
        this.addFileMenuItems();
        this.addEditMenuItems();
        this.addMapMenuItems();
        this.addPaintMenuItems();
        this.addPaletteMenuItems();
        this.addToolMenuItems();
        this.addHelpMenuItems();
        this.setJMenuBar(mainMenuBar);
    }

    public void resetMenus() {
        if (this.topFrame() != null) {
            this.miCut.setEnabled(this.topFrame().canCopy());
            this.miUndo.setEnabled(this.topFrame().canUndo());
            this.miPaste.setEnabled(this.canPaste());
            this.miCopy.setEnabled(this.topFrame().canCopy());
            this.miDeselectAll.setEnabled(this.topFrame().canCopy());
            this.miSave.setEnabled(true);
            this.miSaveAs.setEnabled(true);
            this.miExportToPNG.setEnabled(true);
            this.miClose.setEnabled(true);
            this.miZoomIn.setEnabled(true);
            this.miZoomOut.setEnabled(true);
        } else {
            this.miCut.setEnabled(false);
            this.miUndo.setEnabled(false);
            this.miPaste.setEnabled(false);
            this.miCopy.setEnabled(false);
            this.miDeselectAll.setEnabled(false);
            this.miSave.setEnabled(false);
            this.miSaveAs.setEnabled(false);
            this.miExportToPNG.setEnabled(false);
            this.miClose.setEnabled(false);
            this.miZoomIn.setEnabled(false);
            this.miZoomOut.setEnabled(false);
        }
        this.resetToolMenu();
    }

    public void resetToolMenu() {
        if (this.tools.selectedTool() == -10) {
            this.miPaintTool.setEnabled(true);
        } else if (this.tools.selectedTool() == -11) {
            this.miSelectTool.setEnabled(true);
        } else if (this.tools.selectedTool() == -12) {
            this.miUndoTool.setEnabled(true);
        } else if (this.tools.selectedTool() == -13) {
            this.miEraseTool.setEnabled(true);
        }
        this.miElevations[this.tools.selectedElevation()].setEnabled(true);
        this.miTerrains[this.tools.selectedTerrain()].setEnabled(true);
        this.miBrushSizes[this.tools.selectedBrushSize() + 1].setEnabled(true);
        if (this.tools != null && this.topFrame() != null) {
            this.topFrame().resetCursor();
        }
    }

    public void updateInspector(Point h) {
        this.tools.updateInspector(h);
    }

    public void handleAbout() {
        this.aboutBox.setResizable(false);
        this.aboutBox.setVisible(true);
        this.aboutBox.show();
    }

    protected void makeNewMapFrame(File file) {
        int mapSize = 0;
        if (file == null) {
            String mapSizeStr = JOptionPane.showInputDialog(this, "What size should this new map be?\n(Only square maps are currently supported)", "Map Size", 3);
            try {
                if (mapSizeStr == null) {
                    return;
                }
                mapSize = Integer.parseInt(mapSizeStr);
                if (mapSize <= 0 || mapSize > 1000) {
                    throw new Exception("mapSize must be between 1 and 1000");
                }
            }
            catch (Exception e) {
                ErrorHandler.displayError("The map size must be an whole number between 1 and 1000.", 3);
                this.makeNewMapFrame(null);
            }
        }
        MUXMapFrame newMap = new MUXMapFrame(this, file, mapSize, this.prefs, 40, this.tools);
        newMap.setVisible(true);
        this.desktop.add(newMap);
        try {
            newMap.setSelected(true);
        }
        catch (Exception e) {
            ErrorHandler.displayError("Error: makeNewMapperFrame: " + e);
        }
        newMap.addInternalFrameListener(this);
    }

    protected MUXMapFrame topFrame() {
        if (this.desktop.getSelectedFrame() instanceof MUXMapFrame) {
            return (MUXMapFrame)this.desktop.getSelectedFrame();
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.matchesMenu(e, this.miNew)) {
            this.doNew();
        } else if (this.matchesMenu(e, this.miOpen)) {
            this.doOpen();
        } else if (this.matchesMenu(e, this.miClose)) {
            this.doClose();
        } else if (this.matchesMenu(e, this.miSave)) {
            this.doSave();
        } else if (this.matchesMenu(e, this.miSaveAs)) {
            this.doSaveAs();
        } else if (this.matchesMenu(e, this.miExportToPNG)) {
            this.doExportToPNG();
        } else if (this.matchesMenu(e, this.miPageSetup)) {
            this.doPageSetup();
        } else if (this.matchesMenu(e, this.miPrint)) {
            this.doPrint();
        } else if (this.matchesMenu(e, this.miQuit)) {
            this.doQuit();
        } else if (this.matchesMenu(e, this.miUndo)) {
            this.doUndo();
        } else if (this.matchesMenu(e, this.miCut)) {
            this.doCut();
        } else if (this.matchesMenu(e, this.miCopy)) {
            this.doCopy();
        } else if (this.matchesMenu(e, this.miPaste)) {
            this.doPaste();
        } else if (this.matchesMenu(e, this.miDeselectAll)) {
            this.doDeselectAll();
        } else if (this.matchesMenu(e, this.miZoomIn)) {
            this.doZoom(5);
        } else if (this.matchesMenu(e, this.miZoomOut)) {
            this.doZoom(-5);
        } else if (this.matchesMenu(e, this.miTerrainAndElevation)) {
            this.doSetPaintType(-1);
        } else if (this.matchesMenu(e, this.miTerrainOnly)) {
            this.doSetPaintType(-2);
        } else if (this.matchesMenu(e, this.miElevationOnly)) {
            this.doSetPaintType(-3);
        } else if (this.matchesMenu(e, this.miToolPalette)) {
            this.doHandlePalette(1);
        } else if (this.matchesMenu(e, this.miTerrainToolPalette)) {
            this.doHandlePalette(2);
        } else if (this.matchesMenu(e, this.miElevationToolPalette)) {
            this.doHandlePalette(3);
        } else if (this.matchesMenu(e, this.miBrushToolPalette)) {
            this.doHandlePalette(4);
        } else if (this.matchesMenu(e, this.miInspectorPalette)) {
            this.doHandlePalette(5);
        } else if (this.matchesMenu(e, this.miAbout)) {
            this.doAbout();
        } else if (this.matchesMenu(e, this.miHelp)) {
            this.doHelp();
        }
        this.resetMenus();
    }

    protected boolean matchesMenu(ActionEvent e, JMenuItem mi) {
        return e.getActionCommand().equals(mi.getActionCommand()) && mi.isEnabled();
    }

    public void doAbout() {
        AboutBox about = new AboutBox();
        about.show();
    }

    public void doHelp() {
        ReleaseNotesDialog helpBox = new ReleaseNotesDialog((Frame)this, true);
        helpBox.show();
    }

    public void doNew() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.makeNewMapFrame(null);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.resetMenus();
    }

    public void doOpen() {
        FileDialog openDialog = new FileDialog((Frame)this, "Open a Map File...", 0);
        openDialog.show();
        if (openDialog.getFile() != null) {
            File openFile = new File(openDialog.getDirectory() + openDialog.getFile());
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.makeNewMapFrame(openFile);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.resetMenus();
    }

    public void doClose() {
        if (this.topFrame() != null) {
            this.closeFrame(this.topFrame());
        }
        this.resetMenus();
    }

    public void doSave() {
        if (this.topFrame() != null) {
            this.saveFrame(this.topFrame());
        }
    }

    public void doSaveAs() {
        if (this.topFrame() != null) {
            this.saveFrameAs(this.topFrame());
        }
    }

    public void doExportToPNG() {
        block3: {
            if (this.topFrame() == null) break block3;
            FileDialog saveImageDialog = new FileDialog((Frame)this, "Save as PNG...", 1);
            String fileName = this.topFrame().fileName();
            saveImageDialog.setFile(fileName.substring(0, fileName.length() - 3) + "png");
            saveImageDialog.show();
            if (saveImageDialog.getFile() != null) {
                try {
                    File imageFile = new File(saveImageDialog.getDirectory() + saveImageDialog.getFile());
                    imageFile.createNewFile();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    boolean savedOkay = this.topFrame().saveMapAsImage(imageFile);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (Exception e) {
                    ErrorHandler.displayError("Can't write to file. Maybe it's locked.", 1);
                }
            }
        }
    }

    public void doPageSetup() {
    }

    public void doPrint() {
        if (this.topFrame() != null) {
            this.topFrame().doPrint();
        }
    }

    public void doQuit() {
        JInternalFrame[] maps = this.desktop.getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER);
        int i = 0;
        while (i < maps.length) {
            if (!this.closeFrame((MUXMapFrame)maps[i])) {
                return;
            }
            ++i;
        }
        this.writePrefs();
        System.exit(0);
    }

    protected void disposeOfFrame(MUXMapFrame f) {
        this.prefs.mapFrameLoc = f.getLocation();
        f.dispose();
        this.writePrefs();
    }

    public void doUndo() {
        this.topFrame().doUndo();
        if (!this.topFrame().canUndo()) {
            this.miUndo.setEnabled(false);
        }
    }

    public void doCut() {
        this.copyableHexes = this.topFrame().copyableHexes();
        this.topFrame().doCut();
    }

    public void doCopy() {
        this.copyableHexes = this.topFrame().copyableHexes();
    }

    public void doPaste() {
        if (this.copyableHexes != null) {
            this.topFrame().pasteHexes(this.copyableHexes);
        }
    }

    public void doDeselectAll() {
        this.topFrame().deselectAll();
    }

    public void doZoom(int z) {
        if (this.topFrame() != null) {
            this.topFrame().adjustZoom(z, new Point(-1, -1));
        }
    }

    public void doSetPaintType(int type) {
        this.prefs.paintType = type;
        this.miTerrainAndElevation.setState(type == -1);
        this.miTerrainOnly.setState(type == -2);
        this.miElevationOnly.setState(type == -3);
        JInternalFrame[] allFrames = this.desktop.getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER);
        this.topFrame().resetCursor();
    }

    public void doHandlePalette(int palette) {
        switch (palette) {
            case 1: {
                this.prefs.showTools = !this.prefs.showTools;
                this.miToolPalette.setState(this.prefs.showTools);
                this.tools.setPaletteVisible(1, this.prefs.showTools);
                break;
            }
            case 2: {
                this.prefs.showTerrain = !this.prefs.showTerrain;
                this.miTerrainToolPalette.setState(this.prefs.showTerrain);
                this.tools.setPaletteVisible(2, this.prefs.showTerrain);
                break;
            }
            case 3: {
                this.prefs.showElevation = !this.prefs.showElevation;
                this.miElevationToolPalette.setState(this.prefs.showElevation);
                this.tools.setPaletteVisible(3, this.prefs.showElevation);
                break;
            }
            case 4: {
                this.prefs.showBrush = !this.prefs.showBrush;
                this.miBrushToolPalette.setState(this.prefs.showBrush);
                this.tools.setPaletteVisible(4, this.prefs.showBrush);
                break;
            }
            case 5: {
                this.prefs.showInspector = !this.prefs.showInspector;
                this.miInspectorPalette.setState(this.prefs.showInspector);
                this.tools.setPaletteVisible(5, this.prefs.showInspector);
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public boolean closeFrame(MUXMapFrame f) {
        if (f != null) {
            if (f.hasChanged()) {
                String messageText = "The map \"" + f.fileName() + "\" has changed. Do you wish to save it before closing?";
                int optionChosen = JOptionPane.showConfirmDialog(this, messageText, "Save map?", 1);
                if (optionChosen == 2 || optionChosen == -1) {
                    return false;
                }
                if (optionChosen == 1) {
                    this.disposeOfFrame(f);
                    return true;
                }
                boolean saveOkay = f.newFile() ? this.saveFrameAs(f) : this.saveFrame(f);
                if (saveOkay) {
                    this.disposeOfFrame(f);
                }
                return saveOkay;
            }
            this.disposeOfFrame(f);
            return true;
        }
        return true;
    }

    public boolean saveFrameAs(MUXMapFrame f) {
        FileDialog saveDialog = new FileDialog((Frame)this, "Save a Map File...", 1);
        saveDialog.setFile(f.fileName());
        saveDialog.show();
        if (saveDialog.getFile() != null) {
            try {
                File saveAsFile = new File(saveDialog.getDirectory() + saveDialog.getFile());
                saveAsFile.createNewFile();
                this.setCursor(Cursor.getPredefinedCursor(3));
                boolean savedOkay = f.saveMapAs(saveAsFile);
                this.setCursor(Cursor.getPredefinedCursor(0));
                return savedOkay;
            }
            catch (Exception e) {
                ErrorHandler.displayError("Can't write to file. Maybe it's locked.", 1);
                return false;
            }
        }
        return false;
    }

    public boolean saveFrame(MUXMapFrame f) {
        if (f != null) {
            if (f.newFile()) {
                return this.saveFrameAs(f);
            }
            if (f.hasChanged()) {
                return f.saveMap();
            }
            return true;
        }
        return true;
    }

    public void internalFrameClosing(InternalFrameEvent e) {
        this.closeFrame((MUXMapFrame)e.getInternalFrame());
    }

    public void internalFrameClosed(InternalFrameEvent e) {
        this.resetMenus();
    }

    public void internalFrameOpened(InternalFrameEvent e) {
        this.resetMenus();
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
        this.resetMenus();
    }

    public void internalFrameIconified(InternalFrameEvent e) {
        this.resetMenus();
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        this.resetMenus();
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
        this.resetMenus();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this.writePrefs();
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void readPrefs() {
        block3: {
            this.prefs = new MPrefs();
            try {
                File prefsFile = new File("thump.prf");
                if (prefsFile.createNewFile()) {
                    this.prefs.defaultPrefs();
                    break block3;
                }
                FileInputStream fis = new FileInputStream(prefsFile);
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.prefs = (MPrefs)ois.readObject();
                fis.close();
            }
            catch (Exception e) {
                this.prefs.defaultPrefs();
            }
        }
    }

    public void writePrefs() {
        this.prefs.desktopLoc = this.getLocation();
        this.prefs.desktopSize = this.getSize();
        this.tools.updatePaletteLocs();
        try {
            File prefsFile = new File("thump.prf");
            prefsFile.createNewFile();
            FileOutputStream fis = new FileOutputStream(prefsFile);
            ObjectOutputStream oos = new ObjectOutputStream(fis);
            oos.writeObject(this.prefs);
            oos.flush();
            fis.close();
        }
        catch (Exception e) {
            System.out.println("Error: writePrefs: " + e);
        }
    }

    protected boolean canPaste() {
        return this.copyableHexes != null && this.copyableHexes.size() > 0;
    }

    public Thump() {
        super("");
        Toolkit.getDefaultToolkit();
        CustomCursors.createCustomCursors();
        this.resbundle = ResourceBundle.getBundle("Thumpstrings", Locale.getDefault());
        this.setTitle("Thump");
        this.readPrefs();
        this.desktop = new JDesktopPane();
        this.setContentPane(this.desktop);
        this.setSize(this.prefs.desktopSize);
        this.setLocation(this.prefs.desktopLoc);
        this.addMenus();
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.tools = new ToolManager(this.desktop, this.prefs);
        this.aboutBox = new AboutBox();
        this.resetMenus();
        this.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        new Thump();
    }
}

