/*
 * Decompiled with CFR 0.152.
 */
package btthud.ui;

import btthud.data.MPrefs;
import btthud.data.MUXHex;
import btthud.ui.CustomCursors;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JToggleButton;

public class TerrainToolOptions
extends JInternalFrame {
    JToggleButton[] bTerrain = new JToggleButton[11];
    int selectedTool;
    MPrefs prefs;

    public TerrainToolOptions(MPrefs prefs) {
        super("Terrain Options");
        this.prefs = prefs;
        this.selectedTool = 1;
        this.setClosable(false);
        this.setResizable(false);
        this.setLayer(JLayeredPane.PALETTE_LAYER);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridLayout(6, 2, 0, 0));
        int i = 0;
        while (i < 11) {
            this.bTerrain[i] = new JToggleButton(CustomCursors.getTerrainIcon(i), i == this.selectedTool);
            this.bTerrain[i].setPreferredSize(new Dimension(32, 32));
            this.bTerrain[i].setToolTipText(MUXHex.nameForId(i) + " (" + MUXHex.terrainForId(i) + ")");
            this.bTerrain[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    TerrainToolOptions.this.terrTypeSelected((JToggleButton)event.getSource());
                }
            });
            contentPane.add(this.bTerrain[i]);
            ++i;
        }
        this.pack();
        this.setLocation(prefs.terrainToolsLoc);
        this.show();
    }

    public int selectedTerrain() {
        return this.selectedTool;
    }

    public void terrTypeSelected(JToggleButton b) {
        int newTool = -1;
        int i = 0;
        while (i < 11) {
            if (this.bTerrain[i] == b) {
                newTool = i;
            } else {
                this.bTerrain[i].setSelected(false);
            }
            ++i;
        }
        b.setSelected(true);
        this.selectedTool = newTool;
    }

    public static int toolForChar(char c) {
        int i = 0;
        while (i < MUXHex.PAINTABLE_TERRAIN_TYPES.length) {
            if (MUXHex.PAINTABLE_TERRAIN_TYPES[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void selectToolForTerrain(char t) {
        this.terrTypeSelected(this.bTerrain[MUXHex.idForTerrain(t)]);
    }
}

