/*
 * Decompiled with CFR 0.152.
 */
package btthud.ui;

import btthud.ui.HexShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class Rule
extends JComponent {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public int orientation;
    int h;
    int max;
    int size;
    Rectangle2D stringRect;
    Font hexNumberFont;
    FontRenderContext frc;
    int preferredHeight = 0;
    int preferredWidth = 0;
    RenderingHints rHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);

    public Rule(int orientation, int h, int max, int fontSize) {
        this.orientation = orientation;
        this.h = h;
        this.max = max;
        this.rHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.hexNumberFont = new Font("Monospaced", 1, fontSize);
        this.frc = new FontRenderContext(new AffineTransform(), false, false);
        this.stringRect = this.hexNumberFont.getStringBounds(Integer.toString(max), this.frc);
        this.size = (int)this.stringRect.getHeight();
    }

    public void setPreferredHeight(int ph) {
        this.setPreferredSize(new Dimension(this.size, ph));
        this.preferredHeight = ph;
    }

    public void setPreferredWidth(int pw) {
        this.setPreferredSize(new Dimension(pw, this.size));
        this.preferredWidth = pw;
    }

    public void paintComponent(Graphics gfx) {
        Graphics2D g = (Graphics2D)gfx;
        Rectangle bounds = g.getClipBounds();
        AffineTransform oldTrans = g.getTransform();
        AffineTransform trans = new AffineTransform(oldTrans);
        HexShape hexPoly = new HexShape(this.h);
        Point2D.Double realHex = new Point2D.Double();
        g.addRenderingHints(this.rHints);
        g.setColor(Color.black);
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g.setFont(this.hexNumberFont);
        int skip = this.h <= 5 ? 5 : (this.h <= 10 ? 3 : (this.h <= 20 ? 2 : 1));
        if (this.orientation == 1) {
            int i = 0;
            while (i < this.max) {
                if (i % 2 == 0) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.lightGray);
                }
                trans.setTransform(oldTrans);
                hexPoly.hexToReal(0, i, 1, realHex);
                trans.translate(3.0, ((Point2D)realHex).getY());
                trans.rotate(1.5707963267948966);
                g.setTransform(trans);
                g.drawString(Integer.toString(i), 0, 0);
                i += skip;
            }
        } else {
            int i = 0;
            while (i < this.max) {
                trans.setTransform(oldTrans);
                if (i % 2 == 0) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.lightGray);
                }
                if (i % 2 == 0) {
                    trans.translate(0.0, this.h / 2);
                }
                hexPoly.hexToReal(i, 0, 1, realHex);
                trans.translate(((Point2D)realHex).getX(), -((Point2D)realHex).getY() + this.stringRect.getHeight() - 2.0);
                g.setTransform(trans);
                g.drawString(Integer.toString(i), 0, 0);
                i += skip;
            }
        }
        g.setTransform(oldTrans);
    }
}

