/*
 * Decompiled with CFR 0.152.
 */
package btthud.ui;

import btthud.data.ChangedMUXHex;
import btthud.data.CopyableMUXHex;
import btthud.data.MPrefs;
import btthud.data.MUXHex;
import btthud.data.MUXMap;
import btthud.ui.BrushToolOptions;
import btthud.ui.Corner;
import btthud.ui.CustomCursors;
import btthud.ui.ErrorHandler;
import btthud.ui.MUXMapComponent;
import btthud.ui.Rule;
import btthud.ui.Thump;
import btthud.ui.ToolManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class MUXMapFrame
extends JInternalFrame
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    Thump mapper;
    MUXMap map;
    MPrefs prefs;
    Thread thread = null;
    private boolean go = true;
    MUXMapComponent mapComponent = null;
    JScrollPane scrollPane = null;
    File file;
    int h;
    static int documentsOpened = 1;
    boolean newFile;
    ToolManager tools;
    static final int MAX_UNDO = 20;
    LinkedList undoableChanges;
    boolean dragging = false;
    LinkedList changedHexes = new LinkedList();
    boolean pasting = false;
    LinkedList pasteHexes;

    public MUXMapFrame(Thump mapper, File file, int mapSize, MPrefs prefs, int hexHeight, ToolManager tools) {
        super("Untitled");
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.mapper = mapper;
        this.tools = tools;
        this.file = file;
        if (file == null) {
            this.map = new MUXMap(mapSize, mapSize);
            this.map.clearMap();
            this.setTitle("Untitled " + documentsOpened + this.sizeString());
            this.file = new File("Untitled " + documentsOpened);
            ++documentsOpened;
            this.newFile = true;
        } else {
            this.readMap();
            this.setTitle(file.getName() + this.sizeString());
            this.newFile = false;
        }
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.prefs = prefs;
        this.h = hexHeight;
        this.mapComponent = new MUXMapComponent(this.map, prefs, this.h);
        this.mapComponent.setPreferredSize(new Dimension(this.mapComponent.getTotalWidth(), this.mapComponent.getTotalHeight()));
        this.mapComponent.addMouseListener(this);
        this.mapComponent.addMouseMotionListener(this);
        this.mapComponent.addMouseWheelListener(this);
        this.resetCursor();
        Rule xRule = new Rule(0, this.h, this.map.getSizeX(), prefs.hexNumberFontSize);
        Rule yRule = new Rule(1, this.h, this.map.getSizeY(), prefs.hexNumberFontSize);
        xRule.setPreferredWidth(this.mapComponent.getTotalWidth());
        yRule.setPreferredHeight(this.mapComponent.getTotalHeight());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewport(new JViewport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setViewPosition(Point p) {
                Object object = MUXMapFrame.this.scrollPane.getTreeLock();
                synchronized (object) {
                    super.setViewPosition(p);
                }
            }
        });
        this.scrollPane.getViewport().add((Component)this.mapComponent, null);
        this.scrollPane.setColumnHeaderView(xRule);
        this.scrollPane.setRowHeaderView(yRule);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", new Corner());
        this.scrollPane.setWheelScrollingEnabled(false);
        this.scrollPane.doLayout();
        this.setContentPane(this.scrollPane);
        this.setSize(prefs.mapFrameSize);
        this.setLocation((int)prefs.mapFrameLoc.getX() + (documentsOpened - 1) * 10 % (int)prefs.desktopSize.getWidth(), (int)prefs.mapFrameLoc.getY() + (documentsOpened - 1) * 10 % (int)prefs.desktopSize.getHeight());
        this.undoableChanges = new LinkedList();
        this.show();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void resetCursor() {
        if (this.pasting) {
            this.mapComponent.setCursor(CustomCursors.getPasteCursor());
        } else if (this.prefs.paintType == -2) {
            this.mapComponent.setCursor(CustomCursors.getTerrainCursor());
        } else if (this.prefs.paintType == -3) {
            this.mapComponent.setCursor(CustomCursors.getElevationCursor());
        } else if (this.tools.selectedTool() == -12) {
            this.mapComponent.setCursor(CustomCursors.getUndoCursor());
        } else {
            this.mapComponent.setCursor(CustomCursors.getCrosshairCursor());
        }
    }

    public void adjustZoom(int zoom, Point mouseCoords) {
        Rectangle viewRect = this.scrollPane.getViewport().getViewRect();
        Point p = this.scrollPane.getViewport().toViewCoordinates(mouseCoords);
        Point centerHex = this.mapComponent.realToHex(p.getX() == -1.0 ? (int)(viewRect.getX() + viewRect.getWidth() / 2.0) : (int)p.getX(), p.getY() == -1.0 ? (int)(viewRect.getY() + viewRect.getHeight() / 2.0) : (int)p.getY());
        this.h += zoom;
        if (this.h < 5) {
            this.h = 5;
        }
        if (this.h > 300) {
            this.h = 300;
        }
        this.newPreferences(this.prefs, this.h);
        Point2D newRealCenterOfHex = this.mapComponent.centerOfHex((int)centerHex.getX(), (int)centerHex.getY());
        this.mapComponent.scrollRectToVisible(new Rectangle((int)(newRealCenterOfHex.getX() - viewRect.getWidth() / 2.0), (int)(newRealCenterOfHex.getY() - viewRect.getHeight() / 2.0), (int)viewRect.getWidth(), (int)viewRect.getHeight()));
    }

    public void newPreferences(MPrefs prefs, int hexHeight) {
        this.mapComponent.newPreferences(prefs, hexHeight);
        this.h = hexHeight;
        this.mapComponent.setPreferredSize(new Dimension(this.mapComponent.getTotalWidth(), this.mapComponent.getTotalHeight()));
        Rule xRule = new Rule(0, this.h, this.map.getSizeX(), prefs.hexNumberFontSize);
        Rule yRule = new Rule(1, this.h, this.map.getSizeY(), prefs.hexNumberFontSize);
        xRule.setPreferredWidth(this.mapComponent.getTotalWidth());
        yRule.setPreferredHeight(this.mapComponent.getTotalHeight());
        this.scrollPane.setColumnHeaderView(xRule);
        this.scrollPane.setRowHeaderView(yRule);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", new Corner());
        this.scrollPane.doLayout();
        this.scrollPane.repaint();
    }

    void readMap() {
        try {
            FileReader mapFile = new FileReader(this.file);
            StringBuffer buf = new StringBuffer();
            boolean done = false;
            while (!done) {
                int read = mapFile.read();
                if (read == -1) {
                    done = true;
                    continue;
                }
                buf.append((char)read);
            }
            mapFile.close();
            this.parseMap(buf.toString());
        }
        catch (Exception e) {
            ErrorHandler.displayError("Could not read the map file data.", 2);
        }
    }

    void parseMap(String mapData) {
        try {
            StringTokenizer st = new StringTokenizer(mapData);
            int x = 0;
            int y = 0;
            int sizeX = Integer.parseInt(st.nextToken());
            int sizeY = Integer.parseInt(st.nextToken());
            this.map = new MUXMap(sizeX, sizeY);
            while (st.hasMoreTokens()) {
                String thisLine = st.nextToken();
                if (!thisLine.equals("-1") && !thisLine.startsWith("-1 ")) {
                    x = 0;
                    while (x < sizeX * 2) {
                        char t = thisLine.charAt(x);
                        int e = Character.digit(thisLine.charAt(x + 1), 10);
                        this.map.setHex(x / 2, y, t, e);
                        x += 2;
                    }
                    ++y;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error: readMap: " + e);
        }
    }

    public boolean saveMapAs(File newFile) {
        this.file = newFile;
        return this.saveMap();
    }

    public boolean saveMap() {
        try {
            StringBuffer buf = new StringBuffer();
            if (!this.file.canWrite()) {
                ErrorHandler.displayError("Could not write to map file. Maybe it's locked.", 1);
                return false;
            }
            this.file.createNewFile();
            FileWriter mapWriter = new FileWriter(this.file);
            buf.append(this.map.getSizeX());
            buf.append(" ");
            buf.append(this.map.getSizeY());
            buf.append("\n");
            int y = 0;
            while (y < this.map.getSizeY()) {
                int x = 0;
                while (x < this.map.getSizeX()) {
                    buf.append(MUXHex.terrainForId(this.map.getHexTerrain(x, y)));
                    buf.append(this.map.getHexAbsoluteElevation(x, y));
                    ++x;
                }
                buf.append("\n");
                ++y;
            }
            mapWriter.write(buf.toString());
            mapWriter.close();
            this.map.setChanged(false);
            this.setTitle(this.file.getName() + this.sizeString());
            return true;
        }
        catch (Exception e) {
            ErrorHandler.displayError("Could not write data to map file:\n" + e, 1);
            return false;
        }
    }

    public boolean saveMapAsImage(File imageFile) {
        try {
            BufferedImage mapImage = new BufferedImage((int)this.mapComponent.getPreferredSize().getWidth(), (int)this.mapComponent.getPreferredSize().getHeight(), 2);
            Graphics2D mapImageGraphics = mapImage.createGraphics();
            if (!imageFile.canWrite()) {
                ErrorHandler.displayError("Could not write to image file. Maybe it's locked.", 1);
                return false;
            }
            this.mapComponent.paint2d(mapImageGraphics);
            ImageIO.write((RenderedImage)mapImage, "png", imageFile);
            return true;
        }
        catch (Exception e) {
            ErrorHandler.displayError("Could not write data to map file:\n" + e, 1);
            return false;
        }
    }

    protected boolean terrainToolClicked(ListIterator it) {
        Point h = null;
        boolean hadHexes = it.hasNext();
        while (it.hasNext()) {
            h = (Point)it.next();
            if (this.map.getHexTerrain(h) != this.tools.selectedTerrain()) {
                if (!this.hexAlreadyChanged(h)) {
                    this.changedHexes.addLast(new ChangedMUXHex(h, this.map.getHex(h)));
                }
                this.map.setHexTerrain(h, this.tools.selectedTerrain());
                this.mapComponent.repaint(this.mapComponent.rectForHex(h));
                continue;
            }
            it.remove();
        }
        return hadHexes;
    }

    protected boolean elevationToolClicked(ListIterator it) {
        boolean hadHexes = it.hasNext();
        while (it.hasNext()) {
            Point h = (Point)it.next();
            if (this.map.getHexElevation(h) != this.tools.selectedElevation()) {
                if (!this.hexAlreadyChanged(h)) {
                    this.changedHexes.addLast(new ChangedMUXHex(h, this.map.getHex(h)));
                }
                this.map.setHexElevation(h, this.tools.selectedElevation());
                this.mapComponent.repaint(this.mapComponent.rectForHex(h));
                continue;
            }
            it.remove();
        }
        return hadHexes;
    }

    protected boolean pasteTool(ArrayList hexes, ArrayList terrain, ArrayList elevation) {
        boolean changedHex = false;
        int i = 0;
        while (i < hexes.size()) {
            if (this.map.getHexTerrain((Point)hexes.get(i)) != ((Integer)terrain.get(i)).intValue() || this.map.getHexElevation((Point)hexes.get(i)) != ((Integer)elevation.get(i)).intValue()) {
                changedHex = true;
                this.changedHexes.addLast(new ChangedMUXHex((Point)hexes.get(i), this.map.getHex((Point)hexes.get(i))));
                this.map.setHex((Point)hexes.get(i), (Integer)terrain.get(i), (int)((Integer)elevation.get(i)));
                this.mapComponent.repaint(this.mapComponent.rectForHex((Point)hexes.get(i)));
            }
            ++i;
        }
        return changedHex;
    }

    protected boolean bothToolClicked(ListIterator it, boolean erase) {
        int selectedTerrain = this.tools.selectedTerrain();
        int selectedElevation = this.tools.selectedElevation();
        boolean hadHexes = it.hasNext();
        if (erase) {
            selectedTerrain = 1;
            selectedElevation = 0;
        }
        while (it.hasNext()) {
            Point h = (Point)it.next();
            if (this.map.getHexElevation(h) != selectedTerrain || this.map.getHexTerrain(h) != selectedElevation) {
                if (!this.hexAlreadyChanged(h)) {
                    this.changedHexes.addLast(new ChangedMUXHex(h, this.map.getHex(h)));
                }
                this.map.setHex(h, selectedTerrain, selectedElevation);
                this.mapComponent.repaint(this.mapComponent.rectForHex(h));
                continue;
            }
            it.remove();
        }
        return hadHexes;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean selectToolClicked(ListIterator it, MouseEvent e) {
        block4: {
            r = new Rectangle2D.Double();
            if (!e.isControlDown()) ** GOTO lbl12
            this.map.deselectAll();
            this.mapComponent.repaint();
            break block4;
lbl-1000:
            // 1 sources

            {
                h = (Point)it.next();
                if (!this.map.getHexSelected(h)) {
                    this.map.setHexSelected(h, true);
                    this.mapComponent.repaint(this.mapComponent.rectForHex(h));
                    continue;
                }
                it.remove();
lbl12:
                // 3 sources

                ** while (it.hasNext())
            }
lbl13:
            // 1 sources

            if (this.map.anyHexesSelected()) {
                selectedIt = this.map.selectedHexesIterator();
                while (selectedIt.hasNext()) {
                    h = (Point)selectedIt.next();
                    this.mapComponent.expandedRectForHex(h, r);
                    this.mapComponent.repaint(r);
                }
            }
        }
        this.mapper.resetMenus();
        return false;
    }

    protected boolean hexClicked(Point hex, MouseEvent e) {
        int whichTool = this.tools.selectedTool();
        LinkedList<Point> hexes = new LinkedList<Point>();
        int i = 0;
        while (i <= this.tools.selectedBrushSize()) {
            int j = 0;
            while (j < BrushToolOptions.brushHexSizes[i]) {
                Point thisHex = new Point((int)(hex.getX() + (double)BrushToolOptions.brushX[i][j]), (int)(hex.getY() + (double)BrushToolOptions.brushY[hex.getX() % 2.0 == 1.0 ? 1 : 0][i][j]));
                if (this.map.validHex(thisHex)) {
                    hexes.add(thisHex);
                }
                ++j;
            }
            ++i;
        }
        if (this.tools.selectedTool() == -12 || (e.getModifiers() & 8) == 8 || (e.getModifiers() & 4) == 4) {
            return this.selectiveUndoClicked(hex);
        }
        if (this.tools.selectedTool() == -10) {
            if (this.prefs.paintType == -2) {
                return this.terrainToolClicked(hexes.listIterator(0));
            }
            if (this.prefs.paintType == -3) {
                return this.elevationToolClicked(hexes.listIterator(0));
            }
            return this.bothToolClicked(hexes.listIterator(0), false);
        }
        if (this.tools.selectedTool() == -11) {
            return this.selectToolClicked(hexes.listIterator(0), e);
        }
        if (this.tools.selectedTool() == -13) {
            return this.bothToolClicked(hexes.listIterator(0), true);
        }
        return false;
    }

    public boolean selectiveUndoClicked(Point h) {
        if (!this.canUndo()) {
            return false;
        }
        ListIterator it = this.undoableChanges.listIterator(this.undoableChanges.size());
        while (it.hasPrevious()) {
            LinkedList lastChangedHexes = (LinkedList)it.previous();
            ListIterator lastIt = lastChangedHexes.listIterator();
            while (lastIt.hasNext()) {
                ChangedMUXHex changedHex = (ChangedMUXHex)lastIt.next();
                if (changedHex.getLocation().getX() != h.getX() || changedHex.getLocation().getY() != h.getY()) continue;
                this.map.setHex(changedHex.getLocation(), changedHex.getPrevTerrain(), changedHex.getPrevElevation());
                this.mapComponent.repaint(this.mapComponent.rectForHex(changedHex.getLocation()));
                return false;
            }
        }
        return false;
    }

    protected boolean pasteHexClicked(Point hex) {
        boolean changedHex = false;
        if (!this.pasteHexes.isEmpty()) {
            this.changedHexes = new LinkedList();
            int x = (int)hex.getX();
            int y = (int)hex.getY();
            ListIterator it = this.pasteHexes.listIterator();
            ArrayList<Point> hexes = new ArrayList<Point>();
            ArrayList<Integer> terrains = new ArrayList<Integer>();
            ArrayList<Integer> elevations = new ArrayList<Integer>();
            int evenXAdjust = 0;
            int oddXAdjust = 0;
            boolean locIsEven = x % 2 == 0;
            boolean pastedIsEven = ((CopyableMUXHex)it.next()).isEven();
            if (pastedIsEven && locIsEven || !pastedIsEven && !locIsEven) {
                evenXAdjust = 0;
                oddXAdjust = 0;
            } else if (pastedIsEven && !locIsEven) {
                evenXAdjust = -1;
                oddXAdjust = 0;
            } else if (!pastedIsEven && locIsEven) {
                evenXAdjust = 0;
                oddXAdjust = 1;
            }
            it.previous();
            while (it.hasNext()) {
                CopyableMUXHex copyThisHex = (CopyableMUXHex)it.next();
                Point thisHex = new Point(x + copyThisHex.getDx(), y + copyThisHex.getDy());
                x = (int)thisHex.getX();
                y = (int)thisHex.getY();
                if ((int)thisHex.getX() % 2 == 0) {
                    thisHex.translate(0, evenXAdjust);
                } else {
                    thisHex.translate(0, oddXAdjust);
                }
                if (!this.map.validHex(thisHex)) continue;
                hexes.add(thisHex);
                terrains.add(new Integer(copyThisHex.getTerrain()));
                elevations.add(new Integer(copyThisHex.getElevation()));
            }
            changedHex = this.pasteTool(hexes, terrains, elevations);
            if (changedHex) {
                this.addUndoableHexChange(this.changedHexes);
            }
        }
        this.pasting = false;
        this.resetCursor();
        return changedHex;
    }

    public void mouseClicked(MouseEvent e) {
        Point hex = this.mapComponent.realToHex(e.getX(), e.getY());
        this.changedHexes = new LinkedList();
        if (this.map.validHex(hex)) {
            boolean hexesChanged = false;
            if (this.pasting && !this.pasteHexes.isEmpty()) {
                this.pasteHexClicked(hex);
            } else {
                hexesChanged = this.hexClicked(hex, e);
            }
            if (hexesChanged) {
                this.addUndoableHexChange(this.changedHexes);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        Point hex = this.mapComponent.realToHex(e.getX(), e.getY());
        this.dragging = true;
        if (this.map.validHex(hex)) {
            this.hexClicked(hex, e);
        }
    }

    public void mouseMoved(MouseEvent e) {
        Point hex = this.mapComponent.realToHex(e.getX(), e.getY());
        if (this.map.validHex(hex)) {
            this.mapper.updateInspector(hex);
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.resetCursor();
    }

    public void mouseExited(MouseEvent e) {
        this.mapper.updateInspector(null);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (this.dragging) {
            if (this.changedHexes.size() > 0) {
                this.addUndoableHexChange(this.changedHexes);
            }
            this.dragging = false;
            this.changedHexes = new LinkedList();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int rotateAmount = e.getWheelRotation();
        rotateAmount = rotateAmount > 0 ? -5 : 5;
        this.adjustZoom(rotateAmount, e.getPoint());
    }

    protected boolean hexAlreadyChanged(Point p) {
        ListIterator it = this.changedHexes.listIterator();
        while (it.hasNext()) {
            if (!((ChangedMUXHex)it.next()).matchesHex(p)) continue;
            return true;
        }
        return false;
    }

    protected void addUndoableHexChange(LinkedList changedHexes) {
        if (changedHexes.size() > 0) {
            this.undoableChanges.addLast(changedHexes);
            if (this.undoableChanges.size() > 20) {
                this.undoableChanges.removeFirst();
            }
            this.mapper.resetMenus();
        }
    }

    public void doUndo() {
        LinkedList lastChange = (LinkedList)this.undoableChanges.getLast();
        if (lastChange != null) {
            ListIterator it = lastChange.listIterator(0);
            while (it.hasNext()) {
                ChangedMUXHex changedHex = (ChangedMUXHex)it.next();
                this.map.setHex(changedHex.getLocation(), changedHex.getPrevTerrain(), changedHex.getPrevElevation());
                this.mapComponent.repaint(this.mapComponent.rectForHex(changedHex.getLocation()));
            }
            this.undoableChanges.removeLast();
        }
    }

    public boolean canUndo() {
        return this.undoableChanges == null || this.undoableChanges.size() > 0;
    }

    public boolean canCopy() {
        return this.map.anyHexesSelected();
    }

    public boolean hasChanged() {
        return this.map.hasChanged();
    }

    public void pasteHexes(LinkedList hexes) {
        this.pasting = true;
        this.resetCursor();
        this.pasteHexes = hexes;
    }

    public void deselectAll() {
        this.map.deselectAll();
        this.mapComponent.repaint();
        this.mapper.resetMenus();
    }

    public void doCut() {
        this.bothToolClicked(this.map.selectedHexesIterator(), true);
    }

    public void doPrint() {
        block2: {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPrintable(this.mapComponent);
            if (!printJob.printDialog()) break block2;
            try {
                printJob.print();
            }
            catch (Exception e) {
                ErrorHandler.displayError("An error occured during printing:\n" + e, 4);
            }
        }
    }

    public LinkedList copyableHexes() {
        LinkedList<CopyableMUXHex> copyableHexes = new LinkedList<CopyableMUXHex>();
        ListIterator it = this.map.selectedHexesIterator();
        int x = 0;
        int y = 0;
        if (!this.map.anyHexesSelected()) {
            return null;
        }
        Point h = (Point)it.next();
        x = (int)h.getX();
        y = (int)h.getY();
        copyableHexes.addLast(new CopyableMUXHex(this.map.getHexTerrain(h), this.map.getHexElevation(h), 0, 0, x % 2 == 0));
        while (it.hasNext()) {
            h = (Point)it.next();
            copyableHexes.addLast(new CopyableMUXHex(this.map.getHexTerrain(h), this.map.getHexElevation(h), (int)h.getX() - x, (int)h.getY() - y));
            x = (int)h.getX();
            y = (int)h.getY();
        }
        return copyableHexes;
    }

    public String fileName() {
        return this.file.getName();
    }

    public boolean newFile() {
        return this.newFile;
    }

    protected String sizeString() {
        return " (" + this.map.getSizeX() + " x " + this.map.getSizeY() + ")";
    }
}

