/*
 * Decompiled with CFR 0.152.
 */
package btthud.ui;

import btthud.data.MPrefs;
import btthud.data.MUXHex;
import btthud.data.MUXMap;
import btthud.ui.HexShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.Scrollable;

public class MUXMapComponent
extends JComponent
implements Scrollable,
Printable {
    MUXMap map;
    MPrefs prefs;
    Font hexNumberFont;
    Font terrainFont;
    Font elevFont;
    FontRenderContext frc;
    int[] elevWidth = new int[10];
    BufferedImage[][] hexImages = new BufferedImage[15][10];
    HexShape hexPoly;
    static final float tan60 = (float)Math.tan(MUXMapComponent.toRadians(60.0f));
    static final float sin60 = (float)Math.sin(MUXMapComponent.toRadians(60.0f));
    int h = 40;
    float w = (float)this.h / (2.0f * sin60);
    float l = (float)this.h / (2.0f * tan60);
    RenderingHints rHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    Rectangle bounds;

    public MUXMapComponent(MUXMap map, MPrefs prefs, int hexHeight) {
        this.map = map;
        this.prefs = prefs;
        this.rHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, prefs.antiAliasText ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.rHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        this.rHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.rHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        this.rHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.rHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.setupFonts();
        this.setDoubleBuffered(true);
        this.changeHeight(hexHeight);
        this.precalculateNumbers();
        this.bounds = this.getBounds();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getTotalWidth(), this.getTotalHeight());
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getScrollableUnitIncrement(visibleRect, orientation, direction) * 10;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int skip = this.h <= 5 ? 5 : (this.h <= 10 ? 3 : (this.h <= 20 ? 2 : 1));
        if (orientation == 1) {
            return this.h * skip;
        }
        return (int)(this.w + this.l) * skip;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    private void precalculateNumbers() {
        this.frc = new FontRenderContext(new AffineTransform(), true, this.prefs.antiAliasText);
        int i = 0;
        while (i < 10) {
            Rectangle2D elevRect = this.elevFont.getStringBounds(Integer.toString(i), this.frc);
            this.elevWidth[i] = (int)elevRect.getWidth();
            ++i;
        }
    }

    public void newPreferences(MPrefs prefs, int hexHeight) {
        this.prefs = prefs;
        this.setupFonts();
        this.changeHeight(hexHeight);
    }

    public int getTotalWidth() {
        return (int)(this.l + (this.w + this.l) * (float)this.map.getSizeX() + 10.0f);
    }

    public int getTotalHeight() {
        return (int)((double)this.h * ((double)this.map.getSizeY() + 0.5) + 10.0);
    }

    private void changeHeight(int newHeight) {
        this.h = newHeight < 5 ? 5 : newHeight;
        this.w = (float)(-this.h) / (2.0f * sin60);
        this.l = (float)this.h / (2.0f * tan60);
        this.terrainFont = new Font("Monospaced", 0, this.h / 2 - 2);
        this.hexPoly = new HexShape(this.h);
        int i = 0;
        while (i < 15) {
            int j = 0;
            while (j < 10) {
                this.hexImages[i][j] = null;
                ++j;
            }
            ++i;
        }
    }

    private void setupOneHex(int t, int e) {
        BufferedImage newImage = new BufferedImage(this.hexPoly.getBounds().width, this.hexPoly.getBounds().height, 2);
        Graphics2D g = (Graphics2D)newImage.getGraphics();
        g.addRenderingHints(this.rHints);
        if (this.prefs.tacDarkenElev) {
            g.setColor(MUXHex.colorForElevation(this.colorForTerrain(t), e, this.prefs.elevationColorMultiplier));
        } else {
            g.setColor(this.colorForTerrain(t));
        }
        g.fill(this.hexPoly);
        g.setColor(Color.gray);
        g.draw(this.hexPoly);
        if (this.prefs.tacShowTerrainElev && this.h >= 20) {
            g.setColor(Color.black);
            g.setFont(this.elevFont);
            if (e != 0) {
                String hexElev = Integer.toString(e);
                int width = e < 0 && Math.abs(e) <= 9 ? 2 * this.elevWidth[Math.abs(e)] : (e > 0 && e <= 9 ? this.elevWidth[e] : this.elevWidth[0]);
                g.drawString(hexElev, (float)(this.hexPoly.getX(0) + (double)this.w - (double)width), (float)(this.hexPoly.getY(0) + (double)this.h - 2.0));
            }
        }
        if (this.prefs.tacShowTerrainChar && this.h >= 20 && t != 1) {
            g.setFont(this.terrainFont);
            g.drawString(String.valueOf(MUXHex.terrainForId(t)), (float)this.hexPoly.getX(0), (float)(this.hexPoly.getY(0) + (double)(this.h / 2)));
        }
        this.hexImages[t][e] = newImage;
    }

    private void setupFonts() {
        this.hexNumberFont = new Font("Monospaced", 1, this.prefs.hexNumberFontSize);
        this.terrainFont = new Font("Monospaced", 0, 10);
        this.elevFont = new Font("Monospaced", 0, this.prefs.elevationFontSize);
        this.rHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, this.prefs.antiAliasText ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.precalculateNumbers();
    }

    public int print(Graphics gfx, PageFormat pf, int pi) throws PrinterException {
        Graphics2D g = (Graphics2D)gfx;
        AffineTransform trans = g.getTransform();
        AffineTransform oldTrans = g.getTransform();
        trans.translate(pf.getImageableX(), pf.getImageableY());
        g.setTransform(trans);
        this.paint(g);
        g.setTransform(oldTrans);
        return 0;
    }

    public void repaint(Rectangle2D r) {
        Rectangle intRectangle = new Rectangle((int)Math.floor(r.getX()), (int)Math.floor(r.getY()), (int)(Math.ceil(r.getWidth() + r.getX()) - Math.floor(r.getX())), (int)(Math.ceil(r.getHeight() + r.getY()) - Math.floor(r.getY())));
        super.repaint(intRectangle);
    }

    public void paint(Graphics gfx) {
        Graphics2D g = (Graphics2D)gfx;
        this.paint2d(g);
    }

    public void paint2d(Graphics2D g) {
        AffineTransform oldTrans = g.getTransform();
        g.addRenderingHints(this.rHints);
        this.paintTerrainGraphics(g);
        g.setTransform(oldTrans);
    }

    public void paintTerrainGraphics(Graphics2D g) {
        Point endCoord;
        Point startCoord;
        Rectangle clipRect = g.getClipBounds();
        if (clipRect == null) {
            startCoord = new Point(0, 0);
            endCoord = new Point(this.map.getSizeX(), this.map.getSizeY());
        } else {
            startCoord = this.hexPoly.realToHex((int)clipRect.getX(), (int)clipRect.getY());
            endCoord = this.hexPoly.realToHex((int)clipRect.getX() + (int)clipRect.getWidth(), (int)clipRect.getY() + (int)clipRect.getHeight());
        }
        startCoord.setLocation(startCoord.getX() - 1.0, startCoord.getY() - 1.0);
        endCoord.setLocation(endCoord.getX() + 2.0, endCoord.getY() + 2.0);
        this.clipPoint(startCoord, 0, this.map.getSizeX());
        this.clipPoint(endCoord, 0, this.map.getSizeX());
        int x = (int)startCoord.getX();
        while (x < (int)endCoord.getX()) {
            int y = (int)startCoord.getY();
            while (y < (int)endCoord.getY()) {
                this.paintOneHex(g, x, y);
                ++y;
            }
            ++x;
        }
        this.paintMarkups(g);
    }

    private void clipPoint(Point p, int min, int max) {
        if (p.getX() < (double)min) {
            p.setLocation((double)min, p.getY());
        }
        if (p.getY() < (double)min) {
            p.setLocation(p.getX(), (double)min);
        }
        if (p.getX() > (double)max) {
            p.setLocation((double)max, p.getY());
        }
        if (p.getY() > (double)max) {
            p.setLocation(p.getX(), (double)max);
        }
    }

    public void changeHex(int x, int y) {
        this.paintOneHex((Graphics2D)this.getGraphics(), x, y);
    }

    public void changeHex(Point h) {
        this.changeHex((int)h.getX(), (int)h.getY());
    }

    public void changeHexes(LinkedList hexes) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        ListIterator it = hexes.listIterator(0);
        while (it.hasNext()) {
            Point p = (Point)it.next();
            this.paintOneHex(g, (int)p.getX(), (int)p.getY());
        }
    }

    protected void paintOneHex(Graphics2D g, int x, int y) {
        AffineTransform oldTrans = g.getTransform();
        AffineTransform trans = new AffineTransform(oldTrans);
        Point2D.Float realHex = new Point2D.Float();
        this.hexPoly.hexToReal(x, y, 1, realHex);
        trans.translate(((Point2D)realHex).getX() - (double)this.l, ((Point2D)realHex).getY());
        g.setTransform(trans);
        g.drawImage(this.imageForTerrain(this.map.getHexTerrain(x, y), this.map.getHexAbsoluteElevation(x, y)), null, null);
        g.setTransform(oldTrans);
    }

    private void paintMarkups(Graphics2D g) {
        AffineTransform oldTrans = g.getTransform();
        AffineTransform trans = new AffineTransform(oldTrans);
        Point2D.Float realHex = new Point2D.Float();
        ListIterator it = this.map.selectedHexesIterator();
        float[] dash = new float[]{this.w / 4.0f};
        float dashOffset = this.w / 4.0f;
        Rectangle clipBounds = g.getClipBounds();
        Rectangle2D.Double hexBounds = new Rectangle2D.Double();
        while (it.hasNext()) {
            Point h = (Point)it.next();
            this.expandedRectForHex(h, hexBounds);
            if (clipBounds.intersects(hexBounds)) {
                int x = (int)h.getX();
                int y = (int)h.getY();
                trans.setTransform(oldTrans);
                this.hexPoly.hexToReal(x, y, 1, realHex);
                trans.translate(((Point2D)realHex).getX() - (double)this.l, ((Point2D)realHex).getY());
                g.setTransform(trans);
                Stroke saveStroke = g.getStroke();
                int i = 0;
                while (i < 2) {
                    if (i == 0) {
                        g.setColor(Color.black);
                        g.setStroke(new BasicStroke(3.0f, 0, 1, 1.0f, dash, 0.0f));
                    } else {
                        g.setColor(Color.red);
                        g.setStroke(new BasicStroke(3.0f, 0, 1, 1.0f, dash, dashOffset));
                    }
                    if (x % 2 == 0) {
                        if (!this.map.getHexSelected(x + 0, y - 1)) {
                            g.drawLine((int)this.hexPoly.getX(0), (int)this.hexPoly.getY(0), (int)this.hexPoly.getX(5), (int)this.hexPoly.getY(5));
                        }
                        if (!this.map.getHexSelected(x - 1, y + 0)) {
                            g.drawLine((int)this.hexPoly.getX(0), (int)this.hexPoly.getY(0), (int)this.hexPoly.getX(1), (int)this.hexPoly.getY(1));
                        }
                        if (!this.map.getHexSelected(x - 1, y + 1)) {
                            g.drawLine((int)this.hexPoly.getX(1), (int)this.hexPoly.getY(1), (int)this.hexPoly.getX(2), (int)this.hexPoly.getY(2));
                        }
                        if (!this.map.getHexSelected(x + 0, y + 1)) {
                            g.drawLine((int)this.hexPoly.getX(2), (int)this.hexPoly.getY(2), (int)this.hexPoly.getX(3), (int)this.hexPoly.getY(3));
                        }
                        if (!this.map.getHexSelected(x + 1, y + 1)) {
                            g.drawLine((int)this.hexPoly.getX(3), (int)this.hexPoly.getY(3), (int)this.hexPoly.getX(4), (int)this.hexPoly.getY(4));
                        }
                        if (!this.map.getHexSelected(x + 1, y + 0)) {
                            g.drawLine((int)this.hexPoly.getX(4), (int)this.hexPoly.getY(4), (int)this.hexPoly.getX(5), (int)this.hexPoly.getY(5));
                        }
                    } else {
                        if (!this.map.getHexSelected(x + 0, y - 1)) {
                            g.drawLine((int)this.hexPoly.getX(0), (int)this.hexPoly.getY(0), (int)this.hexPoly.getX(5), (int)this.hexPoly.getY(5));
                        }
                        if (!this.map.getHexSelected(x - 1, y - 1)) {
                            g.drawLine((int)this.hexPoly.getX(0), (int)this.hexPoly.getY(0), (int)this.hexPoly.getX(1), (int)this.hexPoly.getY(1));
                        }
                        if (!this.map.getHexSelected(x - 1, y + 0)) {
                            g.drawLine((int)this.hexPoly.getX(1), (int)this.hexPoly.getY(1), (int)this.hexPoly.getX(2), (int)this.hexPoly.getY(2));
                        }
                        if (!this.map.getHexSelected(x + 0, y + 1)) {
                            g.drawLine((int)this.hexPoly.getX(2), (int)this.hexPoly.getY(2), (int)this.hexPoly.getX(3), (int)this.hexPoly.getY(3));
                        }
                        if (!this.map.getHexSelected(x + 1, y + 0)) {
                            g.drawLine((int)this.hexPoly.getX(3), (int)this.hexPoly.getY(3), (int)this.hexPoly.getX(4), (int)this.hexPoly.getY(4));
                        }
                        if (!this.map.getHexSelected(x + 1, y - 1)) {
                            g.drawLine((int)this.hexPoly.getX(4), (int)this.hexPoly.getY(4), (int)this.hexPoly.getX(5), (int)this.hexPoly.getY(5));
                        }
                    }
                    ++i;
                }
                g.setStroke(saveStroke);
            }
            g.setTransform(oldTrans);
        }
    }

    public Color colorForTerrain(int terrain) {
        return this.prefs.terrainColors[terrain];
    }

    protected BufferedImage imageForTerrain(int terrain, int elevation) {
        if (this.hexImages[terrain][elevation] == null) {
            this.setupOneHex(terrain, elevation);
        }
        return this.hexImages[terrain][elevation];
    }

    public Point realToHex(int rX, int rY) {
        return this.hexPoly.realToHex(rX, rY);
    }

    public boolean hexInRect(int hX, int hY, Rectangle r) {
        return this.hexPoly.hexIntersectsClipRect(hX, hY, r);
    }

    public Rectangle2D rectForHex(Point h) {
        return this.hexPoly.hexToRect((int)h.getX(), (int)h.getY());
    }

    public Point2D centerOfHex(int hX, int hY) {
        return this.hexPoly.hexToReal(hX, hY, 0);
    }

    public void expandedRectForHex(Point h, Rectangle2D r) {
        this.hexPoly.hexToExpandedRect((int)h.getX(), (int)h.getY(), r);
    }

    public static float toRadians(float a) {
        return (float)((double)(a / 180.0f) * Math.PI + Math.PI);
    }
}

