/*
 * Decompiled with CFR 0.152.
 */
package btthud.ui;

import btthud.ui.MUXMapComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class HexShape
implements Shape {
    public static final int HEX_CENTER = 0;
    public static final int HEX_UPPER_LEFT = 1;
    public static final int HEX_LEFT = 2;
    public static final int HEX_UPPER_LEFT_BOUND = 3;
    public static final int HEX_LOWER_RIGHT_BOUND = 4;
    float[] x = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    float[] y = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    static final float tan60 = (float)Math.tan(MUXMapComponent.toRadians(60.0f));
    static final float sin60 = (float)Math.sin(MUXMapComponent.toRadians(60.0f));
    float h = 40.0f;
    float w;
    float l;
    GeneralPath gp;

    public HexShape(float h) {
        this.h = h;
        this.w = -h / (2.0f * sin60);
        this.l = h / (2.0f * tan60);
        this.gp = new GeneralPath(1, 6);
        this.x[0] = this.l;
        this.y[0] = 0.0f;
        this.x[1] = 0.0f;
        this.y[1] = h / 2.0f;
        this.x[2] = this.l;
        this.y[2] = h;
        this.x[3] = this.w + this.l;
        this.y[3] = h;
        this.x[4] = this.w + 2.0f * this.l;
        this.y[4] = h / 2.0f;
        this.x[5] = this.w + this.l;
        this.y[5] = 0.0f;
        this.gp.moveTo(this.x[0], this.y[0]);
        int i = 1;
        while (i < 6) {
            this.gp.lineTo(this.x[i], this.y[i]);
            ++i;
        }
        this.gp.lineTo(this.x[0], this.y[0]);
    }

    public double getX(int i) {
        if (i < 0 || i > 5) {
            return 0.0;
        }
        return this.x[i];
    }

    public double getY(int i) {
        if (i < 0 || i > 5) {
            return 0.0;
        }
        return this.y[i];
    }

    public boolean contains(double x, double y) {
        return this.gp.contains(x, y);
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.gp.contains(x, y, w, h);
    }

    public boolean contains(Rectangle2D r) {
        return this.gp.contains(r);
    }

    public boolean contains(Point2D p) {
        return this.gp.contains(p);
    }

    public Rectangle getBounds() {
        return this.gp.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.gp.getBounds2D();
    }

    public Point2D hexToReal(int x, int y, int center) {
        Point2D.Float p = new Point2D.Float();
        this.hexToReal(x, y, center, p);
        return p;
    }

    public float hexToRealXPart(int x, int y, int center) {
        float xoffset = (float)x * (this.w + this.l);
        if (center == 0) {
            xoffset += this.l + this.w / 2.0f;
        } else if (center == 1) {
            xoffset += this.l;
        } else if (center == 4) {
            xoffset += 2.0f * this.l + this.w;
        }
        return xoffset;
    }

    public float hexToRealYPart(int x, int y, int center) {
        float yoffset = (float)y * this.h;
        if (x % 2 == 0) {
            yoffset += this.h / 2.0f;
        }
        if (center == 0 || center == 2) {
            yoffset += this.h / 2.0f;
        } else if (center == 4) {
            yoffset += this.h;
        }
        return yoffset;
    }

    public void hexToReal(int x, int y, int center, Point2D pt) {
        pt.setLocation(this.hexToRealXPart(x, y, center), this.hexToRealYPart(x, y, center));
    }

    public Rectangle2D hexToRect(int x, int y) {
        Rectangle2D.Double hexRect = new Rectangle2D.Double();
        this.hexToRect(x, y, hexRect);
        return hexRect;
    }

    public void hexToRect(int x, int y, Rectangle2D r) {
        r.setFrame(this.hexToRealXPart(x, y, 3), this.hexToRealYPart(x, y, 3), 2.0f * this.l + this.w, this.h);
    }

    public void hexToExpandedRect(int x, int y, Rectangle2D r) {
        this.hexToRect(x, y, r);
        if (x % 2 == 0) {
            r.add(this.hexToRealXPart(x - 1, y, 3), this.hexToRealYPart(x - 1, y, 3));
            r.add(this.hexToRealXPart(x + 1, y + 1, 4), this.hexToRealYPart(x + 1, y + 1, 4));
        } else {
            r.add(this.hexToRealXPart(x - 1, y - 1, 3), this.hexToRealYPart(x - 1, y - 1, 3));
            r.add(this.hexToRealXPart(x + 1, y, 4), this.hexToRealYPart(x + 1, y, 4));
        }
        r.add(this.hexToRealXPart(x, y - 1, 3), this.hexToRealYPart(x, y - 1, 3));
        r.add(this.hexToRealXPart(x, y + 1, 4), this.hexToRealYPart(x, y + 1, 4));
    }

    public Point realToHex(int mX, int mY) {
        int section = 0;
        double beta = (double)this.h / 2.0 / (double)this.l;
        double rX = (float)mX - this.l;
        double rY = (float)mY - this.h / 2.0f;
        int boxX = (int)Math.floor(rX / (double)(this.l * 2.0f + this.w * 2.0f));
        int boxY = (int)Math.floor(rY / (double)this.h);
        double x = rX - (double)((float)boxX * (this.l * 2.0f + this.w * 2.0f));
        double y = rY - (double)((float)boxY * this.h);
        section = x < (double)this.w ? 1 : (x > (double)(this.w + this.l) && x < (double)(2.0f * this.w + this.l) ? (y < (double)(this.h / 2.0f) ? 3 : 2) : (x >= (double)this.w && x <= (double)(this.w + this.l) ? (y < (double)(this.h / 2.0f) ? (y >= beta * (x - (double)this.w) ? 1 : 3) : (y - (double)(this.h / 2.0f) >= -beta * (x - (double)this.w) + (double)(this.h / 2.0f) ? 2 : 1)) : (y < (double)(this.h / 2.0f) ? (y >= -beta * (x - (double)(2.0f * this.w + this.l)) + (double)(this.h / 2.0f) ? 4 : 3) : (y - (double)(this.h / 2.0f) >= beta * (x - (double)(2.0f * this.w + this.l)) ? 2 : 4))));
        if (section == 1) {
            return new Point(boxX * 2, boxY);
        }
        if (section == 2) {
            return new Point(boxX * 2 + 1, boxY + 1);
        }
        if (section == 3) {
            return new Point(boxX * 2 + 1, boxY);
        }
        if (section == 4) {
            return new Point(boxX * 2 + 2, boxY);
        }
        return new Point(-1, -1);
    }

    public boolean hexIntersectsClipRect(int x, int y, Rectangle r) {
        return r.intersects(this.hexToRealXPart(x, y, 1), this.hexToRealYPart(x, y, 1), this.w + 2.0f * this.l, this.h);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.gp.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.gp.getPathIterator(at, flatness);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.gp.intersects(x, y, w, h);
    }

    public boolean intersects(Rectangle2D r) {
        return this.gp.intersects(r);
    }
}

