/*
 * Decompiled with CFR 0.152.
 */
package btthud.ui;

import btthud.data.MUXHex;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class CustomCursors {
    public static Cursor crosshairCursor;
    public static Cursor terrainCursor;
    public static Cursor elevationCursor;
    public static Cursor pasteCursor;
    public static Cursor undoCursor;
    public static ImageIcon[] terrainIcons;
    public static ImageIcon paintIcon;
    public static ImageIcon selectIcon;
    public static ImageIcon selectiveUndoIcon;
    public static ImageIcon eraseIcon;

    public static void createCustomCursors() {
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            Image crosshair = new ImageIcon(cl.getResource("cursors/crosshair.gif")).getImage();
            Image terrain = new ImageIcon(cl.getResource("cursors/terrainonly.gif")).getImage();
            Image elevation = new ImageIcon(cl.getResource("cursors/elevonly.gif")).getImage();
            Image paste = new ImageIcon(cl.getResource("cursors/paste.gif")).getImage();
            Image undo = new ImageIcon(cl.getResource("cursors/undo.gif")).getImage();
            crosshairCursor = CustomCursors.createOneCursor(crosshair, new Point(7, 7), "Crosshair");
            terrainCursor = CustomCursors.createOneCursor(terrain, new Point(7, 7), "Terrain Only");
            elevationCursor = CustomCursors.createOneCursor(elevation, new Point(7, 7), "Elevation Only");
            pasteCursor = CustomCursors.createOneCursor(paste, new Point(7, 7), "Paste");
            undoCursor = CustomCursors.createOneCursor(undo, new Point(7, 7), "Undo");
            int i = 0;
            while (i < 11) {
                CustomCursors.terrainIcons[i] = new ImageIcon(cl.getResource("tools/" + MUXHex.nameForId(i) + ".png"));
                ++i;
            }
            paintIcon = new ImageIcon(cl.getResource("tools/paint.png"));
            selectIcon = new ImageIcon(cl.getResource("tools/select.png"));
            selectiveUndoIcon = new ImageIcon(cl.getResource("tools/undo.png"));
            eraseIcon = new ImageIcon(cl.getResource("tools/erase.png"));
        }
        catch (Exception e) {
            System.out.println("Error: createCustomCursors: " + e);
        }
    }

    private static Cursor createOneCursor(Image img, Point hotSpot, String name) {
        Cursor c;
        int imWidth = img.getWidth(null);
        int imHeight = img.getHeight(null);
        Dimension bestSize = Toolkit.getDefaultToolkit().getBestCursorSize(imWidth, imHeight);
        if (bestSize.width == imWidth && bestSize.height == imHeight) {
            c = Toolkit.getDefaultToolkit().createCustomCursor(img, hotSpot, name);
        } else {
            BufferedImage newImage = new BufferedImage(bestSize.width, bestSize.height, 2);
            Graphics2D g2 = newImage.createGraphics();
            g2.drawImage(img, 0, 0, null);
            c = Toolkit.getDefaultToolkit().createCustomCursor(newImage, hotSpot, name);
        }
        return c;
    }

    public static Cursor getCrosshairCursor() {
        return crosshairCursor;
    }

    public static Cursor getTerrainCursor() {
        return terrainCursor;
    }

    public static Cursor getElevationCursor() {
        return elevationCursor;
    }

    public static Cursor getPasteCursor() {
        return pasteCursor;
    }

    public static Cursor getUndoCursor() {
        return undoCursor;
    }

    public static ImageIcon getPaintIcon() {
        return paintIcon;
    }

    public static ImageIcon getSelectIcon() {
        return selectIcon;
    }

    public static ImageIcon getSelectiveUndoIcon() {
        return selectiveUndoIcon;
    }

    public static ImageIcon getEraseIcon() {
        return eraseIcon;
    }

    public static ImageIcon getTerrainIcon(int t) {
        return terrainIcons[t];
    }

    static {
        terrainIcons = new ImageIcon[11];
    }
}

