/*
 * Decompiled with CFR 0.152.
 */
package btthud.data;

import btthud.data.MUXHex;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ListIterator;

public class MUXMap
implements Serializable {
    MUXHex[][] hexCache = new MUXHex[15][19];
    MUXHex[][] map = null;
    boolean[][] hexesChanged;
    int sizeX;
    int sizeY;
    boolean hasChanged;
    ArrayList selectedHexes;

    public MUXMap(int x, int y) {
        this.sizeX = x;
        this.sizeY = y;
        this.map = new MUXHex[x][y];
        this.hexesChanged = new boolean[x][y];
        this.hasChanged = false;
        this.selectedHexes = new ArrayList();
        this.createHexCache();
    }

    public void clearMap() {
        int x = 0;
        while (x < this.sizeX) {
            int y = 0;
            while (y < this.sizeY) {
                this.map[x][y] = this.hexCache[1][9];
                ++y;
            }
            ++x;
        }
        this.resetChanged();
    }

    public void resetChanged() {
        int x = 0;
        while (x < this.sizeX) {
            int y = 0;
            while (y < this.sizeY) {
                this.hexesChanged[x][y] = true;
                ++y;
            }
            ++x;
        }
    }

    public MUXHex getHex(int x, int y) {
        if (x >= 0 && x < this.getSizeX() && y >= 0 && y < this.getSizeY()) {
            return this.map[x][y];
        }
        return null;
    }

    public MUXHex getHex(Point p) {
        return this.getHex((int)p.getX(), (int)p.getY());
    }

    public boolean getHexSelected(int x, int y) {
        Point p = new Point(x, y);
        return this.validHex(p) && this.selectedHexes.indexOf(p) != -1;
    }

    public boolean getHexSelected(Point p) {
        return this.getHexSelected((int)p.getX(), (int)p.getY());
    }

    public int getHexTerrain(int x, int y) {
        if (x >= 0 && x < this.sizeX && y >= 0 && y < this.sizeY) {
            if (this.map[x][y] != null) {
                return this.map[x][y].terrain();
            }
            return 14;
        }
        return 14;
    }

    public int getHexTerrain(Point h) {
        return this.getHexTerrain((int)h.getX(), (int)h.getY());
    }

    public int getHexElevation(int x, int y) {
        if (x >= 0 && x < this.sizeX && y >= 0 && y < this.sizeY) {
            if (this.map[x][y] != null) {
                return this.map[x][y].elevation();
            }
            return 0;
        }
        return 0;
    }

    public int getHexElevation(Point h) {
        return this.getHexElevation((int)h.getX(), (int)h.getY());
    }

    public int getHexAbsoluteElevation(int x, int y) {
        int e = this.getHexElevation(x, y);
        if (e < 0) {
            e = -e;
        }
        if (this.getHexTerrain(x, y) == 13) {
            e = 0;
        }
        return e;
    }

    public int getHexAbsoluteElevation(Point h) {
        return this.getHexAbsoluteElevation((int)h.getX(), (int)h.getY());
    }

    public boolean getHexChanged(int x, int y) {
        return this.hexesChanged[x][y];
    }

    public boolean getHexChanged(Point h) {
        return this.getHexChanged((int)h.getX(), (int)h.getY());
    }

    public void setHexElevation(int x, int y, int elevation) {
        this.setHex(x, y, this.getHexTerrain(x, y), elevation);
    }

    public void setHexElevation(Point h, int elevation) {
        this.setHexElevation((int)h.getX(), (int)h.getY(), elevation);
    }

    public void setHexTerrain(int x, int y, int terr) {
        this.setHex(x, y, terr, this.getHexElevation(x, y));
    }

    public void setHexTerrain(Point h, int terr) {
        this.setHexTerrain((int)h.getX(), (int)h.getY(), terr);
    }

    public void setHexChanged(int x, int y, boolean c) {
        this.hexesChanged[x][y] = c;
    }

    public void setHexChanged(Point h, boolean c) {
        this.setHexChanged((int)h.getX(), (int)h.getY(), c);
    }

    public void setHex(int x, int y, char ter, int elevation) {
        this.setHex(x, y, MUXHex.idForTerrain(ter), elevation);
    }

    public void setHex(Point h, char ter, int elevation) {
        this.setHex((int)h.getX(), (int)h.getY(), ter, elevation);
    }

    public void setHexSelected(int x, int y, boolean s) {
        this.setHexSelected(new Point(x, y), s);
    }

    public void setHexSelected(Point p, boolean s) {
        if (this.validHex(p)) {
            if (s) {
                if (this.selectedHexes.indexOf(p) == -1) {
                    this.selectedHexes.add(p);
                }
            } else {
                this.selectedHexes.remove(p);
            }
        }
    }

    public void deselectAll() {
        this.selectedHexes = new ArrayList();
    }

    public ListIterator selectedHexesIterator() {
        return this.selectedHexes.listIterator(0);
    }

    public boolean anyHexesSelected() {
        return !this.selectedHexes.isEmpty();
    }

    public void setHex(int x, int y, int ter, int elevation) {
        if (x >= 0 && x < this.sizeX && y >= 0 && y < this.sizeY && ter >= 0 && ter < 15) {
            this.map[x][y] = this.hexCache[ter][elevation + 9];
        }
        this.hasChanged = true;
        this.hexesChanged[x][y] = true;
    }

    public void setHex(Point h, int ter, int elevation) {
        this.setHex((int)h.getX(), (int)h.getY(), ter, elevation);
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public boolean validHex(Point h) {
        return h.getX() >= 0.0 && h.getX() < (double)this.getSizeX() && h.getY() >= 0.0 && h.getY() < (double)this.getSizeY();
    }

    protected void createHexCache() {
        int i = 0;
        while (i < 15) {
            int j = -9;
            while (j < 10) {
                this.hexCache[i][j + 9] = new MUXHex(i, j);
                ++j;
            }
            ++i;
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setChanged(boolean c) {
        this.hasChanged = c;
    }
}

