/*
 * Decompiled with CFR 0.152.
 */
package btthud.data;

import java.awt.Color;

public class MUXHex {
    public static final int ROUGH = 0;
    public static final int PLAIN = 1;
    public static final int HEAVY_FOREST = 2;
    public static final int LIGHT_FOREST = 3;
    public static final int BRIDGE = 4;
    public static final int ROAD = 5;
    public static final int WALL = 6;
    public static final int BUILDING = 7;
    public static final int WATER = 8;
    public static final int MOUNTAIN = 9;
    public static final int FIRE = 10;
    public static final int SMOKE = 11;
    public static final int SMOKE_OVER_WATER = 12;
    public static final int ICE = 13;
    public static final int UNKNOWN = 14;
    public static final int TOTAL_TERRAIN = 15;
    public static final int TOTAL_PAINTABLE_TERRAIN = 11;
    public static final char[] TERRAIN_TYPES = new char[]{'%', '.', '\"', '`', '/', '#', '=', '@', '~', '^', '&', ':', '+', '-', '?'};
    public static final char[] PAINTABLE_TERRAIN_TYPES = new char[]{'%', '.', '\"', '`', '/', '#', '=', '@', '~', '^', '&'};
    int terrain;
    int elevation;

    public MUXHex() {
        this.terrain = 14;
        this.elevation = 0;
    }

    public MUXHex(int terrain, int elevation) {
        this.terrain = terrain;
        this.elevation = elevation;
    }

    public int terrain() {
        return this.terrain;
    }

    public int elevation() {
        return this.elevation;
    }

    public void setTerrain(char t) {
        this.terrain = MUXHex.idForTerrain(t);
    }

    public void setElevation(int e) {
        this.elevation = e;
    }

    public static Color colorForElevation(Color ic, int e, float elevationColorMultiplier) {
        float[] comp = ic.getRGBColorComponents(null);
        float mod = elevationColorMultiplier * (float)e;
        float[] newComp = new float[]{comp[0], comp[1], comp[2]};
        int i = 0;
        while (i < 3) {
            int n = i;
            newComp[n] = newComp[n] - mod;
            if (newComp[i] < 0.0f) {
                newComp[i] = 0.0f;
            }
            ++i;
        }
        return new Color(newComp[0], newComp[1], newComp[2]);
    }

    public static int idForTerrain(char terr) {
        switch (terr) {
            case '.': {
                return 1;
            }
            case '~': {
                return 8;
            }
            case '`': {
                return 3;
            }
            case '\"': {
                return 2;
            }
            case '^': {
                return 9;
            }
            case '%': {
                return 0;
            }
            case '@': {
                return 7;
            }
            case '#': {
                return 5;
            }
            case '/': {
                return 4;
            }
            case '&': {
                return 10;
            }
            case '=': {
                return 6;
            }
            case ':': {
                return 11;
            }
            case '-': {
                return 13;
            }
            case '+': {
                return 12;
            }
            case '?': {
                return 14;
            }
        }
        return 14;
    }

    public static String nameForId(int id) {
        switch (id) {
            case 1: {
                return "Plain";
            }
            case 8: {
                return "Water";
            }
            case 3: {
                return "Light Forest";
            }
            case 2: {
                return "Heavy Forest";
            }
            case 9: {
                return "Mountain";
            }
            case 0: {
                return "Rough";
            }
            case 7: {
                return "Building";
            }
            case 5: {
                return "Road";
            }
            case 4: {
                return "Bridge";
            }
            case 10: {
                return "Fire";
            }
            case 6: {
                return "Wall";
            }
            case 11: {
                return "Smoke";
            }
            case 13: {
                return "Ice";
            }
            case 12: {
                return "Smoke on Water";
            }
            case 14: {
                return "Unknown";
            }
        }
        return "Unknown";
    }

    public static char terrainForId(int id) {
        if (id < 0 || id >= 15) {
            return '?';
        }
        return TERRAIN_TYPES[id];
    }
}

