//-----------------------------------------------------------------------------
// Torque Game Engine
//
// Copyright (c) 2001 GarageGames.Com
// Portions Copyright (c) 2001 by Sierra Online, Inc.
//-----------------------------------------------------------------------------

$baseMods   = "common";
$userMods   = "game";
$displayHelp = false;

//-----------------------------------------------------------------------------
// Support functions used to manage the mod string

function pushFront(%list, %token, %delim)
{
   if (%list !$= "")
      return %token @ %delim @ %list;
   return %token;
}

function pushBack(%list, %token, %delim)
{
   if (%list !$= "")
      return %list @ %delim @ %token;
   return %token;
}

function popFront(%list, %delim)
{
   return nextToken(%list, unused, %delim);
}

function doCompileAll()
{
   for(%file = findFirstFile("*.cs"); %file !$= ""; %file = findNextFile("*.cs"))
   {
      if (strstr(%file,"/CVS/") != -1)
         continue;
      compile(%file);
   }
   for(%file = findFirstFile("*.gui"); %file !$= ""; %file = findNextFile("*.gui"))
   {
      if (strstr(%file,"/CVS/") != -1)
         continue;
      compile(%file);
   }
   %misfile = new FileObject();
   if (%misfile.openForWrite("game/data/missions/missions.txt"))
   {
      exec("common/server/missionInfo.cs");
      %misfile.writeLine("[name]");
      for (%file = findFirstFile("*.mis"); %file !$= ""; %file = findNextFile("*.mis"))
      {
         if (strstr(%file,"/TT") == -1 && strstr(%file,"Brain") == -1)
            continue;
         if (strstr(%file,"/CVS/") != -1)
            continue;
         buildLoadInfo(%file);
         while (strstr(%file,"/") != -1)
            %file = getSubStr(%file,strstr(%file,"/")+1,strlen(%file)-strstr(%file,"/")-1);
         %file = getSubStr(%file,0,strlen(%file)-4);
         %misfile.writeLine(%file @ "=" @ MissionInfo.name);
      }
      %misfile.close();
      clearLoadInfo();
   }

   %savePref = $pref::Terrain::useSmall;
   $pref::Terrain::useSmall = false;
   for(%file = findFirstFile("*.ter"); %file !$= ""; %file = findNextFile("*.ter"))
   {
      if (strstr(%file,"/TT") == -1)
         continue;
      if (strstr(%file,"/CVS/") != -1)
         continue;
      %terr = new TerrainBlock() {
         terrainFile = %file;
         squareSize = "8";
         tile = "0";
         blockShift = "7";
      };
      if (%terr.blockShift == 7)
      {
         // possible that terrain was already 6, even though
         // block shift was set to 7 in constructor above...
         // ...that's why this is conditional.
         echo("Reducing terrain :" @ %file);
         %terr.blockShift = "6";
         %terr.resave("","_LO");
      }
      %terr.delete();
   }
   $pref::Terrain::useSmall = %savePref;
}

//------------------------------------------------------------------------------
// Process command line arguments

for ($i = 1; $i < $Game::argc ; $i++)
{
   $arg = $Game::argv[$i];
   $nextArg = $Game::argv[$i+1];
   $hasNextArg = $Game::argc - $i > 1;
   $logModeSpecified = false;

   switch$ ($arg)
   {
      //--------------------
      case "-log":
         $argUsed[$i]++;
         if ($hasNextArg)
         {
            // Turn on console logging
            if ($nextArg != 0)
            {
               // Dump existing console to logfile first.
               $nextArg += 4;
            }
            setLogMode($nextArg);
            $logModeSpecified = true;
            $argUsed[$i+1]++;
            $i++;
         }
         else
            error("Error: Missing Command Line argument. Usage: -log <Mode: 0,1,2>");

      //--------------------
      case "-demo":
         $argUsed[$i]++;
         $Game::DemoMode = true;

      //--------------------
      case "-show":
         // A useful shortcut for -mod show
         $userMods = strreplace($userMods, "show", "");
         $userMods = pushFront($userMods, "show", ";");
         $argUsed[$i]++;

      //--------------------
      case "-console":
         enableWinConsole(true);
         $argUsed[$i]++;

      //--------------------
      case "-compileAll":
         $argUsed[$i]++;
         enableWinConsole(true);
         // call doCompileAll() below...

      //--------------------
      case "-jSave":
         $argUsed[$i]++;
         if ($hasNextArg)
         {
            echo("Saving event log to journal: " @ $nextArg);
            saveJournal($nextArg);
            $argUsed[$i+1]++;
            $i++;
         }
         else
            error("Error: Missing Command Line argument. Usage: -jSave <journal_name>");

      //--------------------
      case "-jPlay":
         $argUsed[$i]++;
         if ($hasNextArg)
         {
            playJournal($nextArg,false);
            $argUsed[$i+1]++;
            $i++;
         }
         else
            error("Error: Missing Command Line argument. Usage: -jPlay <journal_name>");

      //--------------------
      case "-jDebug":
         $argUsed[$i]++;
         if ($hasNextArg)
         {
            playJournal($nextArg,true);
            $argUsed[$i+1]++;
            $i++;
         }
         else
            error("Error: Missing Command Line argument. Usage: -jDebug <journal_name>");

      //-------------------
      case "-help":
         $displayHelp = true;
         $argUsed[$i]++;

      //-------------------
      case "-test":
         $Game::testMode=true;
         $argUsed[$i]++;
   }
}


//-----------------------------------------------------------------------------
// The displayHelp, onStart, onExit and parseArgs function are overriden
// by mod packages to get hooked into initialization and cleanup.

function onStart()
{
   // Default startup function
}

function onExit()
{
   // OnExit is called directly from C++ code, whereas onStart is
   // invoked at the end of this file.
   disconnect();
}

function parseArgs()
{
   // Here for mod override, the arguments have already
   // been parsed.
}

package Help {
   function onExit() {
      // Override onExit when displaying help
   }
};

function displayHelp() {
   activatePackage(Help);

      // Notes on logmode: console logging is written to console.log.
      // -log 0 disables console logging. (default)
      // -log 1 appends to existing logfile; it also closes the file
      // (flushing the write buffer) after every write.
      // -log 2 overwrites any existing logfile; it also only closes
      // the logfile when the application shuts down.

   error(
      "ThinkTanks command line options:\n"@
      "  -log <logmode>         Logging behavior; see main.cs comments for details\n"@
      "  -console               Open a separate console\n"@
      "  -jSave  <file_name>    Record a journal\n"@
      "  -jPlay  <file_name>    Play back a journal\n"@
      "  -jDebug <file_name>    Play back a journal and issue an int3 at the end\n"@
      "  -test                  Test launch the app\n"@
      "  -help                  Display this help message\n"
   );
}


//--------------------------------------------------------------------------

// Default to a new logfile each session.
if (!$logModeSpecified) {
   setLogMode(0);
}

// Set the mod path which dictates which directories will be visible
// to the scripts and the resource engine.
$modPath = pushback($userMods, $baseMods, ";");
setModPaths($modPath);

// Get the first mod on the list, which will be the last to be applied... this
// does not modify the list.
nextToken($modPath, currentMod, ";");

// Execute startup scripts for each mod, starting at base and working up
echo("--------- Loading MODS ---------");
function loadMods(%modPath)
{
   %modPath = nextToken(%modPath, token, ";");
   if (%modPath !$= "")
      loadMods(%modPath);

   exec(%token @ "/main.cs");
}
loadMods($modPath);
echo("");

// Parse the command line arguments
echo("--------- Parsing Arguments ---------");
parseArgs();

// Either display the help message or startup the app.
if ($displayHelp)
{
   enableWinConsole(true);
   displayHelp();
}
else if ($Game::argc==2 && $Game::argv[1] $= "-compileAll")
{
   doCompileAll();
   quit();
}
else
{
   onStart();
   echo("Engine initialized...");
}

// Display an error message for unused arguments
for ($i = 1; $i < $Game::argc; $i++)  {
   if (!$argUsed[$i])
      error("Error: Unkown command line argument: " @ $Game::argv[$i]);
}

