/*
 * Decompiled with CFR 0.152.
 */
package xap.modes.standard;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import xap.modes.standard.StandardScore;

public class StandardHiScoreTable
implements Serializable {
    public static final long serialVersionUID = 1L;
    private ArrayList scores;
    private final int maxSize;

    public StandardHiScoreTable(int maxSize) {
        this.maxSize = maxSize;
        this.scores = new ArrayList(maxSize);
    }

    public void loadFromDatabase(StandardScoreDatabase db) throws SQLException {
        this.scores.clear();
        this.scores.addAll(db.selectTopStandardScores(this.maxSize));
    }

    public boolean submit(StandardScore score) {
        int n = this.scores.size();
        int i = 0;
        while (i < n) {
            StandardScore current = (StandardScore)this.scores.get(i);
            if (score.getScore() > current.getScore()) {
                if (this.scores.size() == this.maxSize) {
                    this.scores.remove(this.scores.size() - 1);
                }
                this.scores.add(i, score);
                return true;
            }
            ++i;
        }
        if (this.scores.size() < this.maxSize) {
            this.scores.add(score);
            return true;
        }
        return false;
    }

    public void display(Display display, int maxSize) {
        int n = Math.min(maxSize, this.scores.size());
        display.setNumberOfHiscores(n);
        int i = 0;
        while (i < n) {
            StandardScore s = (StandardScore)this.scores.get(i);
            int accuracy = s.getShots() == 0 ? 0 : s.getHits() * 100 / s.getShots();
            display.setHiScore(i + 1, s.getName(), s.getScore(), s.getLevel() + 1, accuracy, s.getRescues(), s.getStyle(), s.getFluffies(), s.getMurders(), s.getBungles());
            ++i;
        }
    }

    public void submit(StandardScore.StandardScoreDatabase db, String host) throws SQLException {
        int n = this.scores.size();
        int i = 0;
        while (i < n) {
            StandardScore s = (StandardScore)this.scores.get(i);
            if (!s.checkExists(db)) {
                s.insertInto(db, host);
            }
            ++i;
        }
    }

    public StandardScore getTopScore() {
        if (this.scores.size() > 0) {
            return (StandardScore)this.scores.get(0);
        }
        return null;
    }

    public interface Display {
        public void setNumberOfHiscores(int var1);

        public void setHiScore(int var1, String var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);
    }

    public interface StandardScoreDatabase {
        public List selectTopStandardScores(int var1) throws SQLException;
    }
}

