/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.gamecommerce.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.Naming;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.puppygames.gamecommerce.client.HTMLTextArea;
import net.puppygames.gamecommerce.client.LimitedSizeDocument;
import net.puppygames.gamecommerce.client.WindowUtil;
import net.puppygames.gamecommerce.shared.Game;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import net.puppygames.gamecommerce.shared.RegistrationServerRemote;

public class RegisterWindow {
    private JDialog window = new JDialog();
    private HTMLTextArea jtaBlurb;
    private JLabel jlEmail;
    private JLabel jlAuthCode;
    private JTextField jtfEmail;
    private JTextField jtfAuthCode;
    private JButton jbOK;
    private JButton jbCancel;

    public RegisterWindow(final Game game) {
        this.window.setModal(true);
        this.window.setResizable(false);
        Container c = this.window.getContentPane();
        c.setLayout(new GridBagLayout());
        this.jtaBlurb = new HTMLTextArea("<html><div style=\"font-family:arial,sans-serif; font-size:9px\">This copy of <b>" + game.getTitle() + "</b> is not yet registered. If you have purchased the full version, you now need to register on-line with Puppy Games. " + "Please ensure that you are connected to the internet " + "and enter your e-mail address and the authorisation code that was sent to you when you purchased " + "<b>" + game.getTitle() + "</b>.</div></html>");
        c.add((Component)this.jtaBlurb, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 2, 4), 0, 0));
        this.jlEmail = new JLabel("Your email address");
        c.add((Component)this.jlEmail, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 2, 2), 0, 0));
        this.jlAuthCode = new JLabel("Your authorisation code");
        c.add((Component)this.jlAuthCode, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 2, 2), 0, 0));
        this.jtfEmail = new JTextField();
        c.add((Component)this.jtfEmail, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 4), 0, 0));
        this.jtfAuthCode = new JTextField();
        c.add((Component)this.jtfAuthCode, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 4), 0, 0));
        this.jtfAuthCode.setDocument(new LimitedSizeDocument(14, false));
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        this.jbOK = new JButton("Register");
        buttonsPanel.add((Component)this.jbOK, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jbCancel = new JButton("I haven't bought " + game.getTitle() + " yet!");
        buttonsPanel.add((Component)this.jbCancel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        c.add((Component)buttonsPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jbOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String email = RegisterWindow.this.jtfEmail.getText().trim();
                String authCode = RegisterWindow.this.jtfAuthCode.getText().trim();
                try {
                    RegistrationServerRemote server = (RegistrationServerRemote)Naming.lookup("//67.18.194.226/registration");
                    System.err.println("Performing registration: " + email + "/" + authCode);
                    RegistrationDetails registrationDetails = server.register(email, authCode, game.getTitle(), game.getVersion(), game.getAffiliate(), game.getConfiguration());
                    System.err.println("Success");
                    game.setRegistrationDetails(registrationDetails);
                    JOptionPane.showMessageDialog(RegisterWindow.this.window, "Congratulations! Your copy of " + game.getTitle() + " has been successfully registered to you. Enjoy the game!", "Registration Success", 0);
                    RegisterWindow.this.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    JOptionPane.showMessageDialog(RegisterWindow.this.window, "<html><div style=\"font-family:arial,sans-serif; font-size:9px\">Your registration didn't work for some reason! Please try again and carefully check your typing, or contact <a href=\"mailto:support@puppygames.net\">support@puppygames.net</a> and ask for help.</div></html>", "Registration Failed", 0);
                }
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RegisterWindow.this.close();
            }
        });
        this.window.setTitle("Register " + game.getTitle());
        this.window.setSize(300, 200);
        this.window.setDefaultCloseOperation(0);
        WindowUtil.centre(this.window);
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RegisterWindow.this.close();
            }
        });
    }

    public void open() {
        this.window.setVisible(true);
        this.window.toFront();
        this.jtfEmail.requestFocus();
    }

    public void close() {
        this.window.setVisible(false);
        this.window.dispose();
    }
}

