/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLString;
import genesis.CreditsScreen;
import genesis.Game;
import genesis.HiscoresScreen;
import genesis.InstructionsScreen;
import genesis.NagScreen;
import genesis.OptionsScreen;
import genesis.SFX;
import genesis.Screen;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

public class TitleScreen
extends Screen {
    public static final long serialVersionUID = 1L;
    private static TitleScreen instance;
    private static final String PLAY = "play";
    private static final String HELP = "help";
    private static final String EXIT = "exit";
    private static final String HISCORES = "hiscores";
    private static final String CREDITS = "credits";
    private static final String OPTIONS = "options";
    private static final String BUY = "buy";
    private transient GLString registrationDetails;
    private transient GLString versionString;

    protected void doCreate() throws Exception {
        super.doCreate();
        GLFont font = (GLFont)Resources.get((String)"impact-plain-12.glfont");
        this.registrationDetails = new GLString(80);
        this.registrationDetails.setFont(font);
        this.versionString = new GLString(16);
        this.versionString.setFont(font);
    }

    protected void doRegister() {
        instance = this;
    }

    public static void instantiate() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void show() {
        TitleScreen.instantiate();
        instance.open();
    }

    protected void onClicked(String id) {
        if (id.equals(HELP)) {
            InstructionsScreen.show();
        } else if (id.equals(EXIT)) {
            if (Game.isRegistered()) {
                Game.exit();
            } else {
                NagScreen.show("Nag! Nag! Nag! Buy! Buy! Buy!", true);
            }
        } else if (id.equals(PLAY)) {
            Game.beginNewGame();
        } else if (id.equals(BUY)) {
            Game.buy();
        } else if (id.equals(OPTIONS)) {
            OptionsScreen.show();
        } else if (id.equals(CREDITS)) {
            CreditsScreen.show();
        } else if (id.equals(HISCORES)) {
            HiscoresScreen.show();
        }
    }

    protected void doTick() {
        if (Keyboard.isKeyDown((int)1)) {
            Game.exit();
        }
    }

    protected void preRender() {
    }

    protected void postRender() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.registrationDetails.render();
        this.versionString.render();
    }

    protected void onOpen() {
        TitleScreen.playMusic();
        try {
            SFX.createSFX();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.doUpdateRegistrationDetails();
    }

    public static void updateRegistrationDetails() {
        TitleScreen.instantiate();
        instance.doUpdateRegistrationDetails();
    }

    private void doUpdateRegistrationDetails() {
        this.getArea(BUY).setVisible(!Game.isRegistered());
        RegistrationDetails regDetails = Game.getRegistrationDetails();
        if (regDetails == null) {
            this.registrationDetails.setText("Unregistered Demo Version - visit www.puppygames.net for more games");
            this.versionString.setText("v1.0 demo");
        } else {
            this.registrationDetails.setText(regDetails.toTitleScreen());
            this.versionString.setText("v1.0");
        }
        Rectangle bounds = this.registrationDetails.getBounds(new Rectangle());
        this.registrationDetails.setLocation((800 - bounds.getWidth()) / 2, 8);
        bounds = this.versionString.getBounds(bounds);
        this.versionString.setLocation(800 - bounds.getWidth() - 128, 600 - bounds.getHeight() - 23);
    }

    public static void playMusic() {
        try {
            ALBuffer titleMusic = (ALBuffer)Resources.get((String)"title.buffer");
            if (Game.getMusic() == null || titleMusic != Game.getMusic().getBuffer()) {
                Game.playMusic(titleMusic, 180);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static void stopMusic() {
        Game.playMusic(null, 180);
    }
}

