/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.GL;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.StaticSpriteEngine;
import com.shavenpuppy.jglib.util.XMLUtil;
import genesis.Area;
import genesis.SpriteAllocator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.w3c.dom.Element;

public abstract class Screen
extends Feature
implements SpriteAllocator {
    public static final long serialVersionUID = 1L;
    private static final List screens;
    private static final int FADE_TIME = 15;
    private static final float START_DEPTH = -200.0f;
    private static final float END_DEPTH = 400.0f;
    private int maxSprites = 32;
    private List areas;
    private boolean mouseVisible;
    private transient StaticSpriteEngine spriteEngine;
    private transient int timer;
    private transient int phase;
    private transient float alpha;
    private transient int mouseX;
    private transient int mouseY;
    private transient Map nameToArea;
    private transient boolean enabled;
    private static final int CLOSED = 0;
    private static final int OPENING = 1;
    private static final int OPEN = 2;
    private static final int CLOSING = 3;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("genesis.Screen");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        screens = new ArrayList();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List children = XMLUtil.getChildren((Element)element, (String)"area");
        this.areas = new ArrayList(children.size());
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            Area area = new Area();
            area.load(child, loader);
            this.areas.add(area);
        }
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.spriteEngine = new StaticSpriteEngine(false, this.maxSprites, 1);
        this.spriteEngine.create();
        this.nameToArea = new HashMap();
        Iterator i = this.areas.iterator();
        while (i.hasNext()) {
            Area area = (Area)((Object)i.next());
            area.create();
            this.nameToArea.put(area.getID(), area);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        Iterator i = this.areas.iterator();
        while (i.hasNext()) {
            Area area = (Area)((Object)i.next());
            area.destroy();
        }
    }

    public final void tick() {
        this.mouseX = (int)(800.0f * (float)Mouse.getX() / (float)Display.getDisplayMode().getWidth());
        this.mouseY = (int)(600.0f * (float)Mouse.getY() / (float)Display.getDisplayMode().getHeight());
        switch (this.phase) {
            case 1: {
                if (++this.timer >= 15) {
                    this.phase = 2;
                    this.timer = 0;
                } else {
                    this.spriteEngine.tick();
                    break;
                }
            }
            case 2: {
                if (this.enabled) {
                    int i = 0;
                    while (i < this.areas.size()) {
                        Area area = (Area)((Object)this.areas.get(i));
                        area.tick();
                        ++i;
                    }
                }
                this.doTick();
                this.spriteEngine.tick();
                break;
            }
            case 3: {
                if (++this.timer >= 15) {
                    this.phase = 0;
                    int i = 0;
                    while (i < this.areas.size()) {
                        Area area = (Area)((Object)this.areas.get(i));
                        area.cleanup();
                        ++i;
                    }
                    this.doCleanup();
                    break;
                }
                this.spriteEngine.tick();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    protected void doTick() {
    }

    protected void onClicked(String id) {
    }

    private boolean isActive() {
        return this.phase != 0;
    }

    public final void close() {
        this.phase = 3;
        this.timer = 0;
        this.onClose();
    }

    protected void onClose() {
    }

    public final void open() {
        if (screens.size() > 0) {
            Screen topmost = (Screen)screens.get(screens.size() - 1);
            topmost.close();
        }
        screens.add(this);
        this.phase = 1;
        this.enabled = true;
        this.timer = 0;
        int i = 0;
        while (i < this.areas.size()) {
            Area area = (Area)((Object)this.areas.get(i));
            area.init(this);
            ++i;
        }
        this.onOpen();
    }

    protected void onOpen() {
    }

    protected void doCleanup() {
    }

    public final void render() {
        float depth;
        float alpha;
        this.preRender();
        switch (this.phase) {
            case 3: {
                alpha = LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)this.timer / 15.0f);
                depth = LinearInterpolator.instance.interpolate(0.0f, 400.0f, (float)this.timer / 15.0f);
                break;
            }
            case 1: {
                alpha = LinearInterpolator.instance.interpolate(0.0f, 1.0f, (float)this.timer / 15.0f);
                depth = LinearInterpolator.instance.interpolate(-200.0f, 0.0f, (float)this.timer / 15.0f);
                break;
            }
            case 2: {
                alpha = 1.0f;
                depth = 0.0f;
                break;
            }
            default: {
                alpha = 0.0f;
                depth = 0.0f;
            }
        }
        GL.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GL.glPushMatrix();
        GL.glTranslatef((float)0.0f, (float)0.0f, (float)depth);
        this.renderBackground();
        this.spriteEngine.setAlpha(alpha);
        this.spriteEngine.render();
        this.postRender();
        GL.glPopMatrix();
    }

    protected void renderBackground() {
    }

    protected void preRender() {
    }

    protected void postRender() {
    }

    public final Sprite allocateSprite(Object owner) {
        return this.spriteEngine.allocate(owner);
    }

    public static void tickAllScreens() {
        int i = 0;
        while (i < screens.size()) {
            Screen screen = (Screen)screens.get(i);
            screen.tick();
            if (screen.isActive()) {
                ++i;
                continue;
            }
            screens.remove(i);
        }
    }

    public static void renderAllScreens() {
        int i = 0;
        while (i < screens.size()) {
            Screen screen = (Screen)screens.get(i);
            screen.render();
            ++i;
        }
    }

    public static final boolean isMouseVisible() {
        if (screens.size() > 0) {
            Screen topmost = (Screen)screens.get(screens.size() - 1);
            return topmost.mouseVisible;
        }
        return true;
    }

    protected final float getAlpha() {
        return this.alpha;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public Area getArea(String name) {
        return (Area)((Object)this.nameToArea.get(name));
    }

    protected final boolean isOpening() {
        return this.phase == 1;
    }

    protected final boolean isClosing() {
        return this.phase == 3;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

