/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLTexture;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import genesis.Alien;
import genesis.Appearance;
import genesis.Behaviour;
import genesis.ColorPulse;
import genesis.Effect;
import genesis.Emitter;
import genesis.Entity;
import genesis.Game;
import genesis.GameScreen;
import genesis.LabelEffect;
import genesis.Options;
import genesis.Player;
import genesis.RainbowBurstEffect;
import genesis.RayEffect;
import genesis.RippleEffect;
import genesis.SFX;
import genesis.SpriteAllocator;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.w3c.dom.Element;

public class Room
extends Feature {
    public static final long serialVersionUID = 1L;
    private static SpriteAllocator spriteAllocator;
    private static final FloatBuffer scratchColor;
    private static final int SHOOTDELAY = 6;
    public static final int PLAYER_MAGIC = 4;
    private static final String[] PARTICLE_ANIMATIONS;
    private static final String[] MUSIC;
    private static final Color[] BACKGROUND_COLORS;
    private static final String[] TILES;
    private static int findAlienStart;
    public static final int NUM_ROOMS = 81;
    private static final Room[][] room;
    private static final int[] roomCount;
    private static final Vector3i scratch;
    private static float tx;
    private static float ty;
    private String title;
    private String help;
    private int distance;
    private Map behaviours;
    private List bullets;
    private List spawns;
    private List create;
    private List countdowns;
    private String collect;
    private int maxEntities = 32;
    private boolean template;
    private List triggers;
    private transient Animation[] particleAnimationResource;
    private transient ColorPulse backgroundColor;
    private transient ColorPulse strobeColor;
    private transient Map variables;
    private transient List entities;
    private transient List bulletFeatures;
    private transient List spawnFeatures;
    private transient List createFeatures;
    private transient int currentSpawnFeature;
    private transient Player player;
    private transient int shootDelay;
    private transient Emitter deathEmitter;
    private transient Emitter explosionEmitter;
    private transient Emitter collectEmitter;
    private transient Emitter spuriousEmitter;
    private transient Appearance collectResource;
    private transient boolean completed;
    private transient GLTexture backgroundTexture;
    private transient ALBuffer music;
    private transient boolean autogenerated;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("genesis.Room");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        scratchColor = BufferUtils.createFloatBuffer((int)4);
        PARTICLE_ANIMATIONS = new String[]{"particle_smoke.animation", "particle_star5.animation", "particle_star10.animation", "particle_spot.animation", "particle_point.animation"};
        MUSIC = new String[]{"music01.buffer", "music02.buffer", "music03.buffer", "music04.buffer", "music05.buffer", "music06.buffer", "music07.buffer", "music08.buffer", "music09.buffer"};
        BACKGROUND_COLORS = new Color[]{new Color(), new Color(), new Color(), new Color(), new Color(), new Color(), new Color(), new Color(), new Color()};
        TILES = new String[]{"tile04.texture", "tile02.texture", "tile03.texture", "tile01.texture", "tile05.texture", "tile06.texture", "tile07.texture", "tile08.texture", "tile09.texture"};
        int i = 0;
        while (i < 9) {
            BACKGROUND_COLORS[i].fromHSB((float)i / 8.0f, 0.5f, 0.5f);
            ++i;
        }
        room = new Room[9][];
        roomCount = new int[9];
        scratch = new Vector3i();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List behaviourList = XMLUtil.getChildren((Element)element, (String)"behaviour");
        this.behaviours = new HashMap();
        Iterator i = behaviourList.iterator();
        while (i.hasNext()) {
            Behaviour behaviour = new Behaviour();
            behaviour.load((Element)i.next(), loader);
            this.behaviours.put(behaviour.getID(), behaviour);
        }
        List triggerList = XMLUtil.getChildren((Element)element, (String)"trigger");
        this.triggers = new ArrayList();
        Iterator i2 = triggerList.iterator();
        while (i2.hasNext()) {
            Trigger trigger = new Trigger((Element)i2.next());
            this.triggers.add(trigger);
        }
        this.bullets = new ArrayList();
        if (XMLUtil.hasAttribute((Element)element, (String)"bullets")) {
            StringTokenizer st1 = new StringTokenizer(XMLUtil.getString((Element)element, (String)"bullets", (String)""), ",", false);
            while (st1.hasMoreTokens()) {
                this.bullets.add(st1.nextToken());
            }
        }
        this.spawns = new ArrayList();
        if (XMLUtil.hasAttribute((Element)element, (String)"spawn")) {
            StringTokenizer st2 = new StringTokenizer(XMLUtil.getString((Element)element, (String)"spawn"), ",", false);
            while (st2.hasMoreTokens()) {
                this.spawns.add(st2.nextToken());
            }
        }
        this.create = new ArrayList();
        if (XMLUtil.hasAttribute((Element)element, (String)"create")) {
            StringTokenizer st3 = new StringTokenizer(XMLUtil.getString((Element)element, (String)"create"), ",", false);
            while (st3.hasMoreTokens()) {
                this.create.add(st3.nextToken());
            }
        }
        this.countdowns = new ArrayList();
        if (XMLUtil.hasAttribute((Element)element, (String)"countdown")) {
            StringTokenizer st4 = new StringTokenizer(XMLUtil.getString((Element)element, (String)"countdown"), ",", false);
            while (st4.hasMoreTokens()) {
                this.countdowns.add(st4.nextToken());
            }
        }
    }

    protected void doCreate() throws Exception {
        Behaviour behaviour;
        Iterator<Object> i;
        super.doCreate();
        this.particleAnimationResource = new Animation[]{(Animation)Resources.get((String)PARTICLE_ANIMATIONS[(int)this.getParameter(4, 0.0f, (float)PARTICLE_ANIMATIONS.length - 1.0f)]), (Animation)Resources.get((String)PARTICLE_ANIMATIONS[(int)this.getParameter(5, 0.0f, (float)PARTICLE_ANIMATIONS.length - 1.0f)]), (Animation)Resources.get((String)PARTICLE_ANIMATIONS[(int)this.getParameter(6, 0.0f, (float)PARTICLE_ANIMATIONS.length - 1.0f)]), (Animation)Resources.get((String)PARTICLE_ANIMATIONS[(int)this.getParameter(7, 0.0f, (float)PARTICLE_ANIMATIONS.length - 1.0f)])};
        if (this.behaviours != null) {
            i = this.behaviours.values().iterator();
            while (i.hasNext()) {
                behaviour = (Behaviour)((Object)i.next());
                behaviour.create();
            }
        }
        if (this.bullets != null) {
            this.bulletFeatures = new ArrayList(this.bullets.size());
            i = this.bullets.iterator();
            while (i.hasNext()) {
                behaviour = (Behaviour)((Object)this.behaviours.get(i.next()));
                this.bulletFeatures.add(behaviour);
            }
        }
        if (this.spawns != null) {
            this.spawnFeatures = new ArrayList(this.spawns.size());
            i = this.spawns.iterator();
            while (i.hasNext()) {
                behaviour = (Behaviour)((Object)this.behaviours.get(i.next()));
                this.spawnFeatures.add(behaviour);
            }
        }
        if (this.create != null) {
            this.createFeatures = new ArrayList(this.create.size());
            i = this.create.iterator();
            while (i.hasNext()) {
                behaviour = (Behaviour)((Object)this.behaviours.get(i.next()));
                this.createFeatures.add(behaviour);
            }
        }
        this.deathEmitter = new Emitter(this, 4, this.particleAnimationResource[0]);
        this.explosionEmitter = new Emitter(this, 8, this.particleAnimationResource[1]);
        this.collectEmitter = new Emitter(this, 12, this.particleAnimationResource[2]);
        this.spuriousEmitter = new Emitter(this, 16, this.particleAnimationResource[3]);
        int backgroundIdx = (int)this.getParameter(8, 0.0f, (float)TILES.length - 1.0f);
        this.backgroundTexture = (GLTexture)Resources.get((String)TILES[backgroundIdx]);
        this.music = (ALBuffer)Resources.get((String)MUSIC[this.distance % MUSIC.length]);
        this.strobeColor.tick();
        this.backgroundColor.tick();
    }

    protected void doRegister() {
        if (room[this.distance] == null) {
            Room.room[this.distance] = new Room[this.distance * 2 + 1];
        }
        int x = this.distance;
        int n = this.distance;
        int n2 = roomCount[n];
        roomCount[n] = n2 + 1;
        int y = n2;
        Room.room[this.distance][y] = this;
        float[] temp1 = BACKGROUND_COLORS[x].toHSB(null);
        float[] temp2 = BACKGROUND_COLORS[(x + y + 1) % 9].toHSB(null);
        float dist = (float)Math.sqrt((x - 4) * (x - 4) + (y - 4) * (y - 4));
        this.backgroundColor = new ColorPulse(temp1[0], temp2[0], LinearInterpolator.instance.interpolate(0.5f, 1.0f, dist / 5.7f), 0.5f, LinearInterpolator.instance.interpolate(0.04f, 0.15f, (float)(x * y % 5) / 4.0f));
        float[] temp3 = BACKGROUND_COLORS[(int)(this.getColorParameter(0) * 8.0f)].toHSB(null);
        float[] temp4 = BACKGROUND_COLORS[(int)(this.getColorParameter(1) * 8.0f)].toHSB(null);
        this.strobeColor = new ColorPulse(temp2[0], temp3[0], LinearInterpolator.instance.interpolate(0.5f, 1.0f, (float)this.distance / 5.7f), 0.5f, LinearInterpolator.instance.interpolate(0.04f, 0.15f, (float)(this.distance % 5) / 4.0f));
    }

    protected void doDestroy() {
        super.doDestroy();
        Iterator i = this.behaviours.values().iterator();
        while (i.hasNext()) {
            Behaviour behaviour = (Behaviour)((Object)i.next());
            behaviour.destroy();
        }
        this.behaviours = null;
        this.spawnFeatures = null;
        this.bulletFeatures = null;
        this.particleAnimationResource = null;
    }

    public void tick() {
        float px = FPMath.floatValue((int)this.getPlayer().getPosition().getX()) - 400.0f;
        float py = FPMath.floatValue((int)this.getPlayer().getPosition().getY()) - 300.0f;
        if (Options.getStrobesEnabled()) {
            tx -= px / 40000.0f;
            ty -= py / 30000.0f;
            this.strobeColor.tick();
            this.backgroundColor.tick();
        }
        if (this.shootDelay > 0) {
            --this.shootDelay;
        }
        if (!this.completed && (Mouse.isButtonDown((int)0) || Keyboard.isKeyDown((int)29)) && this.player.canShoot() && this.shootDelay == 0 && this.bulletFeatures.size() > 0) {
            int choice = Util.random((int)0, (int)(this.bulletFeatures.size() - 1));
            Behaviour bullet = (Behaviour)((Object)this.bulletFeatures.get(choice));
            if (bullet != null) {
                bullet.tick(true);
            }
            this.shootDelay = 6;
        }
        if (!this.completed && this.spawnFeatures.size() > 0) {
            Behaviour behaviour;
            if ((behaviour = (Behaviour)((Object)this.spawnFeatures.get(this.currentSpawnFeature++))) != null) {
                behaviour.tick(false);
            }
            if (this.currentSpawnFeature >= this.spawnFeatures.size()) {
                this.currentSpawnFeature = 0;
            }
        }
        if (this.countdowns != null) {
            int n = this.countdowns.size();
            int i = 0;
            while (i < n) {
                int oldValue;
                String variable = (String)this.countdowns.get(i);
                Integer value = (Integer)this.variables.get(variable);
                if (value != null && (oldValue = value.intValue()) > 0) {
                    int newValue = oldValue - 1;
                    this.variables.put(variable, new Integer(newValue));
                    if (newValue == 0) {
                        this.checkTriggers(variable, 0);
                    }
                }
                ++i;
            }
        }
        this.tickAllEntities();
    }

    public void init(boolean doExtraTime) throws Exception {
        if (!this.isCreated()) {
            this.create();
        }
        this.variables = new HashMap();
        this.entities = new ArrayList(32);
        this.player = new Player();
        this.entities.add(this.player);
        this.player.spawn(spriteAllocator);
        findAlienStart = 1;
        this.currentSpawnFeature = 0;
        this.completed = false;
        if (this.createFeatures != null) {
            Iterator i = this.createFeatures.iterator();
            while (i.hasNext()) {
                Behaviour b = (Behaviour)((Object)i.next());
                b.tick(false);
            }
        }
        Game.playMusic(this.music, 180);
        if (this.help != null) {
            try {
                LabelEffect label = new LabelEffect((GLFont)Resources.get((String)"impact-plain-24.glfont"), this.help, 600);
                label.setLocation(400, 300);
                label.setVisible(true);
                Effect.addEffect(label);
            }
            catch (Exception e) {
                System.err.print(e);
            }
        }
        if (doExtraTime) {
            Behaviour b = (Behaviour)Resources.get((String)"extratime.behaviour");
            b.tick(false);
        }
    }

    public void cleanup() {
        int i = 0;
        while (i < this.entities.size()) {
            Entity e = (Entity)this.entities.get(i);
            e.remove();
            ++i;
        }
        this.entities = null;
        this.variables = null;
    }

    public float getParameter(int magic, float minValue, float maxValue) {
        int quantum = (int)(7.0f * Math.abs(Room.noise(this.distance, roomCount[this.distance], magic)));
        return LinearInterpolator.instance.interpolate(minValue, maxValue, (float)quantum / 6.0f);
    }

    public float getColorParameter(int magic) {
        int hue = (int)(5.0f * Math.abs(Room.noise(this.distance, roomCount[this.distance], magic)));
        return (float)hue / 6.0f;
    }

    private static float noise(int x, int y, int seed) {
        int n = x + y * (57 + seed) + seed;
        n = n << 13 ^ n;
        return 1.0f - (float)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.0737418E9f;
    }

    public void addVariable(String variable, int value) {
        int old;
        int sum;
        Integer oldValue = (Integer)this.variables.get(variable);
        if (oldValue == null) {
            oldValue = new Integer(0);
        }
        if ((sum = (old = oldValue.intValue()) + value) == old) {
            return;
        }
        Integer newValue = new Integer(sum);
        this.variables.put(variable, newValue);
        this.checkTriggers(variable, sum);
    }

    private void checkTriggers(String variable, int newValue) {
        int n = this.triggers.size();
        int i = 0;
        while (i < n) {
            ((Trigger)this.triggers.get(i)).check(variable, newValue);
            ++i;
        }
    }

    public void xorVariable(String variable, int value) {
        int old;
        int sum;
        Integer oldValue = (Integer)this.variables.get(variable);
        if (oldValue == null) {
            oldValue = new Integer(0);
        }
        if ((sum = (old = oldValue.intValue()) ^ value) == old) {
            return;
        }
        Integer newValue = new Integer(sum);
        this.variables.put(variable, newValue);
        this.checkTriggers(variable, sum);
    }

    public void orVariable(String variable, int value) {
        int sum;
        int old;
        Integer oldValue = (Integer)this.variables.get(variable);
        if (oldValue == null) {
            oldValue = new Integer(0);
        }
        if ((old = oldValue.intValue()) == (sum = old | value)) {
            return;
        }
        Integer newValue = new Integer(sum);
        this.variables.put(variable, newValue);
        this.checkTriggers(variable, sum);
    }

    public void andVariable(String variable, int value) {
        int old;
        int sum;
        Integer oldValue = (Integer)this.variables.get(variable);
        if (oldValue == null) {
            oldValue = new Integer(0);
        }
        if ((sum = (old = oldValue.intValue()) & value) == old) {
            return;
        }
        Integer newValue = new Integer(sum);
        this.variables.put(variable, newValue);
        this.checkTriggers(variable, sum);
    }

    public void setVariable(String variable, int value) {
        int old;
        Integer oldValue = (Integer)this.variables.get(variable);
        if (oldValue == null) {
            oldValue = new Integer(0);
        }
        if ((old = oldValue.intValue()) == value) {
            return;
        }
        Integer newValue = new Integer(value);
        this.variables.put(variable, newValue);
        this.checkTriggers(variable, value);
    }

    public boolean checkSafe(Alien spawning, Entity spawner, int x, int y, int radius) {
        int i = 0;
        while (i < this.entities.size()) {
            Entity src = (Entity)this.entities.get(i);
            if (spawner != src && spawning != src && src.canCollide()) {
                scratch.set(x, y, 0);
                Vector3i.sub((ReadableVector3i)src.getPosition(), (ReadableVector3i)scratch, (WritableVector3i)scratch);
                if (scratch.length() + src.getRadius() < radius) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private void tickAllEntities() {
        int i = 0;
        while (i < this.entities.size()) {
            Entity entity = (Entity)this.entities.get(i);
            entity.tick();
            ++i;
        }
        i = 0;
        while (i < this.entities.size()) {
            Entity src = (Entity)this.entities.get(i);
            if (!src.isAlive()) {
                this.entities.remove(i);
                continue;
            }
            int j = i + 1;
            while (j < this.entities.size() && src.isAlive()) {
                Entity dest = (Entity)this.entities.get(j);
                if (!dest.isAlive()) {
                    this.entities.remove(j);
                    continue;
                }
                if (src.canCollide() && dest.canCollide() && src.isTouching(dest)) {
                    src.onCollision(dest);
                    dest.onCollision(src);
                }
                ++j;
            }
            ++i;
        }
    }

    public static void setSpriteAllocator(SpriteAllocator spriteAllocator) {
        Room.spriteAllocator = spriteAllocator;
    }

    public static SpriteAllocator getSpriteAllocator() {
        return spriteAllocator;
    }

    public int getCount(Behaviour behaviour) {
        int n = this.entities.size();
        String masterID = behaviour.getMasterID();
        int count = 0;
        int i = 1;
        while (i < n) {
            Alien alien = (Alien)this.entities.get(i);
            if (masterID.equals(alien.getBehaviour().getMasterID()) && !alien.isCollected()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void addAlien(Alien alien) {
        alien.spawn(spriteAllocator);
        this.entities.add(alien);
    }

    public int getNumEntities() {
        return this.entities.size();
    }

    public int getMaxEntities() {
        return this.maxEntities;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Alien findNearestAlien(Alien src, String behaviour) {
        return (Alien)this.findNearestEntity(src, behaviour, 1);
    }

    public Entity findNearestEntity(Alien src, String behaviour, int start) {
        int n = this.entities.size();
        Entity shortest = null;
        long dist = Long.MAX_VALUE;
        int i = start;
        while (i < n) {
            Alien alien;
            Entity entity = (Entity)this.entities.get(i);
            if (i == 0 || (alien = (Alien)entity) != null && alien != src && alien.getBehaviour() != null && alien.canCollide() && (behaviour.equals("any") || alien.getBehaviour().getMasterID().equals(behaviour))) {
                Vector3i.sub((ReadableVector3i)src.getPosition(), (ReadableVector3i)entity.getPosition(), (WritableVector3i)scratch);
                long newDist = scratch.lengthSquared();
                if (newDist < dist) {
                    dist = newDist;
                    shortest = entity;
                }
            }
            ++i;
        }
        return shortest;
    }

    public Alien findAlien(String behaviour) {
        Alien alien;
        if (!$assertionsDisabled && behaviour == null) {
            throw new AssertionError();
        }
        int n = this.entities.size();
        int i = findAlienStart;
        while (i < n) {
            alien = (Alien)this.entities.get(i);
            if (alien == null) break;
            if (alien.getBehaviour() != null && alien.canCollide() && behaviour.equals(alien.getBehaviour().getMasterID())) {
                findAlienStart = i + 1;
                return (Alien)this.entities.get(i);
            }
            ++i;
        }
        n = findAlienStart;
        i = 1;
        while (i < n) {
            alien = (Alien)this.entities.get(i);
            if (alien == null) break;
            if (alien.getBehaviour() != null && alien.canCollide() && behaviour.equals(alien.getBehaviour().getMasterID())) {
                findAlienStart = i + 1;
                return (Alien)this.entities.get(i);
            }
            ++i;
        }
        findAlienStart = 1;
        return null;
    }

    public static Room[] getRooms(int dist) {
        return room[dist];
    }

    public ColorPulse getBackgroundColor() {
        return this.backgroundColor;
    }

    public ColorPulse getStrobeColor() {
        return this.strobeColor;
    }

    public Behaviour getBehaviour(String id) {
        return (Behaviour)((Object)this.behaviours.get(id));
    }

    public void alienExplosionEffect(Alien alien) {
        SFX.alienExplode();
        this.explosionEmitter.emit(alien.getPosition(), spriteAllocator);
    }

    public void spuriousParticleEffect(Alien alien) {
        SFX.spuriousParticles();
        this.spuriousEmitter.emit(alien.getPosition(), spriteAllocator);
    }

    public void collectionEffect(Alien alien) {
        SFX.collect();
        this.collectEmitter.emit(alien.getPosition(), spriteAllocator);
        RainbowBurstEffect fx = new RainbowBurstEffect(7);
        fx.setLocation(FPMath.intValue((int)alien.getPosition().getX()), FPMath.intValue((int)alien.getPosition().getY()));
        Effect.addEffect(fx);
        GameScreen.strobe(30);
    }

    public Appearance getCollectAppearance() {
        return this.collectResource;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isStartRoom() {
        return this.distance == 0;
    }

    public void completedEffect(Player player) {
        int n;
        GameScreen.showCompleted();
        SFX.completeRoom();
        int i = n = this.entities.size();
        while (--i >= 1) {
            Alien alien = (Alien)this.entities.get(i);
            if (alien.isCollected()) continue;
            this.alienExplosionEffect(alien);
            alien.remove();
        }
        RippleEffect fx = new RippleEffect();
        fx.setLocation(FPMath.intValue((int)player.getPosition().getX()), FPMath.intValue((int)player.getPosition().getY()));
        Effect.addEffect(fx);
        GameScreen.strobe(60);
        this.completed = true;
    }

    public void extraTimeEffect(Player player) {
        SFX.extraLife();
        RayEffect fx1 = new RayEffect();
        RippleEffect fx2 = new RippleEffect();
        fx1.setLocation(FPMath.intValue((int)player.getPosition().getX()), FPMath.intValue((int)player.getPosition().getY()));
        fx2.setLocation(FPMath.intValue((int)player.getPosition().getX()), FPMath.intValue((int)player.getPosition().getY()));
        Effect.addEffect(fx1);
        Effect.addEffect(fx2);
        GameScreen.strobe(60);
    }

    public void fireEvent(String event) {
        int n = this.entities.size();
        int i = 1;
        while (i < n) {
            ((Alien)this.entities.get(i)).onEvent(event);
            ++i;
        }
    }

    public void render() {
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        if (GLContext.GL_ARB_texture_env_combine) {
            GL11.glTexEnvi((int)8960, (int)8704, (int)34160);
            GL11.glTexEnvi((int)8960, (int)34161, (int)34165);
            GL11.glTexEnvi((int)8960, (int)34176, (int)34167);
            GL11.glTexEnvi((int)8960, (int)34177, (int)34166);
            GL11.glTexEnvi((int)8960, (int)34178, (int)5890);
            GL11.glTexEnvi((int)8960, (int)34192, (int)768);
            GL11.glTexEnvi((int)8960, (int)34193, (int)768);
            GL11.glTexEnvi((int)8960, (int)34194, (int)770);
        } else if (GLContext.GL_EXT_texture_env_combine) {
            GL11.glTexEnvi((int)8960, (int)8704, (int)34160);
            GL11.glTexEnvi((int)8960, (int)34161, (int)34165);
            GL11.glTexEnvi((int)8960, (int)34176, (int)34167);
            GL11.glTexEnvi((int)8960, (int)34177, (int)34166);
            GL11.glTexEnvi((int)8960, (int)34186, (int)5890);
            GL11.glTexEnvi((int)8960, (int)34192, (int)768);
            GL11.glTexEnvi((int)8960, (int)34193, (int)768);
            GL11.glTexEnvi((int)8960, (int)34194, (int)770);
        } else {
            GL11.glTexEnvi((int)8960, (int)8704, (int)3042);
        }
        scratchColor.put((float)this.strobeColor.getColor().getRed() / 255.0f);
        scratchColor.put((float)this.strobeColor.getColor().getGreen() / 255.0f);
        scratchColor.put((float)this.strobeColor.getColor().getBlue() / 255.0f);
        scratchColor.put(1.0f);
        scratchColor.flip();
        GL11.glTexEnv((int)8960, (int)8705, (FloatBuffer)scratchColor);
        this.backgroundTexture.render();
        ColorUtil.setGLColor((ReadableColor)this.backgroundColor.getColor());
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)tx, (float)ty, (float)0.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2i((int)0, (int)0);
        GL11.glTexCoord2f((float)(800.0f / (float)this.backgroundTexture.getWidth()), (float)0.0f);
        GL11.glVertex2i((int)800, (int)0);
        GL11.glTexCoord2f((float)(800.0f / (float)this.backgroundTexture.getWidth()), (float)(600.0f / (float)this.backgroundTexture.getHeight()));
        GL11.glVertex2i((int)800, (int)600);
        GL11.glTexCoord2f((float)0.0f, (float)(600.0f / (float)this.backgroundTexture.getHeight()));
        GL11.glVertex2i((int)0, (int)600);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
    }

    public boolean isTemplate() {
        return this.template;
    }

    private class Trigger
    implements Serializable {
        static final long serialVersionUID = 1L;
        private static final int OP_EQUALS = 0;
        private static final int OP_LESSTHAN = 1;
        private static final int OP_GREATERTHAN = 2;
        private static final int OP_LESSTHANOREQUALS = 3;
        private static final int OP_GREATERTHANOREQUALS = 4;
        private static final int OP_NOTEQUALS = 5;
        private static final int OP_SET = 6;
        private static final int OP_UNSET = 7;
        private String variable;
        private int op;
        private int value;
        private String event;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("genesis.Room$Trigger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public Trigger(Element element) throws Exception {
            this.variable = XMLUtil.getString((Element)element, (String)"variable");
            String sop = XMLUtil.getString((Element)element, (String)"compare");
            if (sop.startsWith("=")) {
                this.op = 0;
                this.value = Integer.parseInt(sop.substring(1));
            } else if (sop.startsWith("<=")) {
                this.op = 3;
                this.value = Integer.parseInt(sop.substring(2));
            } else if (sop.startsWith(">=")) {
                this.op = 4;
                this.value = Integer.parseInt(sop.substring(2));
            } else if (sop.startsWith("<>")) {
                this.op = 5;
                this.value = Integer.parseInt(sop.substring(2));
            } else if (sop.startsWith("!=")) {
                this.op = 5;
                this.value = Integer.parseInt(sop.substring(2));
            } else if (sop.startsWith("!set")) {
                this.op = 7;
                this.value = Integer.parseInt(sop.substring(4));
            } else if (sop.startsWith("<")) {
                this.op = 1;
                this.value = Integer.parseInt(sop.substring(1));
            } else if (sop.startsWith(">")) {
                this.op = 2;
                this.value = Integer.parseInt(sop.substring(1));
            } else if (sop.startsWith("set")) {
                this.op = 6;
                this.value = Integer.parseInt(sop.substring(3));
            } else {
                this.op = 0;
                this.value = Integer.parseInt(sop);
            }
            this.event = XMLUtil.getString((Element)element, (String)"event");
        }

        void fire() {
            Room.this.fireEvent(this.event);
        }

        void check(String varName, int var) {
            if (!varName.equals(this.variable)) {
                return;
            }
            switch (this.op) {
                case 0: {
                    if (var != this.value) break;
                    this.fire();
                    break;
                }
                case 1: {
                    if (var >= this.value) break;
                    this.fire();
                    break;
                }
                case 3: {
                    if (var > this.value) break;
                    this.fire();
                    break;
                }
                case 2: {
                    if (var <= this.value) break;
                    this.fire();
                    break;
                }
                case 4: {
                    if (var < this.value) break;
                    this.fire();
                    break;
                }
                case 5: {
                    if (var == this.value) break;
                    this.fire();
                    break;
                }
                case 6: {
                    if ((var & this.value) != this.value) break;
                    this.fire();
                    break;
                }
                case 7: {
                    if ((var & this.value) != 0) break;
                    this.fire();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
    }
}

