/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.Memory;
import com.shavenpuppy.jglib.opengl.GLBackBufferTexture;
import com.shavenpuppy.jglib.opengl.nvidia.AGPMemory;
import com.shavenpuppy.jglib.opengl.nvidia.GLFence;
import genesis.Effect;
import genesis.Range;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class RippleEffect
extends Effect {
    private static final long serialVersionUID = 1L;
    private static final int SIZE = 32;
    private static final int SIZEby2 = 16;
    private static final int RESOLUTION = 8;
    private static final float MAXDIST = (float)Math.sqrt(578.0);
    private float[] z = new float[1024];
    private int tick;
    private int duration = 90;
    private float ripple = new Range(0.2f, 0.7f).getValue();
    private float frequency = new Range(0.2f, 0.7f).getValue();
    private float range = new Range(24.0f, 48.0f).getValue();
    private int x;
    private int y;
    private static GLBackBufferTexture scratch;
    private static FloatBuffer vertexBuffer;
    private static FloatBuffer texCoordBuffer;
    private static ShortBuffer indexBuffer;
    private static RippleEffect instance;
    private static GLFence fence;
    private static boolean initialized;

    public RippleEffect() {
        if (!initialized) {
            RippleEffect.initialize();
        }
        if (instance != null) {
            Effect.removeEffect(instance);
        }
        instance = this;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    protected boolean isActive() {
        return this.tick < this.duration;
    }

    protected void tick() {
        ++this.tick;
        if (this.tick >= this.duration) {
            return;
        }
        float fade = (float)(this.duration - this.tick) / (float)this.duration;
        double rtick = this.ripple * (float)this.tick;
        int yy = 0;
        while (yy < 32) {
            int xx = 0;
            while (xx < 32) {
                float dx = xx - 16;
                float dy = yy - 16;
                float dist = (float)Math.sqrt(dx * dx + dy * dy);
                vertexBuffer.position((xx + yy * 32) * 8 + 2);
                vertexBuffer.put(fade * this.range * (float)Math.cos((double)(this.frequency * dist) + rtick) * (MAXDIST - dist) / MAXDIST);
                ++xx;
            }
            ++yy;
        }
        vertexBuffer.rewind();
    }

    private static void initialize() {
        try {
            int xx;
            scratch = new GLBackBufferTexture("scratch.texture", 256, 256);
            scratch.create();
            if (GLContext.GL_NV_vertex_array_range || GLContext.GL_NV_vertex_array_range2) {
                fence = new GLFence();
                fence.create();
            }
            Memory memory = AGPMemory.allocate((int)33792);
            memory.create();
            vertexBuffer = memory.getBuffer().asFloatBuffer();
            texCoordBuffer = Memory.chop((ByteBuffer)memory.getBuffer(), (int)12).asFloatBuffer();
            Memory indexMemory = AGPMemory.allocate((int)33792);
            indexMemory.create();
            indexBuffer = indexMemory.getBuffer().asShortBuffer();
            int yy = 0;
            while (yy < 32) {
                xx = 0;
                while (xx < 32) {
                    vertexBuffer.position((xx + yy * 32) * 8);
                    vertexBuffer.put(xx * 8);
                    vertexBuffer.put(yy * 8);
                    vertexBuffer.put(0.0f);
                    vertexBuffer.put((float)xx / 32.0f);
                    vertexBuffer.put((float)yy / 32.0f);
                    ++xx;
                }
                ++yy;
            }
            vertexBuffer.rewind();
            yy = 0;
            while (yy < 31) {
                xx = 0;
                while (xx < 31) {
                    indexBuffer.put((short)(xx + yy * 32));
                    indexBuffer.put((short)(xx + 1 + yy * 32));
                    indexBuffer.put((short)(xx + 1 + 32 + yy * 32));
                    indexBuffer.put((short)(xx + yy * 32));
                    indexBuffer.put((short)(xx + 1 + 32 + yy * 32));
                    indexBuffer.put((short)(xx + 32 + yy * 32));
                    ++xx;
                }
                ++yy;
            }
            indexBuffer.flip();
            initialized = true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    protected void render() {
        if (GLContext.GL_NV_vertex_array_range || GLContext.GL_NV_vertex_array_range2) {
            fence.finish();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        scratch.render();
        scratch.update(this.x - 128, this.y - 128);
        if (GLContext.GL_NV_vertex_array_range2) {
            GL11.glEnableClientState((int)34099);
        } else if (GLContext.GL_NV_vertex_array_range) {
            GL11.glEnableClientState((int)34077);
        }
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)vertexBuffer);
        GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)texCoordBuffer);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.x - 128), (float)(this.y - 128), (float)0.0f);
        GL11.glDrawElements((int)4, (ShortBuffer)indexBuffer);
        GL11.glPopMatrix();
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32888);
        if (GLContext.GL_NV_vertex_array_range || GLContext.GL_NV_vertex_array_range2) {
            fence.set(34034);
            if (GLContext.GL_NV_vertex_array_range2) {
                GL11.glDisableClientState((int)34099);
            } else if (GLContext.GL_NV_vertex_array_range) {
                GL11.glDisableClientState((int)34077);
            }
        }
    }
}

