/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.util.CheckOnline;
import genesis.Game;
import genesis.MessageBox;
import genesis.SFX;
import genesis.Screen;
import genesis.TextField;
import genesis.TitleScreen;
import java.rmi.Naming;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import net.puppygames.gamecommerce.shared.RegistrationServerRemote;
import net.puppygames.gamecommerce.shared.ValidateUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class RegisterScreen
extends Screen {
    public static final long serialVersionUID = 1L;
    private static RegisterScreen instance;
    private static final String REGISTER = "register";
    private static final String CANCEL = "cancel";
    private static final String CODE = "code";
    private static final String EMAIL = "email";
    private static final int EMAIL_X = 68;
    private static final int EMAIL_Y = 313;
    private static final int CODE_X = 68;
    private static final int CODE_Y = 224;
    private transient TextField emailField;
    private transient TextField codeField;
    private transient boolean valid;
    private transient MessageBox messageBox;
    private transient int phase;
    private transient RegistrationDetails regDetails;
    private static final int PHASE_NORMAL = 0;
    private static final int PHASE_WAIT_REMOTE = 1;
    private static final int PHASE_WAIT_CLICK0 = 2;
    private static final int PHASE_WAIT_CLICK1 = 3;
    private static final int PHASE_ERROR = 4;
    private static final int PHASE_FATAL_ERROR = 5;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("genesis.RegisterScreen");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        GLFont font = (GLFont)Resources.get((String)"impact-plain-24.glfont");
        this.emailField = new TextField(64){

            public boolean acceptChar(char c) {
                return Character.isLetterOrDigit(c) || c >= ' ' && c <= '\u007f';
            }

            protected void onChangeFocus() {
                RegisterScreen.this.codeField.setEditing(true);
            }

            protected void onEdited() {
                SFX.shoot();
                RegisterScreen.this.checkValid();
            }
        };
        this.emailField.setFont(font);
        this.emailField.setLocation(68, 313);
        this.codeField = new TextField(14){

            public boolean acceptChar(char c) {
                return Character.isDigit(c) || c >= 'a' && c <= 'f';
            }

            protected void onChangeFocus() {
                RegisterScreen.this.onClicked(RegisterScreen.REGISTER);
            }

            protected void onEdited() {
                SFX.shoot();
                RegisterScreen.this.checkValid();
            }
        };
        this.codeField.setFont(font);
        this.codeField.setLocation(68, 224);
    }

    protected void doRegister() {
        instance = this;
    }

    protected void doDeregister() {
        instance = null;
    }

    public static void show() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        instance.open();
    }

    protected void onOpen() {
        Game.setPauseEnabled(false);
        this.emailField.setEditing(true);
        this.checkValid();
        this.phase = 0;
    }

    protected void onClose() {
        Game.setPauseEnabled(true);
        this.messageBox = null;
    }

    protected void doCleanup() {
        super.doCleanup();
        this.destroy();
    }

    protected void onClicked(String id) {
        if (id.equals(REGISTER) && this.valid) {
            this.registration();
        } else if (id.equals(CANCEL)) {
            TitleScreen.show();
        } else if (id.equals(EMAIL)) {
            this.emailField.setEditing(true);
            this.codeField.setEditing(false);
        } else if (id.equals(CODE)) {
            this.codeField.setEditing(true);
            this.emailField.setEditing(false);
        }
    }

    private void registration() {
        this.setEnabled(false);
        try {
            this.messageBox = new MessageBox();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            TitleScreen.show();
        }
        this.messageBox.setSize(600, 300);
        if (!CheckOnline.isOnline()) {
            this.messageBox.setTitle("Registration Failed");
            this.messageBox.setMessage("It appears that you are not connected to the internet! Please exit Super Dudester and connect to the internet, and try again.");
            this.phase = 5;
        } else {
            this.phase = 1;
            this.messageBox.setTitle("Registering");
            this.messageBox.setMessage("Please wait whilst Super Dudester contacts the Puppy Game registration server to unlock your game.");
            new Thread(){

                public void run() {
                    RegistrationServerRemote server;
                    try {
                        server = (RegistrationServerRemote)Naming.lookup("//67.18.194.226/registration");
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        RegisterScreen.this.registrationFailed("There has been a problem connecting to the Puppy Games registration server. Please ensure you are online and try again, or alternatively contact us on support@puppygames.net for assistance.\n\nClick the mouse to continue.", 4);
                        return;
                    }
                    try {
                        System.out.println(server);
                        RegistrationDetails regDetails = server.register(RegisterScreen.this.emailField.getText(), RegisterScreen.this.codeField.getText(), "Super Dudester", "1.0", Game.getAffiliate(), (ConfigurationDetails)Game.getConfiguration());
                        RegisterScreen.this.registrationSuccess(regDetails);
                    }
                    catch (Throwable e) {
                        e.printStackTrace(System.err);
                        RegisterScreen.this.registrationFailed("There has been a problem registering your game with Puppy Games registration server. Please contact us on support@puppygames.net for assistance.\n\nClick the mouse to continue.", 5);
                        return;
                    }
                }
            }.start();
        }
    }

    private void registrationFailed(String message, int nextPhase) {
        this.messageBox.setTitle("Registration Failed");
        this.messageBox.setMessage(message);
        this.phase = nextPhase;
    }

    private void registrationSuccess(RegistrationDetails regDetails) {
        this.messageBox.setTitle("Registration Success!");
        this.messageBox.setMessage("Congratulations! Your copy of Super Dudester has been unlocked and registered to you.\n\nClick the mouse to continue.");
        this.phase = 2;
        this.regDetails = regDetails;
    }

    protected void doTick() {
        switch (this.phase) {
            case 0: {
                this.emailField.tick();
                this.codeField.tick();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                TitleScreen.instantiate();
                Game.setRegistrationDetails(this.regDetails);
                this.regDetails = null;
                this.phase = 3;
                break;
            }
            case 3: 
            case 5: {
                if (!Mouse.isButtonDown((int)0)) break;
                TitleScreen.show();
                break;
            }
            case 4: {
                if (!Mouse.isButtonDown((int)0)) break;
                this.messageBox = null;
                this.phase = 0;
                this.setEnabled(true);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    protected void postRender() {
        GL11.glEnable((int)3553);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        ColorUtil.setGLColor((ReadableColor)Color.WHITE);
        this.emailField.render();
        this.codeField.render();
        if (this.messageBox != null) {
            this.messageBox.render();
        }
    }

    public void checkValid() {
        this.valid = ValidateUtil.isEmail((String)this.emailField.getText()) && this.codeField.getText().length() == 14;
        this.getArea(REGISTER).setEnabled(this.valid);
    }
}

