/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.util.Util;
import genesis.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;

public class RayEffect
extends Effect {
    public static final long serialVersionUID = 1L;
    private static final Color color = new Color();
    private static final int NUM_RAYS = 20;
    private static RayEffect instance;
    private int x;
    private int y;
    private final Ray[] ray;

    public RayEffect() {
        if (instance != null) {
            Effect.removeEffect(instance);
        }
        instance = this;
        this.ray = new Ray[20];
        int i = 0;
        while (i < this.ray.length) {
            this.ray[i] = new Ray();
            ++i;
        }
    }

    protected boolean isActive() {
        int i = 0;
        while (i < this.ray.length) {
            if (this.ray[i].isActive()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void tick() {
        int i = 0;
        while (i < this.ray.length) {
            this.ray[i].tick();
            ++i;
        }
    }

    protected void render() {
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        int i = 0;
        while (i < this.ray.length) {
            this.ray[i].render();
            ++i;
        }
        GL11.glPopMatrix();
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    class Ray {
        int angle = Util.random((int)0, (int)255);
        int speed = Util.random((int)1, (int)5);
        int duration;
        int tick;
        int size = Util.random((int)8, (int)16);
        float hue;

        Ray() {
            this.duration = Util.random((int)200, (int)300);
            this.hue = (float)Math.random();
        }

        void tick() {
            this.angle += this.speed;
            this.hue += 0.005f;
            ++this.tick;
        }

        boolean isActive() {
            return this.tick < this.duration;
        }

        void render() {
            GL11.glBegin((int)4);
            color.fromHSB(this.hue, 1.0f, 1.0f);
            GL11.glColor4ub((byte)color.getRedByte(), (byte)color.getGreenByte(), (byte)color.getBlueByte(), (byte)0);
            GL11.glVertex2i((int)0, (int)0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)this.tick / (float)this.duration));
            float x0 = (float)Math.cos(Math.PI * 2 * (double)this.angle / 256.0) * 800.0f * 1.5f;
            float y0 = (float)Math.sin(Math.PI * 2 * (double)this.angle / 256.0) * 800.0f * 1.5f;
            float x1 = (float)Math.cos(Math.PI * 2 * (double)(this.angle + this.size) / 256.0) * 800.0f * 1.5f;
            float y1 = (float)Math.sin(Math.PI * 2 * (double)(this.angle + this.size) / 256.0) * 800.0f * 1.5f;
            GL11.glVertex2f((float)x0, (float)y0);
            GL11.glVertex2f((float)x1, (float)y1);
            GL11.glEnd();
        }
    }
}

