/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.interpolators.SineInterpolator;
import genesis.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;

public class RainbowBurstEffect
extends Effect {
    private static final long serialVersionUID = 1L;
    private int x;
    private int y;
    private int duration = 8;
    private boolean active = true;
    private static final Color color = new Color();
    private static final float blastRadius = 500.0f;
    private final Blast[] blast;
    private static RainbowBurstEffect instance;

    public RainbowBurstEffect(int numBlastWaves) {
        if (instance != null) {
            Effect.removeEffect(instance);
        }
        instance = this;
        this.blast = new Blast[numBlastWaves];
        int delay = 0;
        int i = 0;
        while (i < numBlastWaves) {
            this.blast[i] = new Blast();
            delay = this.blast[i].init(delay, (float)i / (float)numBlastWaves);
            ++i;
        }
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void tick() {
        boolean dontRemove = false;
        int i = 0;
        while (i < this.blast.length) {
            this.blast[i].tick();
            if (this.blast[i].active) {
                dontRemove = true;
            }
            ++i;
        }
        if (!dontRemove) {
            this.active = false;
        }
    }

    protected void render() {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        int i = 0;
        while (i < this.blast.length) {
            this.blast[i].render();
            ++i;
        }
        GL11.glBlendFunc((int)1, (int)0);
        GL11.glDisable((int)3042);
    }

    private class Blast {
        int tick;
        boolean active;
        final Color color = new Color();
        int thisDuration;

        Blast() {
            this.thisDuration = RainbowBurstEffect.this.duration * 2;
        }

        int init(int delay, float hue) {
            int waitDuration = delay == 0 ? 0 : delay;
            this.tick = -waitDuration;
            this.color.fromHSB(hue, 1.0f, 1.0f);
            this.active = true;
            return waitDuration + RainbowBurstEffect.this.duration / 2;
        }

        void tick() {
            if (!this.active) {
                return;
            }
            ++this.tick;
            if (this.tick >= this.thisDuration) {
                this.active = false;
            }
        }

        void render() {
            if (!this.active || this.tick < 0) {
                return;
            }
            float outerRadius = SineInterpolator.instance.interpolate(0.0f, 500.0f, (float)this.tick / (float)this.thisDuration);
            float innerRadius = SineInterpolator.instance.interpolate(0.0f, 500.0f, (float)Math.max(0, this.tick - RainbowBurstEffect.this.duration) / (float)this.thisDuration);
            GL11.glBegin((int)5);
            int i = 0;
            while (i <= 360) {
                GL11.glColor4ub((byte)this.color.getRedByte(), (byte)this.color.getGreenByte(), (byte)this.color.getBlueByte(), (byte)0);
                GL11.glVertex2f((float)((float)RainbowBurstEffect.this.x + (float)Math.cos(Math.toRadians(i)) * innerRadius), (float)((float)RainbowBurstEffect.this.y + (float)Math.sin(Math.toRadians(i)) * innerRadius));
                GL11.glColor4ub((byte)this.color.getRedByte(), (byte)this.color.getGreenByte(), (byte)this.color.getBlueByte(), (byte)((byte)(255.0f - 255.0f * ((float)this.tick / (float)this.thisDuration))));
                GL11.glVertex2f((float)((float)RainbowBurstEffect.this.x + (float)Math.cos(Math.toRadians(i)) * outerRadius), (float)((float)RainbowBurstEffect.this.y + (float)Math.sin(Math.toRadians(i)) * outerRadius));
                i += 12;
            }
            GL11.glEnd();
        }
    }
}

