/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import genesis.Alien;
import genesis.Effect;
import genesis.Entity;
import genesis.Game;
import genesis.GameScreen;
import genesis.LabelEffect;
import genesis.RainbowBurstEffect;
import genesis.Room;
import genesis.SFX;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.Color;

public class Player
extends Entity {
    private static final int INTRADIUS = 24;
    private static final int RADIUS;
    private static final int IMMUNITY_TIME = 120;
    public static final int COMPLETE_TIME = 120;
    private static final Color color;
    private static final int MAX_SPEED;
    private static final int THRUST;
    private static final int TRAIL_GAP = 8;
    private static final int MAX_COLLECTED = 8;
    private static final int TRAIL_LENGTH = 64;
    private static final int DIRECTION_THRESHOLD;
    private static final Vector3i[] trail;
    private List collectFX = new ArrayList(64);
    private int tick;
    private int phase;
    private final List collected = new ArrayList();
    private int damaged;
    private int trailIndex;
    private int mouseX;
    private int mouseY;
    private int penalty;
    private static final int SPAWNING = 0;
    private static final int ALIVE = 1;
    private static final int COMPLETE = 3;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("genesis.Player");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        RADIUS = FPMath.fpValue((int)24);
        color = new Color();
        MAX_SPEED = FPMath.fpValue((int)800);
        THRUST = FPMath.fpValue((int)140);
        DIRECTION_THRESHOLD = FPMath.TWO;
        trail = new Vector3i[64];
        int i = 0;
        while (i < trail.length) {
            Player.trail[i] = new Vector3i();
            ++i;
        }
    }

    public Player() {
        this.getPosition().set(FPMath.fpValue((int)800) / 2, FPMath.fpValue((int)128), 0);
        this.setAngle(FPMath.QUARTER);
        this.mouseX = 400;
        this.mouseY = 300;
    }

    public boolean canCollide() {
        return this.phase == 1;
    }

    public boolean canShoot() {
        return true;
    }

    public int getRadius() {
        return RADIUS;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithPlayer(this);
    }

    public void onCollisionWithAlien(Alien alien) {
    }

    public void onCollisionWithPlayer(Player player) {
    }

    protected void doTick() {
        switch (this.phase) {
            case 0: {
                this.spawnTick();
                break;
            }
            case 1: {
                this.aliveTick();
                break;
            }
            case 3: {
                this.completeTick();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    private void spawnTick() {
        ++this.tick;
        if (this.tick >= 120) {
            this.phase = 1;
            this.tick = 0;
            this.setVisible(true);
            Game.getGameState().resumeTimer();
        } else {
            this.setVisible((this.tick & 4) == 0);
        }
        this.aliveTick();
    }

    protected void doSpawn() {
        this.setLayer(1);
        this.setImage(GameScreen.getPlayerSpriteImage(FPMath.QUARTER));
    }

    private void aliveTick() {
        this.mouseX += Mouse.getDX();
        this.mouseY += Mouse.getDY();
        if (this.mouseX < 0) {
            this.mouseX = 0;
        } else if (this.mouseX >= 800) {
            this.mouseX = 799;
        }
        if (this.mouseY < 0) {
            this.mouseY = 0;
        } else if (this.mouseY >= 600) {
            this.mouseY = 599;
        }
        Vector3i velocity = this.getVelocity();
        velocity.set(FPMath.fpValue((int)this.mouseX), FPMath.fpValue((int)this.mouseY), 0);
        Vector3i position = this.getPosition();
        Vector3i.sub((ReadableVector3i)velocity, (ReadableVector3i)position, (WritableVector3i)velocity);
        int distance = velocity.length();
        if (distance > MAX_SPEED) {
            distance = MAX_SPEED;
        }
        if (distance >= DIRECTION_THRESHOLD) {
            double angle = Math.atan2(velocity.getY(), velocity.getX());
            int spriteAngle = (int)(8.0 * (Math.PI * 2 + angle + 0.39269908169872414) / (Math.PI * 2));
            this.setAngle(FPMath.EIGHTH * (spriteAngle %= 8));
            this.setImage(GameScreen.getPlayerSpriteImage(FPMath.EIGHTH * spriteAngle));
        }
        velocity.normalize();
        float scale = FPMath.floatValue((int)THRUST) * FPMath.floatValue((int)distance) / FPMath.floatValue((int)MAX_SPEED);
        velocity.scale(FPMath.fpValue((float)scale));
        Vector3i.add((ReadableVector3i)position, (ReadableVector3i)velocity, (WritableVector3i)position);
        if (position.getX() < RADIUS) {
            position.setX(RADIUS);
        } else if (position.getX() >= FPMath.fpValue((int)800) - RADIUS) {
            position.setX(FPMath.fpValue((int)799) - RADIUS);
        }
        if (position.getY() < RADIUS) {
            position.setY(RADIUS);
        } else if (position.getY() >= FPMath.fpValue((int)600) - RADIUS) {
            position.setY(FPMath.fpValue((int)599) - RADIUS);
        }
        this.moveTrail();
        int n = this.collectFX.size();
        int count = 0;
        int pos = this.trailIndex - 8;
        int i = 1;
        while (i < n) {
            if (--pos < 0) {
                pos += 64;
            }
            if (i % 8 == 0) {
                ++count;
            } else {
                Sprite s = (Sprite)this.collectFX.get(i);
                Alien alien = (Alien)this.collected.get(count);
                s.setImage(alien.getImage());
                s.setLocation(FPMath.intValue((int)trail[pos].getX()), FPMath.intValue((int)trail[pos].getY()), 0);
                s.setAlpha(64 - (int)(255.0f * (float)(i % 8) / 28.0f));
            }
            ++i;
        }
        if (this.damaged > 0) {
            --this.damaged;
            this.setFlash((this.damaged & 4) == 4);
        }
    }

    private void moveTrail() {
        ++this.trailIndex;
        if (this.trailIndex == trail.length) {
            this.trailIndex = 0;
        }
        trail[this.trailIndex].set((ReadableVector3i)this.getPosition());
        int n = this.collected.size();
        int pos = this.trailIndex;
        int i = 0;
        while (i < n) {
            if ((pos -= 8) < 0) {
                pos += 64;
            }
            Alien alien = (Alien)this.collected.get(i);
            alien.getPosition().set((ReadableVector3i)trail[pos]);
            alien.updateAppearance();
            ++i;
        }
    }

    protected void doRemove() {
        Iterator i = this.collectFX.iterator();
        while (i.hasNext()) {
            Sprite s = (Sprite)i.next();
            if (s == null) continue;
            s.deallocate();
        }
        this.collectFX.clear();
    }

    private void completeTick() {
        ++this.tick;
        if (this.tick >= 120) {
            Game.getGameState().completeRoom();
        } else {
            int scale = LinearInterpolator.instance.interpolate(FPMath.ONE, 0, FPMath.div((int)FPMath.fpValue((int)this.tick), (int)FPMath.fpValue((int)120)));
            int i = 0;
            while (i < this.collected.size()) {
                Alien alien = (Alien)this.collected.get(i);
                alien.setScale(scale);
                ++i;
            }
            i = 0;
            while (i < this.collectFX.size()) {
                Sprite s = (Sprite)this.collectFX.get(i);
                if (s != null) {
                    s.setScale(scale);
                }
                ++i;
            }
        }
    }

    public void collect(Alien alien) {
        alien.setCollected(true);
        this.collected.add(alien);
        this.collectFX.add(null);
        int i = 1;
        while (i < 8) {
            Sprite s = Room.getSpriteAllocator().allocateSprite(this);
            this.collectFX.add(s);
            ++i;
        }
        if (this.collected.size() == 8) {
            this.tick = 0;
            this.phase = 3;
            this.setVisible(false);
            Game.getGameState().getCurrentRoom().completedEffect(this);
            Game.getGameState().pauseTimer();
        } else {
            String message = this.collected.size() == 7 ? "Only one left!" : String.valueOf(8 - this.collected.size()) + " to go!";
            LabelEffect le = new LabelEffect(GameScreen.getInstance().getTitleFont(), message, 30);
            le.setLocation(FPMath.intValue((int)this.getPosition().getX()), FPMath.intValue((int)this.getPosition().getY()));
            le.setAcceleration(0.0f, 0.1f);
            le.setVisible(true);
            Effect.addEffect(le);
        }
        Game.getGameState().getCurrentRoom().collectionEffect(alien);
    }

    public void uncollect(boolean doSound) {
        if (this.collected.size() == 0) {
            return;
        }
        if (doSound && this.isAlive()) {
            SFX.uncollect();
        }
        Alien alien = (Alien)this.collected.remove(this.collected.size() - 1);
        alien.setCollected(false);
        int count = 0;
        int i = this.collectFX.size();
        while (--i >= 0 && count++ < 8) {
            Sprite s = (Sprite)this.collectFX.get(i);
            if (s != null) {
                s.deallocate();
            }
            this.collectFX.remove(i);
        }
    }

    public void damage(int amount) {
        if (this.phase != 1) {
            return;
        }
        SFX.playerDamaged();
        this.setFlash(true);
        this.penalty += amount;
        this.damaged = 64;
        if (amount > 0) {
            RainbowBurstEffect fx = new RainbowBurstEffect(1);
            fx.setLocation(FPMath.intValue((int)this.getPosition().getX()), FPMath.intValue((int)this.getPosition().getY()));
            Effect.addEffect(fx);
        }
    }

    public int getNumCollected() {
        return this.collected.size();
    }

    public int getPenalty() {
        return this.penalty;
    }
}

