/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.lwjgl.util.Color;

public class Particle
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final List particles = new LinkedList();
    private static final Color tempColor = new Color();
    private static final float[] tempHSB = new float[3];
    private Animation animation;
    private int x;
    private int y;
    private int initialVelocity;
    private int finalVelocity;
    private int initialSize;
    private int finalSize;
    private float initialHue;
    private float finalHue;
    private int wiggle;
    private int waggle;
    private int angle;
    private int duration;
    private int tick;
    private Sprite sprite;

    public Particle(Sprite sprite, Animation animation, ReadableVector3i position, int initialSize, int finalSize, int initialVelocity, int finalVelocity, float initialHue, float finalHue, int wiggle, int waggle, int duration) {
        this.sprite = sprite;
        if (sprite == null) {
            return;
        }
        particles.add(this);
        sprite.setAnimation(animation);
        this.initialSize = initialSize;
        this.finalSize = finalSize;
        this.initialVelocity = initialVelocity;
        this.finalVelocity = finalVelocity;
        this.initialHue = initialHue;
        this.finalHue = finalHue;
        this.wiggle = wiggle;
        this.waggle = waggle;
        this.angle = Util.random((int)0, (int)FPMath.ONE);
        this.duration = duration;
        this.x = position.getX();
        this.y = position.getY();
    }

    public static void tickAllParticles() {
        ListIterator i = particles.listIterator();
        while (i.hasNext()) {
            Particle p = (Particle)((Object)i.next());
            p.tick();
            if (p.isAlive()) continue;
            p.sprite.deallocate();
            i.remove();
        }
    }

    private void tick() {
        float fratio = (float)this.tick / (float)this.duration;
        int ratio = FPMath.fpValue((float)fratio);
        this.sprite.setScale(LinearInterpolator.instance.interpolate(this.initialSize, this.finalSize, ratio));
        int alpha = FPMath.ONE - ratio >> 8;
        tempColor.fromHSB(LinearInterpolator.instance.interpolate(this.initialHue, this.finalHue, fratio), 0.5f + fratio / 2.0f, 1.0f);
        this.sprite.setColors(tempColor.getRed(), tempColor.getGreen(), tempColor.getBlue(), alpha);
        int currentAngle = this.angle + FPMath.mul((int)this.waggle, (int)FPMath.cos((int)(this.tick * this.wiggle)));
        int velocity = LinearInterpolator.instance.interpolate(this.initialVelocity, this.finalVelocity, ratio);
        this.x += FPMath.mul((int)velocity, (int)FPMath.cos((int)currentAngle));
        this.y += FPMath.mul((int)velocity, (int)FPMath.sin((int)currentAngle));
        this.sprite.setLocation(FPMath.intValue((int)this.x), FPMath.intValue((int)this.y), 0);
        ++this.tick;
    }

    private boolean isAlive() {
        return this.tick < this.duration && this.sprite != null;
    }
}

