/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import genesis.Game;
import genesis.NagScreen;
import genesis.Options;
import genesis.Screen;
import genesis.TitleScreen;

public class OptionsScreen
extends Screen {
    public static final long serialVersionUID = 1L;
    private static OptionsScreen instance;
    private static final String PLAY = "play";
    private static final String CLOSE = "close";
    private static final String EXIT = "exit";
    private static final String BUY = "buy";
    private static final String MUSIC_ON = "music_on";
    private static final String SFX_ON = "sfx_on";
    private static final String STROBES_ON = "strobes_on";
    private static final String MUSIC_OFF = "music_off";
    private static final String SFX_OFF = "sfx_off";
    private static final String STROBES_OFF = "strobes_off";

    protected void doRegister() {
        instance = this;
    }

    public static void show() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        instance.open();
    }

    protected void onOpen() {
        this.getArea(MUSIC_ON).setVisible(Options.isMusicEnabled());
        this.getArea(MUSIC_OFF).setVisible(!Options.isMusicEnabled());
        this.getArea(SFX_ON).setVisible(Options.isSFXEnabled());
        this.getArea(SFX_OFF).setVisible(!Options.isSFXEnabled());
        this.getArea(STROBES_ON).setVisible(Options.getStrobesEnabled());
        this.getArea(STROBES_OFF).setVisible(!Options.getStrobesEnabled());
        this.getArea(BUY).setVisible(!Game.isRegistered());
    }

    protected void onClicked(String id) {
        if (id.equals(CLOSE)) {
            TitleScreen.show();
        } else if (id.equals(EXIT)) {
            if (Game.isRegistered()) {
                Game.exit();
            } else {
                NagScreen.show("Nag! Nag! Nag! Buy! Buy! Buy!", true);
            }
        } else if (id.equals(BUY)) {
            Game.buy();
        } else if (id.equals(PLAY)) {
            Game.beginNewGame();
        } else if (id.equals(MUSIC_ON)) {
            this.getArea(MUSIC_ON).setVisible(false);
            this.getArea(MUSIC_OFF).setVisible(true);
            Options.setMusicEnabled(false);
            TitleScreen.stopMusic();
        } else if (id.equals(MUSIC_OFF)) {
            this.getArea(MUSIC_OFF).setVisible(false);
            this.getArea(MUSIC_ON).setVisible(true);
            Options.setMusicEnabled(true);
            TitleScreen.playMusic();
        } else if (id.equals(SFX_ON)) {
            this.getArea(SFX_ON).setVisible(false);
            this.getArea(SFX_OFF).setVisible(true);
            Options.setSFXEnabled(false);
        } else if (id.equals(SFX_OFF)) {
            this.getArea(SFX_OFF).setVisible(false);
            this.getArea(SFX_ON).setVisible(true);
            Options.setSFXEnabled(true);
        } else if (id.equals(STROBES_ON)) {
            this.getArea(STROBES_ON).setVisible(false);
            this.getArea(STROBES_OFF).setVisible(true);
            Options.setStrobesEnabled(false);
        } else if (id.equals(STROBES_OFF)) {
            this.getArea(STROBES_OFF).setVisible(false);
            this.getArea(STROBES_ON).setVisible(true);
            Options.setStrobesEnabled(true);
        }
    }
}

