/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.resources.TextResource;
import genesis.Game;
import genesis.Screen;
import genesis.TitleScreen;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableDimension;
import org.lwjgl.util.Rectangle;

public class NagScreen
extends Screen {
    public static final long serialVersionUID = 1L;
    private static NagScreen instance;
    private static boolean exitOnClose;
    private static String reason;
    private static final int ANIMATION_DURATION = 30;
    private static final int TITLE_XPOS = 300;
    private static final int TITLE_YPOS = 560;
    private static final int PHASE_START = 0;
    private static final int PHASE_WAIT = 1;
    private static final int PHASE_END = 2;
    private static final int DELAY = 300;
    private static final String BUY = "buy";
    private static final String LATER = "later";
    private Rectangle bounds;
    private String nagText;
    private String font;
    private transient TextResource nagTextResource;
    private transient GLFont fontResource;
    private transient GLTextArea nagTextArea;
    private transient GLString nagTitle;
    private transient int tick;
    private transient int yPos;
    private transient int phase;

    protected void doCreate() throws Exception {
        super.doCreate();
        this.nagTextArea = new GLTextArea();
        this.nagTextArea.setLocation(this.bounds.getX(), this.bounds.getY());
        this.nagTextArea.setSize((ReadableDimension)this.bounds);
        this.nagTextArea.setFont(this.fontResource);
        String nag = this.nagTextResource.getText();
        String discountString = "only $19.95 / GBP 14.95 / EUR 19.95";
        StringBuffer sb2 = new StringBuffer(nag);
        this.replace(sb2, "${price}", discountString);
        this.replace(sb2, "${game}", "Super Dudester");
        this.nagTextArea.setText(sb2.toString());
        this.nagTitle = new GLString(64);
        this.nagTitle.setFont(this.fontResource);
        this.nagTitle.setLocation(300, 560);
    }

    private void replace(StringBuffer sb, String find, String rep) {
        int i = -1;
        while ((i = sb.indexOf(find)) != -1) {
            sb.replace(i, i + find.length(), rep);
        }
    }

    protected void doRegister() {
        instance = this;
    }

    public static void show(String reason, boolean exitOnClose) {
        NagScreen.reason = reason;
        NagScreen.exitOnClose = exitOnClose;
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        instance.open();
    }

    protected void onClicked(String id) {
        if (id.equals(LATER)) {
            if (exitOnClose) {
                Game.exit();
            } else {
                TitleScreen.show();
            }
        } else if (id.equals(BUY)) {
            Game.buy();
        }
    }

    protected void onOpen() {
        this.tick = 0;
        this.phase = 0;
        this.nagTitle.setText(reason);
        this.getArea(LATER).setVisible(false);
    }

    protected void onClose() {
        this.tick = 0;
    }

    protected void doTick() {
        switch (this.phase) {
            case 0: {
                this.nagTextArea.setY((int)LinearInterpolator.instance.interpolate(600.0f, (float)this.bounds.getY(), (float)this.tick / 30.0f));
                this.nagTitle.setLocation((int)LinearInterpolator.instance.interpolate(800.0f, 300.0f, (float)this.tick / 30.0f), 560);
                if (this.tick < 30) {
                    ++this.tick;
                    break;
                }
                this.tick = 0;
                ++this.phase;
                break;
            }
            case 2: {
                this.nagTextArea.setY((int)LinearInterpolator.instance.interpolate((float)this.bounds.getY(), (float)(-this.bounds.getHeight()), (float)this.tick / 30.0f));
                this.nagTitle.setLocation((int)LinearInterpolator.instance.interpolate(300.0f, 800.0f, (float)this.tick / 30.0f), 560);
                if (this.tick < 30) {
                    ++this.tick;
                    break;
                }
                this.tick = 0;
                ++this.phase;
                break;
            }
            default: {
                this.nagTextArea.setY(this.bounds.getY());
                this.nagTitle.setLocation(300, 560);
                ++this.tick;
                if (this.tick != 300) break;
                this.getArea(LATER).setVisible(true);
            }
        }
    }

    protected void postRender() {
        if (!this.isOpening()) {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)2.0f, (float)-2.0f, (float)0.0f);
            this.nagTextArea.render();
            this.nagTitle.render();
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.nagTextArea.render();
            GL11.glColor4f((float)((float)Math.random()), (float)((float)Math.random()), (float)((float)Math.random()), (float)1.0f);
            this.nagTitle.render();
        }
    }
}

