/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Parseable;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import genesis.Alien;
import genesis.Game;
import java.io.Serializable;
import java.util.StringTokenizer;

public class Movement
implements Parseable,
Serializable {
    static final long serialVersionUID = 1L;
    private static final Vector3i scratch = new Vector3i();
    private String target;
    private int maxSpeed;
    private int acceleration;
    private int speedBump;
    private int accBump;
    private boolean hv;
    private boolean reverse;
    private boolean fixed;
    private int triggerRange;
    private boolean nearest;
    private boolean includePlayer;

    public void fromString(String src) throws Exception {
        StringTokenizer st = new StringTokenizer(src, " ", false);
        this.target = st.nextToken();
        if (this.target.charAt(0) == '*') {
            this.target = this.target.substring(1);
            this.nearest = true;
        } else if (this.target.charAt(0) == '+') {
            this.target = this.target.substring(1);
            this.nearest = true;
            this.includePlayer = true;
        }
        if (st.hasMoreTokens()) {
            this.maxSpeed = FPMath.parse((String)st.nextToken());
            if (st.hasMoreTokens()) {
                this.acceleration = FPMath.parse((String)st.nextToken());
                if (st.hasMoreTokens()) {
                    this.speedBump = FPMath.parse((String)st.nextToken());
                    if (st.hasMoreTokens()) {
                        this.accBump = FPMath.parse((String)st.nextToken());
                        if (st.hasMoreTokens()) {
                            this.reverse = st.nextToken().equals("reverse");
                            if (st.hasMoreTokens()) {
                                this.triggerRange = FPMath.parse((String)st.nextToken());
                            }
                        }
                    }
                }
            }
        }
    }

    void move(Alien alien) {
        boolean offTop;
        if (this.target != null && (alien.getTarget() == null || !alien.getTarget().isAlive() || this.nearest)) {
            if (this.target.equals("player")) {
                alien.setTarget(Game.getGameState().getCurrentRoom().getPlayer());
            } else if ("none".equals(this.target)) {
                alien.setTarget(null);
            } else if (this.nearest) {
                if (this.includePlayer) {
                    alien.setTarget(Game.getGameState().getCurrentRoom().findNearestEntity(alien, this.target, 0));
                } else {
                    alien.setTarget(Game.getGameState().getCurrentRoom().findNearestAlien(alien, this.target));
                }
            } else {
                alien.setTarget(Game.getGameState().getCurrentRoom().findAlien(this.target));
            }
        } else if ("none".equals(this.target)) {
            alien.setTarget(null);
        }
        Vector3i velocity = alien.getVelocity();
        Vector3i position = alien.getPosition();
        int numCollected = Game.getGameState().getCurrentRoom().getPlayer().getNumCollected();
        int acc = this.acceleration + numCollected * this.accBump;
        if (alien.getTarget() != null) {
            scratch.set(alien.getTarget().getPosition().getX() - position.getX(), alien.getTarget().getPosition().getY() - position.getY(), 0);
            if (this.reverse) {
                scratch.negate();
            }
            if (this.triggerRange > 0 && scratch.length() > this.triggerRange) {
                scratch.set(0, 0, 0);
            }
            if (scratch.getX() != 0 || scratch.getY() != 0) {
                scratch.normalize();
                scratch.scale(acc);
            }
            Vector3i.add((ReadableVector3i)velocity, (ReadableVector3i)scratch, (WritableVector3i)velocity);
            this.checkVelocity(velocity);
        } else if (velocity.lengthSquared() != 0L || this.acceleration > 0) {
            velocity.translate(FPMath.mul((int)acc, (int)FPMath.cos((int)alien.getAngle())), FPMath.mul((int)acc, (int)FPMath.sin((int)alien.getAngle())), 0);
            this.checkVelocity(velocity);
        }
        boolean edgeBouncy = alien.getBehaviour().isEdgeBouncy();
        int newX = position.getX() + velocity.getX();
        int newY = position.getY() + velocity.getY();
        boolean offLeft = newX < 0 - alien.getRadius();
        boolean offRight = newX >= FPMath.fpValue((int)800) + alien.getRadius();
        boolean offBottom = newY < 0 - alien.getRadius();
        boolean bl = offTop = newY >= FPMath.fpValue((int)600) + alien.getRadius();
        if (alien.getBehaviour().isWrapped() && (offLeft || offRight || offBottom || offTop)) {
            if (offLeft) {
                newX += FPMath.fpValue((int)864);
            } else if (offRight) {
                newX -= FPMath.fpValue((int)864);
            }
            if (offBottom) {
                newY += FPMath.fpValue((int)664);
            } else if (offTop) {
                newY -= FPMath.fpValue((int)664);
            }
        } else if (!edgeBouncy && alien.getTarget() == null && (offLeft || offRight || offBottom || offTop)) {
            alien.remove();
        } else if (edgeBouncy) {
            int r = alien.getRadius();
            if (newX < r) {
                newX = r - velocity.getX();
                velocity.setX(-velocity.getX());
            } else if (newX >= FPMath.fpValue((int)800) - r) {
                velocity.setX(-velocity.getX());
                newX = FPMath.fpValue((int)800) + velocity.getX() - r;
            }
            if (newY < r) {
                newY = r - velocity.getY();
                velocity.setY(-velocity.getY());
            } else if (newY >= FPMath.fpValue((int)600) - r) {
                velocity.setY(-velocity.getY());
                newY = FPMath.fpValue((int)600) + velocity.getY() - r;
            }
        }
        double angle = Math.atan2(velocity.getY(), velocity.getX());
        alien.setAngle(FPMath.fpYaklyDegrees((double)angle));
        position.set(newX, newY, 0);
    }

    void checkVelocity(Vector3i velocity) {
        int max = this.maxSpeed + this.speedBump * Game.getGameState().getCurrentRoom().getPlayer().getNumCollected();
        if (velocity.lengthSquared() > (long)FPMath.mul((int)max, (int)max)) {
            velocity.normalize();
            velocity.scale(max);
        }
    }

    void retarget(Alien alien) {
        alien.setTarget(null);
    }
}

