/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.resources.Background;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

public class MessageBox {
    private final Rectangle bounds = new Rectangle();
    private final GLTextArea title = new GLTextArea();
    private final GLTextArea message = new GLTextArea();
    private final Background.Instance titleBackground;
    private final Background.Instance background;
    private static final int MARGIN = 8;

    public MessageBox() throws Exception {
        this.title.setFont((GLFont)Resources.get((String)"impact-plain-24.glfont"));
        this.title.setHorizontalAlignment(TextLayout.CENTERED);
        this.title.setVerticalAlignment(GLTextArea.TOP);
        this.titleBackground = ((Background)Resources.get((String)"message_title_background")).spawn();
        this.message.setFont((GLFont)Resources.get((String)"impact-plain-24.glfont"));
        this.message.setVerticalAlignment(GLTextArea.TOP);
        this.background = ((Background)Resources.get((String)"message_body_background")).spawn();
    }

    public void setSize(int width, int height) {
        this.bounds.setSize(width, height);
        this.bounds.setLocation((800 - width) / 2, (600 - height) / 2);
        int titleHeight = this.title.getFont().getHeight() + 16;
        this.title.setBounds(8, height - 16 - titleHeight, width - 16, titleHeight);
        this.message.setBounds(8, this.title.getY() - 8 - titleHeight, width - 16, height - this.title.getY() - 16);
        this.titleBackground.setSize(this.title.getWidth(), this.title.getHeight());
        this.background.setSize(width, height);
    }

    public void setTitle(String titleText) {
        this.title.setText(titleText);
    }

    public void setMessage(String messageText) {
        this.message.setText(messageText);
    }

    public void render() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.bounds.getX(), (float)this.bounds.getY(), (float)0.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        this.background.render();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.title.getX(), (float)(this.title.getY() + this.title.getFont().getDescent()), (float)0.0f);
        this.titleBackground.render();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)2.0f, (float)-2.0f, (float)0.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        this.title.render();
        this.message.render();
        GL11.glPopMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.title.render();
        GL11.glColor3ub((byte)-5, (byte)-9, (byte)99);
        this.message.render();
        GL11.glPopMatrix();
    }
}

