/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.vector.Vector3i;
import genesis.ColorPulse;
import genesis.Effect;
import genesis.Emitter;
import genesis.Game;
import genesis.HiscoresScreen;
import genesis.Particle;
import genesis.RainbowBurstEffect;
import genesis.RayEffect;
import genesis.RippleEffect;
import genesis.Room;
import genesis.SFX;
import genesis.Score;
import genesis.Screen;
import genesis.TimeFormat;
import genesis.TitleScreen;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.Rectangle;

public class MapScreen
extends Screen {
    public static final long serialVersionUID = 1L;
    private static final Rectangle tempRect = new Rectangle();
    private static MapScreen instance;
    private static final int MAP_X_OFFSET = 131;
    private static final int MAP_Y_OFFSET = 57;
    private static final int GRID_SIZE = 58;
    private static final int MAX_GAME_COMPLETED_HEIGHT = 600;
    private static final int GAME_COMPLETED_DURATION_1 = 300;
    private static final int PHASE_COMPLETING = 0;
    private static final int PHASE_WAITING = 1;
    private transient Animation incompleteImage;
    private transient Animation completeImage;
    private transient Animation availableImage;
    private transient Animation completedImage;
    private transient Animation happyFlowerImage;
    private transient Animation starsAnimation;
    private transient Animation[] icon;
    private transient SpriteImage gameCompleteImage;
    private transient SpriteImage startFlagImage;
    private transient SpriteImage endFlagImage;
    private transient SpriteImage extraTimeImage;
    private transient GLString titleString;
    private transient GLString bonusString;
    private transient GLString timeString;
    private transient GLFont font;
    private transient GLFont smallFont;
    private transient Sprite[] sprite;
    private transient ArrayList extraTimeSprite;
    private transient Sprite gameCompletedSprite;
    private transient Sprite startSprite;
    private transient Sprite endSprite;
    private transient boolean showTitle;
    private transient boolean showBonus;
    private transient boolean completedGame;
    private transient int tick;
    private transient int tock;
    private transient int phase;

    protected void doCreate() throws Exception {
        super.doCreate();
        this.incompleteImage = (Animation)Resources.get((String)"room_incomplete.animation");
        this.completeImage = (Animation)Resources.get((String)"room_complete.animation");
        this.availableImage = (Animation)Resources.get((String)"room_available.animation");
        this.happyFlowerImage = (Animation)Resources.get((String)"flower1.animation");
        this.gameCompleteImage = (SpriteImage)Resources.get((String)"spriteimage.gamecomplete");
        this.starsAnimation = (Animation)Resources.get((String)"particle_star10.animation");
        this.icon = new Animation[]{this.incompleteImage, this.incompleteImage, this.availableImage, this.completeImage};
        this.font = (GLFont)Resources.get((String)"impact-plain-32.glfont");
        this.smallFont = (GLFont)Resources.get((String)"impact-plain-24.glfont");
        this.startFlagImage = (SpriteImage)Resources.get((String)"spriteimage.flag_start");
        this.endFlagImage = (SpriteImage)Resources.get((String)"spriteimage.flag_end");
        this.extraTimeImage = (SpriteImage)Resources.get((String)"spriteimage.clock");
    }

    protected void doRegister() {
        instance = this;
    }

    public static void show() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        instance.open();
    }

    protected void onOpen() {
        Effect.removeAllEffects();
        this.completedGame = Game.getGameState().isComplete();
        this.tick = 0;
        this.sprite = new Sprite[81];
        this.extraTimeSprite = new ArrayList(8);
        int y = 0;
        while (y < 9) {
            int x = 0;
            while (x < 9) {
                Sprite sprite = this.allocateSprite(this);
                this.sprite[x + y * 9] = sprite;
                Sprite s = sprite;
                if (this.completedGame) {
                    s.setAnimation(this.happyFlowerImage);
                    s.setLocation(x * 58 + 131 + 32, y * 58 + 57 + 32, 0);
                } else {
                    s.setAnimation(this.icon[Game.getGameState().getRoomStatus(x, y)]);
                    s.setLocation(x * 58 + 131, y * 58 + 57, 0);
                }
                if (Game.getGameState().isExtraTimeRoom(x, y)) {
                    Sprite es = this.allocateSprite(this);
                    es.setLayer(1);
                    es.setImage(this.extraTimeImage);
                    es.setLocation(x * 58 + 131 + 19, y * 58 + 57 + 24, 0);
                    this.extraTimeSprite.add(es);
                }
                ++x;
            }
            ++y;
        }
        this.startSprite = this.allocateSprite(this);
        this.startSprite.setImage(this.startFlagImage);
        this.startSprite.setLocation(163, 89, 0);
        this.startSprite.setLayer(2);
        this.endSprite = this.allocateSprite(this);
        this.endSprite.setImage(this.endFlagImage);
        this.endSprite.setLocation(627, 553, 0);
        this.endSprite.setLayer(2);
        this.timeString = new GLString(12);
        this.timeString.setFont(this.font);
        this.timeString.setLocation(685, 167);
        StringBuffer sb = new StringBuffer(12);
        TimeFormat.format(Game.getGameState().getTime(), sb);
        this.timeString.setText(sb.toString());
        this.titleString = new GLString(80);
        this.titleString.setFont(this.smallFont);
        this.bonusString = new GLString(80);
        this.bonusString.setFont(this.smallFont);
        try {
            if (this.completedGame) {
                Game.playMusic((ALBuffer)Resources.get((String)"completeGame.buffer"), 60);
            } else {
                Game.playMusic((ALBuffer)Resources.get((String)"wind.buffer"), 120);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (this.completedGame) {
            this.gameCompletedSprite = this.allocateSprite(this);
            this.gameCompletedSprite.setLayer(10);
            this.gameCompletedSprite.setImage(this.gameCompleteImage);
            this.gameCompletedSprite.setLocation(400, 300, 600);
            this.tick = 0;
            this.phase = 0;
        }
    }

    protected void doCleanup() {
        int y = 0;
        while (y < 9) {
            int x = 0;
            while (x < 9) {
                this.sprite[x + y * 9].deallocate();
                ++x;
            }
            ++y;
        }
        Iterator i = this.extraTimeSprite.iterator();
        while (i.hasNext()) {
            Sprite s = (Sprite)i.next();
            s.deallocate();
        }
        this.sprite = null;
        this.extraTimeSprite = null;
        this.startSprite.deallocate();
        this.endSprite.deallocate();
        this.startSprite = null;
        this.endSprite = null;
        this.titleString = null;
        this.timeString = null;
        this.bonusString = null;
        if (this.completedGame) {
            this.gameCompletedSprite.deallocate();
            this.gameCompletedSprite = null;
        }
    }

    private void doCompletedGameTick() {
        ++this.tick;
        ++this.tock;
        if (Util.random((int)0, (int)20) == 0 || this.tock > 10) {
            Effect re;
            this.tock = 0;
            int r = Util.random((int)0, (int)6);
            if (r <= 3) {
                Emitter em = new Emitter(this.starsAnimation);
                em.emit(new Vector3i(FPMath.fpValue((int)Util.random((int)0, (int)800)), FPMath.fpValue((int)Util.random((int)0, (int)600)), 0), this);
                SFX.alienExplode();
            }
            if (r == 4) {
                re = new RayEffect();
                ((RayEffect)re).setLocation(Util.random((int)0, (int)800), Util.random((int)0, (int)600));
                Effect.addEffect(re);
            }
            if (r == 5) {
                re = new RainbowBurstEffect(8);
                ((RainbowBurstEffect)re).setLocation(Util.random((int)0, (int)800), Util.random((int)0, (int)600));
                Effect.addEffect(re);
            }
            if (r == 6) {
                re = new RippleEffect();
                ((RippleEffect)re).setLocation(Util.random((int)0, (int)800), Util.random((int)0, (int)600));
                Effect.addEffect(re);
                SFX.extraLife();
            }
        }
        Effect.tickAllEffects();
        Particle.tickAllParticles();
        switch (this.phase) {
            case 0: {
                this.gameCompletedSprite.setZ((int)LinearInterpolator.instance.interpolate(600.0f, 0.0f, (float)this.tick / 300.0f));
                if (this.tick < 300) break;
                this.tick = 0;
                this.phase = 1;
            }
            case 1: {
                if (!Mouse.isButtonDown((int)0)) break;
                Score newScore = new Score(null, Game.getInstallation(), Game.getGameState().getTime());
                int index = Game.getHiscores().checkHiscore(newScore);
                if (index != -1) {
                    HiscoresScreen.enterHiscore(index);
                } else {
                    TitleScreen.show();
                }
                return;
            }
        }
    }

    protected void doTick() {
        if (Keyboard.isKeyDown((int)1) && !this.completedGame) {
            Game.endGame();
            return;
        }
        if (this.completedGame) {
            this.doCompletedGameTick();
        }
        int y = 0;
        while (y < 9) {
            int x = 0;
            while (x < 9) {
                Room room = Game.getGameState().getRoom(x, y);
                ColorPulse cp = room.getBackgroundColor();
                cp.tick();
                ReadableColor c = cp.getColor();
                switch (Game.getGameState().getRoomStatus(x, y)) {
                    case 0: {
                        this.sprite[x + y * 9].setColors(0, 0, 0, 0);
                        break;
                    }
                    case 2: {
                        this.sprite[x + y * 9].setColors(c.getRed(), c.getGreen(), c.getBlue(), 255);
                        break;
                    }
                    case 3: {
                        this.sprite[x + y * 9].setColors(128, 128, 128, 255);
                        break;
                    }
                    case 1: {
                        this.sprite[x + y * 9].setColors(255, 255, 255, 255);
                    }
                }
                ++x;
            }
            ++y;
        }
        if (!this.completedGame) {
            int x = this.getMouseX();
            int y2 = this.getMouseY();
            if (x < 131 || y2 < 57 || x >= 653 || y2 >= 579) {
                this.showTitle = false;
                return;
            }
            int xx = (x - 131) / 58;
            int yy = (y2 - 57) / 58;
            Room room = Game.getGameState().getRoom(xx, yy);
            if (Game.getGameState().getRoomStatus(xx, yy) == 2 || Game.getGameState().getRoomStatus(xx, yy) == 1) {
                this.titleString.setText(room.getTitle());
                this.titleString.getBounds(tempRect);
                this.titleString.setLocation(Math.min(800 - tempRect.getWidth(), x + 24), y2 - 48);
                this.showTitle = true;
            } else if (xx == 8 && yy == 8) {
                this.titleString.setText("Get here to escape!");
                this.titleString.getBounds(tempRect);
                this.titleString.setLocation(Math.min(800 - tempRect.getWidth(), x + 24), y2 - 48);
                this.showTitle = true;
            } else if (Game.getGameState().getRoomStatus(xx, yy) == 0) {
                this.titleString.setText(String.valueOf(room.getTitle()) + " - Only available in the full version!");
                this.titleString.getBounds(tempRect);
                this.titleString.setLocation(Math.min(800 - tempRect.getWidth(), x + 24), y2 - 48);
                this.showTitle = true;
            } else {
                this.showTitle = false;
            }
            if (Game.getGameState().isExtraTimeRoom(xx, yy)) {
                this.bonusString.setText("1 MINUTE TIME BONUS!");
                this.bonusString.getBounds(tempRect);
                this.bonusString.setLocation(Math.min(800 - tempRect.getWidth(), x + 24), y2 - (this.showTitle ? 68 : 48));
                this.showBonus = true;
            } else {
                this.showBonus = false;
            }
            if (Mouse.isButtonDown((int)0)) {
                switch (Game.getGameState().getRoomStatus(xx, yy)) {
                    case 2: {
                        Game.getGameState().setCurrentRoom(xx, yy);
                        break;
                    }
                    default: {
                        Keyboard.isKeyDown((int)29);
                    }
                }
            }
        }
    }

    protected void postRender() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glColor3f((float)1.0f, (float)0.9f, (float)0.1f);
        this.timeString.render();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)2.0f, (float)-2.0f, (float)0.0f);
        if (this.showTitle) {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            this.titleString.render();
        }
        if (this.showBonus) {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            this.bonusString.render();
        }
        GL11.glPopMatrix();
        if (this.showTitle) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.titleString.render();
        }
        if (this.showBonus) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bonusString.render();
        }
        if (this.completedGame) {
            Effect.renderAllEffects();
        }
    }

    protected void preRender() {
        GL11.glClearColor((float)0.5f, (float)0.25f, (float)0.75f, (float)1.0f);
    }

    protected void onClicked(String id) {
        if (id.equals("exit")) {
            Game.endGame();
        }
    }
}

