/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLString;
import genesis.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

public class LabelEffect
extends Effect {
    private static final long serialVersionUID = 1L;
    private int duration;
    private int tick;
    private int fadeTick;
    private GLString string;
    private float x;
    private float y;
    private float vx;
    private float vy;
    private float ax;
    private float ay;
    private boolean finished;
    private int width;
    private boolean visible;

    public LabelEffect(GLFont font, String text, int duration) {
        this.string = new GLString(text.length());
        this.string.setFont(font);
        this.string.setText(text);
        Rectangle size = new Rectangle();
        this.string.getBounds(size);
        this.width = size.getWidth();
        this.duration = duration;
    }

    protected boolean isActive() {
        return this.fadeTick < 60;
    }

    protected void tick() {
        this.vx += this.ax;
        this.vy += this.ay;
        this.x += this.vx;
        this.y += this.vy;
        this.string.setLocation((int)this.x - this.width / 2, (int)this.y);
        if (this.finished) {
            ++this.fadeTick;
        } else {
            ++this.tick;
            if (this.tick >= this.duration && this.duration != 0 || this.x < -100.0f || this.y < -20.0f || this.x > 900.0f || this.y > 620.0f) {
                this.finished = true;
            }
        }
    }

    public void finish() {
        this.finished = true;
    }

    protected void render() {
        if (!this.visible) {
            return;
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)this.fadeTick / 60.0f));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)2.0f, (float)-2.0f, (float)0.0f);
        this.string.render();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)this.fadeTick / 60.0f));
        this.string.render();
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setVelocity(float vx, float vy) {
        this.vx = vx;
        this.vy = vy;
    }

    public void setAcceleration(float ax, float ay) {
        this.ax = ax;
        this.ay = ay;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

