/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLString;
import genesis.Game;
import genesis.NagScreen;
import genesis.SFX;
import genesis.Score;
import genesis.Screen;
import genesis.TimeFormat;
import genesis.TitleScreen;
import java.util.Iterator;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.Rectangle;

public class HiscoresScreen
extends Screen {
    public static final long serialVersionUID = 1L;
    private static HiscoresScreen instance;
    private static final String PLAY = "play";
    private static final String CLOSE = "close";
    private static final String EXIT = "exit";
    private static final String BUY = "buy";
    private static final int NAME_X = 68;
    private static final int NAME_Y = 465;
    private static final int SCORE_X = 580;
    private static final int GAP = 6;
    private static final Color tempColor;
    private transient GLString[] name;
    private transient GLString[] score;
    private transient float[] pulse;
    private transient int numScores;
    private transient int editing = 0;
    private transient boolean isEditing;
    private transient int cursorPos = 0;
    private transient int flashTick = 0;
    private transient boolean cursorVisible = false;
    private transient GLString congratulationsString;
    private transient StringBuffer buffer;
    private transient int backTimer;

    static {
        tempColor = new Color();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        GLFont bigFont = (GLFont)Resources.get((String)"impact-plain-32.glfont");
        GLFont smallFont = (GLFont)Resources.get((String)"impact-plain-24.glfont");
        this.name = new GLString[10];
        this.score = new GLString[10];
        this.pulse = new float[10];
        int i = 0;
        while (i < 10) {
            this.name[i] = new GLString(24);
            GLFont font = i == 0 ? bigFont : smallFont;
            this.name[i].setFont(font);
            this.name[i].setLocation(68, 465 - i * (6 + font.getHeight()));
            this.score[i] = new GLString(20);
            this.score[i].setFont(font);
            this.score[i].setLocation(580, 465 - i * (6 + font.getHeight()));
            this.pulse[i] = (float)i / 10.0f;
            ++i;
        }
    }

    protected void doRegister() {
        instance = this;
    }

    public static void show() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        instance.open();
    }

    protected void onClicked(String id) {
        if (id.equals(CLOSE)) {
            this.acceptEdits();
            TitleScreen.show();
        } else if (id.equals(EXIT)) {
            this.acceptEdits();
            if (Game.isRegistered()) {
                Game.exit();
            } else {
                NagScreen.show("Nag! Nag! Nag! Buy! Buy! Buy!", true);
            }
        } else if (id.equals(BUY)) {
            Game.buy();
        } else if (id.equals(PLAY)) {
            this.acceptEdits();
            Game.beginNewGame();
        }
    }

    protected void doTick() {
        int i = 0;
        while (i < this.numScores) {
            int n = i;
            this.pulse[n] = this.pulse[n] + 0.002f;
            if (this.pulse[i] > 1.0f) {
                this.pulse[i] = 0.0f;
            }
            ++i;
        }
        if (this.isEditing) {
            this.flashCursor();
            this.processKeyboard();
        }
        if (this.backTimer > 0) {
            --this.backTimer;
            if (this.backTimer == 0) {
                TitleScreen.show();
            }
        }
    }

    private void flashCursor() {
        ++this.flashTick;
        if (this.flashTick > 6) {
            this.flashTick = 0;
            this.cursorVisible = !this.cursorVisible;
        }
    }

    private void processKeyboard() {
        int oldCursorPos = this.cursorPos;
        block9: while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            int key = Keyboard.getEventKey();
            switch (key) {
                case 207: 
                case 208: {
                    this.cursorPos = this.name[this.editing].length();
                    break;
                }
                case 199: 
                case 200: {
                    this.cursorPos = 0;
                    break;
                }
                case 203: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.cursorPos = 0;
                        break;
                    }
                    if (this.cursorPos <= 0) continue block9;
                    --this.cursorPos;
                    break;
                }
                case 205: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.cursorPos = this.name[this.editing].length();
                        break;
                    }
                    if (this.cursorPos >= this.name[this.editing].length()) continue block9;
                    ++this.cursorPos;
                    break;
                }
                case 211: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.buffer.setLength(0);
                        this.cursorPos = 0;
                        this.name[this.editing].setText("");
                        break;
                    }
                    if (this.cursorPos >= this.name[this.editing].length()) continue block9;
                    this.buffer.deleteCharAt(this.cursorPos);
                    this.name[this.editing].setText(this.buffer.toString());
                    break;
                }
                case 14: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.buffer.setLength(0);
                        this.cursorPos = 0;
                        this.name[this.editing].setText("");
                        break;
                    }
                    if (this.cursorPos <= 0) continue block9;
                    this.buffer.deleteCharAt(--this.cursorPos);
                    this.name[this.editing].setText(this.buffer.toString());
                    break;
                }
                case 28: {
                    this.acceptEdits();
                    break block9;
                }
                default: {
                    char c;
                    if (this.buffer.length() == 24 || this.getCursorXPos() >= 548 || Character.isISOControl(c = Keyboard.getEventCharacter())) continue block9;
                    SFX.shoot();
                    this.buffer.insert(this.cursorPos++, c);
                    this.name[this.editing].setText(this.buffer.toString());
                }
            }
        }
        if (oldCursorPos != this.cursorPos) {
            this.cursorVisible = true;
            this.flashTick = 0;
        }
    }

    private void acceptEdits() {
        if (!this.isEditing) {
            return;
        }
        String newName = this.buffer.toString().trim();
        if ("".equals(newName)) {
            newName = "Elvis";
        }
        SFX.collect();
        Game.getHiscores().updateName(this.editing, newName);
        Game.writeHiscores();
        if (Game.isRegistered()) {
            Game.getHiscores().submit();
        }
        this.editing = -1;
        this.isEditing = false;
        this.backTimer = 180;
    }

    protected void postRender() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)2.0f, (float)-2.0f, (float)0.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        int i = 0;
        while (i < this.numScores) {
            this.name[i].render();
            this.score[i].render();
            ++i;
        }
        GL11.glPopMatrix();
        i = 0;
        while (i < this.numScores) {
            tempColor.fromHSB(this.pulse[i], 0.8f, 1.0f);
            if (this.isEditing && this.editing == i) {
                GL11.glDisable((int)3553);
                GL11.glBlendFunc((int)770, (int)1);
                GL11.glColor4ub((byte)tempColor.getRedByte(), (byte)tempColor.getGreenByte(), (byte)tempColor.getBlueByte(), (byte)64);
                Point loc = this.name[i].getLocation(null);
                GL11.glRecti((int)(loc.getX() - 1), (int)(loc.getY() - this.name[this.editing].getFont().getDescent() - 1), (int)733, (int)(loc.getY() + this.name[this.editing].getFont().getHeight() - this.name[this.editing].getFont().getDescent() + 1));
                GL11.glEnable((int)3553);
                ColorUtil.setGLColor((ReadableColor)tempColor);
                this.name[i].render();
                this.score[i].render();
                if (this.cursorVisible) {
                    GL11.glDisable((int)3553);
                    int cursorX = this.getCursorXPos();
                    GL11.glRecti((int)cursorX, (int)(loc.getY() - this.name[this.editing].getFont().getDescent()), (int)(cursorX + 4), (int)(loc.getY() + this.name[this.editing].getFont().getHeight() - this.name[this.editing].getFont().getDescent()));
                    GL11.glEnable((int)3553);
                }
                GL11.glBlendFunc((int)770, (int)771);
            } else {
                ColorUtil.setGLColor((ReadableColor)tempColor);
                this.name[i].render();
                this.score[i].render();
            }
            ++i;
        }
    }

    private int getCursorXPos() {
        Rectangle tempBounds = this.name[this.editing].getGlyphBounds(this.cursorPos - 1, null);
        return tempBounds.getX() + tempBounds.getWidth();
    }

    protected void onOpen() {
        this.getArea(BUY).setVisible(!Game.isRegistered());
        int count = 0;
        StringBuffer scratch = new StringBuffer(16);
        Iterator i = Game.getHiscores().getScores();
        while (i.hasNext()) {
            Score s = (Score)i.next();
            this.name[count].setText(s.getName());
            TimeFormat.format(s.getTime(), scratch);
            this.score[count].setText(scratch.toString());
            ++count;
        }
        this.numScores = count;
        this.backTimer = 0;
    }

    protected void onClose() {
        this.isEditing = false;
        Game.setPauseEnabled(true);
    }

    public static void enterHiscore(int newScoreIndex) {
        while (Keyboard.next()) {
        }
        Game.setPauseEnabled(false);
        HiscoresScreen.show();
        HiscoresScreen.instance.editing = newScoreIndex;
        HiscoresScreen.instance.isEditing = true;
        HiscoresScreen.instance.cursorPos = 0;
        HiscoresScreen.instance.buffer = new StringBuffer(24);
    }
}

