/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.util.Util;
import genesis.Game;
import genesis.GameScreen;
import genesis.MapScreen;
import genesis.NagScreen;
import genesis.Room;
import genesis.SFX;
import java.util.ArrayList;
import java.util.Arrays;
import org.lwjgl.util.Timer;

public class GameState {
    public static final int ROOM_UNAVAILABLE = 0;
    public static final int ROOM_INCOMPLETE = 1;
    public static final int ROOM_AVAILABLE = 2;
    public static final int ROOM_COMPLETE = 3;
    private final int[] roomState = new int[81];
    private final Room[] room = new Room[81];
    private final boolean[] extraTime = new boolean[81];
    private Room currentRoom;
    private int currentRoomX;
    private int currentRoomY;
    private final Timer timer = new Timer();
    private float time;
    private boolean paused;
    private boolean complete;

    public GameState() {
        int i;
        if (Game.isRegistered() || !Game.getConfiguration().isCrippled()) {
            Arrays.fill(this.roomState, 1);
            i = 0;
            while (i < 9) {
                this.randomize(i);
                ++i;
            }
        } else {
            Arrays.fill(this.roomState, 0);
            i = 0;
            while (i < 8) {
                this.roomState[i * 9 + i] = 1;
                this.roomState[i * 9 + i + 9] = 1;
                this.roomState[i * 9 + i + 1] = 1;
                ++i;
            }
            i = 0;
            while (i < 9) {
                this.fixed(i);
                ++i;
            }
            this.roomState[80] = 1;
        }
        this.roomState[0] = 2;
        i = 0;
        while (i < 9) {
            int x = Util.random((int)0, (int)8);
            int y = Util.random((int)0, (int)8);
            if (!(x < 3 && y < 3 || x == 8 && y == 8 || this.extraTime[y * 9 + x])) {
                this.extraTime[y * 9 + x] = true;
            }
            ++i;
        }
    }

    private void randomize(int dist) {
        Room r;
        ArrayList<Room> available = new ArrayList<Room>(Arrays.asList(Room.getRooms(dist)));
        int x = 0;
        while (x < dist + 1) {
            this.room[x + dist * 9] = r = (Room)((Object)available.remove(Util.random((int)0, (int)(available.size() - 1))));
            ++x;
        }
        int y = 0;
        while (y < dist) {
            this.room[dist + y * 9] = r = (Room)((Object)available.remove(Util.random((int)0, (int)(available.size() - 1))));
            ++y;
        }
    }

    private void fixed(int dist) {
        Room r;
        ArrayList<Room> available = new ArrayList<Room>(Arrays.asList(Room.getRooms(dist)));
        int x = 0;
        while (x < dist + 1) {
            this.room[x + dist * 9] = r = (Room)((Object)available.remove(available.size() - 1));
            ++x;
        }
        int y = 0;
        while (y < dist) {
            this.room[dist + y * 9] = r = (Room)((Object)available.remove(available.size() - 1));
            ++y;
        }
        if (dist != 0) {
            Room d;
            Room a = this.room[dist * 9 + dist - 1];
            Room b = this.room[dist * 9 + dist];
            Room c = this.room[dist * 9 + dist - 9];
            if (Math.random() < 0.5) {
                d = a;
                a = c;
                c = d;
            }
            if (Math.random() < 0.5) {
                d = a;
                a = b;
                b = d;
            }
            this.room[dist * 9 + dist - 1] = a;
            this.room[dist * 9 + dist] = b;
            this.room[dist * 9 + dist - 9] = c;
        }
    }

    public int getRoomStatus(int x, int y) {
        return this.roomState[x + y * 9];
    }

    public boolean isExtraTimeRoom(int x, int y) {
        return this.extraTime[x + y * 9];
    }

    public Room getRoom(int x, int y) {
        return this.room[x + y * 9];
    }

    public void failRoom() {
        MapScreen.show();
    }

    private void setRoomAvailable(int x, int y) {
        if (x < 0 || x > 8 || y < 0 || y > 8) {
            return;
        }
        int oldStatus = this.roomState[x + y * 9];
        if (oldStatus != 1) {
            return;
        }
        this.roomState[x + y * 9] = 2;
    }

    public void completeRoom() {
        int oldStatus = this.roomState[this.currentRoomX + this.currentRoomY * 9];
        this.roomState[this.currentRoomX + this.currentRoomY * 9] = 3;
        if (this.currentRoomX == 8 && this.currentRoomY == 8) {
            this.complete = true;
        }
        this.setRoomAvailable(this.currentRoomX, this.currentRoomY - 1);
        this.setRoomAvailable(this.currentRoomX - 1, this.currentRoomY);
        this.setRoomAvailable(this.currentRoomX + 1, this.currentRoomY);
        this.setRoomAvailable(this.currentRoomX, this.currentRoomY + 1);
        MapScreen.show();
    }

    public Room getCurrentRoom() {
        return this.currentRoom;
    }

    public void setCurrentRoom(int x, int y) {
        this.currentRoomX = x;
        this.currentRoomY = y;
        this.currentRoom = this.room[x + y * 9];
        SFX.enterRoom();
        if (!Game.isRegistered() && x == 8 && y == 8) {
            NagScreen.show("Only Paying Dudesters Can Escape!", false);
        } else {
            GameScreen.show();
        }
    }

    public void resumeTimer() {
        this.paused = false;
    }

    public void pauseTimer() {
        this.paused = true;
    }

    public float getTime() {
        if (!this.paused) {
            this.time += this.timer.getTime();
        }
        this.timer.reset();
        return this.time;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void initCurrentRoom() throws Exception {
        this.currentRoom.init(this.extraTime[this.currentRoomX + this.currentRoomY * 9]);
        this.extraTime[this.currentRoomX + this.currentRoomY * 9] = false;
    }

    public void extraTime() {
        this.time = Math.max(0.0f, this.time - 60.0f);
        this.currentRoom.extraTimeEffect(this.currentRoom.getPlayer());
    }

    public void penalize(int amount) {
        this.time = Math.max(0.0f, this.time + (float)amount);
    }
}

