/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.CosineInterpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import genesis.Appearance;
import genesis.Area;
import genesis.Effect;
import genesis.Game;
import genesis.Options;
import genesis.Player;
import genesis.Room;
import genesis.SFX;
import genesis.Screen;
import genesis.TimeFormat;
import genesis.TitleScreen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.Rectangle;

public class GameScreen
extends Screen {
    public static final long serialVersionUID = 1L;
    private static GameScreen instance;
    private static final int STROBE_DURATION = 60;
    private static final Color color;
    private static int tix;
    public static final int SAFETY_MARGIN = 128;
    private static final int COLLECT_Y = 562;
    private static final int COLLECT_X = 48;
    private static final int TITLE_X = 312;
    private static final int TITLE_Y = 558;
    private static final int INSTRUCTIONS_X = 403;
    private static final int INSTRUCTIONS_Y = 430;
    private static final int HUD_OFFSET = 128;
    private static final int HUD_THRESHOLD = 472;
    private static final int TIME_X = 108;
    private static final int TIME_WIDTH = 150;
    private static final int TIME_Y = 558;
    private static int shakeDuration;
    private static int shakeMagnitude;
    private static int shakeTick;
    private static float shakeX;
    private static float shakeY;
    private static final StringBuffer scratch;
    private static final Rectangle tempSize;
    private String instructionsSpriteImage;
    private transient boolean gameOver;
    private transient int gameOverDelay;
    private transient Sprite gameOverSprite;
    private transient SpriteImage gameOverResource;
    private transient Sprite collectSprite;
    private transient Sprite instructionsSprite;
    private transient SpriteImage instructionsSpriteImageResource;
    private transient SpriteImage[] rotation;
    private transient int strobeTick;
    private transient GLString title;
    private transient GLString completeMessage;
    private transient GLString finalScoreMessage;
    private transient GLFont titleFont;
    private transient Area hud1;
    private transient Area hud2;
    private transient int hudOffset;
    private transient int hudAlpha;
    private transient GLString time;
    private static final int GAMEOVER_BOUNCE_DURATION = 60;
    private transient int gameOverBounceTick;
    private static final double GAMEOVER_BOUNCE_RATE = Math.PI * 6;
    private transient float bonusHue;

    static {
        color = new Color();
        scratch = new StringBuffer(10);
        tempSize = new Rectangle();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.gameOverResource = (SpriteImage)Resources.get((String)"spriteimage.gameover");
        this.rotation = new SpriteImage[8];
        int i = 0;
        while (i < 8) {
            this.rotation[i] = (SpriteImage)Resources.get((String)("spriteimage.player000" + i));
            ++i;
        }
        this.titleFont = (GLFont)Resources.get((String)"impact-plain-24.glfont");
        this.title = new GLString(64);
        this.title.setFont(this.titleFont);
        this.time = new GLString(10);
        this.time.setFont(this.titleFont);
        this.hud1 = this.getArea("hud1");
        this.hud2 = this.getArea("hud2");
    }

    protected void doDestroy() {
        super.doDestroy();
        this.gameOverResource = null;
    }

    public static void show() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        Room.setSpriteAllocator(instance);
        instance.open();
    }

    protected void doRegister() {
        instance = this;
    }

    public static void gameOver() {
        instance.doGameOver();
    }

    private void doGameOver() {
        this.gameOver = true;
        this.gameOverDelay = 30;
        this.gameOverBounceTick = 0;
        this.gameOverSprite = this.allocateSprite(this);
        this.gameOverSprite.setImage(this.gameOverResource);
        this.gameOverSprite.setLocation(400, 300, 0);
        this.gameOverSprite.setLayer(2);
        this.finalScoreMessage = new GLString(64);
        this.finalScoreMessage.setFont(this.titleFont);
        TimeFormat.format(Game.getGameState().getTime(), scratch);
        this.finalScoreMessage.setText("Total time " + scratch);
        Rectangle size = new Rectangle();
        this.finalScoreMessage.getBounds(size);
        this.finalScoreMessage.setLocation((800 - size.getWidth()) / 2, 230);
        SFX.gameOver();
        Game.playMusic(null, 180);
    }

    protected void onOpen() {
        this.gameOver = false;
        try {
            Game.getGameState().initCurrentRoom();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.close();
            return;
        }
        this.collectSprite = this.allocateSprite(this);
        this.collectSprite.setLayer(1);
        this.collectSprite.setLocation(48, 562, 0);
        Appearance app = Game.getGameState().getCurrentRoom().getCollectAppearance();
        if (app.getImage() != null) {
            this.collectSprite.setImage(app.getImage());
        } else {
            this.collectSprite.setAnimation(app.getAnimation());
        }
        if (Game.getGameState().getCurrentRoom().isStartRoom()) {
            this.instructionsSprite = this.allocateSprite(this);
            this.instructionsSprite.setImage(this.instructionsSpriteImageResource);
            this.instructionsSprite.setLocation(403, 430, 0);
            this.instructionsSprite.setLayer(10);
        }
        this.title.setText(Game.getGameState().getCurrentRoom().getTitle());
        this.hudOffset = 0;
        this.hudAlpha = 255;
    }

    protected void doCleanup() {
        Game.getGameState().getCurrentRoom().cleanup();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (this.gameOverSprite != null) {
            this.gameOverSprite.deallocate();
            this.gameOverSprite = null;
        }
        if (this.collectSprite != null) {
            this.collectSprite.deallocate();
            this.collectSprite = null;
        }
        if (this.instructionsSprite != null) {
            this.instructionsSprite.deallocate();
            this.instructionsSprite = null;
        }
        if (this.completeMessage != null) {
            this.completeMessage = null;
        }
        if (this.finalScoreMessage != null) {
            this.finalScoreMessage = null;
        }
        GameScreen.stopShake();
        Effect.removeAllEffects();
    }

    protected void doTick() {
        if (!this.gameOver && Keyboard.isKeyDown((int)1)) {
            Game.gameOver();
        }
        if (this.gameOver) {
            if (this.gameOverDelay > 0) {
                --this.gameOverDelay;
            } else if (Mouse.isButtonDown((int)0) || Keyboard.isKeyDown((int)1)) {
                TitleScreen.show();
                return;
            }
            if (this.gameOverBounceTick < 60) {
                ++this.gameOverBounceTick;
                this.gameOverSprite.setZ((int)LinearInterpolator.instance.interpolate((float)Math.cos(Math.PI * 6 * (double)this.gameOverBounceTick / 60.0) * 100.0f, 0.0f, (float)this.gameOverBounceTick / 60.0f));
            }
        } else if (!Game.isPaused()) {
            ++tix;
        }
        if (shakeDuration != 0 && ++shakeTick > shakeDuration) {
            shakeDuration = 0;
        }
        Game.getGameState().getCurrentRoom().tick();
        Player player = Game.getGameState().getCurrentRoom().getPlayer();
        if (FPMath.intValue((int)player.getPosition().getY()) > 472) {
            if (this.hudOffset < 128) {
                this.hudOffset = Math.min(128, this.hudOffset + 8);
            }
            if (this.hudAlpha > 0) {
                this.hudAlpha = Math.max(0, this.hudAlpha - 32);
            }
        } else {
            if (this.hudOffset > 0) {
                this.hudOffset = Math.max(0, this.hudOffset - 8);
            }
            if (this.hudAlpha < 255) {
                this.hudAlpha = Math.min(255, this.hudAlpha + 32);
            }
        }
        this.collectSprite.setOffset(0, this.hudOffset, 0);
        this.collectSprite.setAlpha(this.hudAlpha);
        this.hud1.getSprite().setOffset(0, this.hudOffset, 0);
        this.hud2.getSprite().setOffset(0, this.hudOffset, 0);
        this.hud1.getSprite().setAlpha(this.hudAlpha);
        this.hud2.getSprite().setAlpha(this.hudAlpha);
        float totalTime = Game.getGameState().getTime();
        TimeFormat.format(totalTime, scratch);
        this.time.setText(scratch.toString());
        this.time.getBounds(tempSize);
        this.time.setLocation(150 - tempSize.getWidth(), 0);
        Effect.tickAllEffects();
    }

    protected void preRender() {
        if (shakeDuration > 0) {
            float y;
            float x;
            if ((shakeTick & 1) == 0) {
                float magnitude = CosineInterpolator.instance.interpolate((float)shakeMagnitude, 0.0f, (float)shakeTick / (float)shakeDuration);
                shakeX = (float)((double)magnitude * (Math.random() - 0.5));
                shakeY = (float)((double)magnitude * (Math.random() - 0.5));
                x = shakeX;
                y = shakeY;
            } else {
                x = shakeX;
                y = shakeY;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        }
    }

    protected void renderBackground() {
        Game.getGameState().getCurrentRoom().render();
    }

    protected void postRender() {
        if (shakeDuration > 0) {
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.7f * (float)this.hudAlpha / 255.0f));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)314.0f, (float)(556 + this.hudOffset), (float)0.0f);
        this.title.render();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)110.0f, (float)(556 + this.hudOffset), (float)0.0f);
        this.time.render();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.hudAlpha / 255.0f));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)312.0f, (float)(558 + this.hudOffset), (float)0.0f);
        this.title.render();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)108.0f, (float)(558 + this.hudOffset), (float)0.0f);
        this.time.render();
        GL11.glPopMatrix();
        if (this.completeMessage != null) {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)2.0f, (float)-2.0f, (float)0.0f);
            this.completeMessage.render();
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.completeMessage.render();
        }
        if (this.finalScoreMessage != null) {
            this.bonusHue = (float)((double)this.bonusHue + 0.01);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)2.0f, (float)-2.0f, (float)0.0f);
            this.finalScoreMessage.render();
            GL11.glPopMatrix();
            Color c = new Color();
            c.fromHSB(this.bonusHue, 1.0f, 1.0f);
            ColorUtil.setGLColor((ReadableColor)c);
            this.finalScoreMessage.render();
        }
        GL11.glDisable((int)3553);
        Effect.renderAllEffects();
        if (this.strobeTick > 0) {
            --this.strobeTick;
            if ((this.strobeTick & 2) == 0) {
                color.setColor(Game.getGameState().getCurrentRoom().getStrobeColor().getColor());
                color.setAlpha((int)LinearInterpolator.instance.interpolate(255.0f, 0.0f, (float)this.strobeTick / 60.0f));
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)1);
                GL11.glColor4ub((byte)color.getRedByte(), (byte)color.getGreenByte(), (byte)color.getBlueByte(), (byte)color.getAlphaByte());
                GL11.glBegin((int)7);
                GL11.glVertex2i((int)0, (int)0);
                GL11.glVertex2i((int)800, (int)0);
                GL11.glVertex2i((int)800, (int)600);
                GL11.glVertex2i((int)0, (int)600);
                GL11.glEnd();
                GL11.glDisable((int)3042);
            }
        }
    }

    public static SpriteImage getPlayerSpriteImage(int angle) {
        int spriteAngle = GameScreen.instance.rotation.length * angle / FPMath.ONE;
        spriteAngle += 2;
        return GameScreen.instance.rotation[spriteAngle %= 8];
    }

    public static GameScreen getInstance() {
        return instance;
    }

    public static void strobe(int time) {
        if (Options.getStrobesEnabled()) {
            GameScreen.instance.strobeTick = time;
        }
    }

    public static int getTix() {
        int oldTix = tix;
        tix = 0;
        return oldTix;
    }

    public static void shake(int duration, int magnitude) {
        if (shakeDuration > 0) {
            shakeDuration += duration;
            if (magnitude > shakeMagnitude) {
                shakeMagnitude = magnitude;
            }
        } else {
            shakeTick = 0;
            shakeDuration = duration;
            shakeMagnitude = magnitude;
        }
    }

    public static void stopShake() {
        shakeDuration = 0;
        shakeMagnitude = 0;
        shakeTick = 0;
    }

    public static void showCompleted() {
        instance.doShowCompleted();
    }

    private void doShowCompleted() {
        this.completeMessage = new GLString(32);
        this.completeMessage.setFont(this.titleFont);
        this.completeMessage.setText("--- Room Complete ---");
        Rectangle size = new Rectangle();
        this.completeMessage.getBounds(size);
        this.completeMessage.setLocation((800 - size.getWidth()) / 2, 268);
        int penalty = Game.getGameState().getCurrentRoom().getPlayer().getPenalty();
        if (penalty != 0) {
            this.finalScoreMessage = new GLString(40);
            this.finalScoreMessage.setFont(this.titleFont);
            if (penalty > 0) {
                this.finalScoreMessage.setText("Bad Trip Penalty " + penalty + " seconds");
            } else if (penalty < 0) {
                this.finalScoreMessage.setText("Bonus " + penalty + " seconds!");
            }
            this.finalScoreMessage.getBounds(size);
            this.finalScoreMessage.setLocation((800 - size.getWidth()) / 2, 236);
            Game.getGameState().penalize(penalty);
        }
    }

    public GLFont getTitleFont() {
        return this.titleFont;
    }
}

