/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.MultiBuffer;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.opengl.GL;
import com.shavenpuppy.jglib.opengl.nvidia.NvidiaInitializer;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sound.OggVorbis;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sound.SoundPlayer;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.BrowserControl;
import com.shavenpuppy.jglib.util.CheckOnline;
import genesis.Configuration;
import genesis.GameScreen;
import genesis.GameState;
import genesis.Hiscores;
import genesis.MapScreen;
import genesis.NagScreen;
import genesis.Options;
import genesis.Particle;
import genesis.RegisterScreen;
import genesis.SFX;
import genesis.Screen;
import genesis.Splash;
import genesis.Support;
import genesis.TitleScreen;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.rmi.Naming;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.prefs.Preferences;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;
import net.puppygames.gamecommerce.shared.GameInfo;
import net.puppygames.gamecommerce.shared.GameInfoServerRemote;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Display;
import org.lwjgl.util.Timer;

public class Game {
    private static final String RESOURCES_FILE = "/resources.dat";
    public static final String EMAIL_ADDRESS = "support@puppygames.net";
    public static final String WEBSITE = "www.puppygames.net";
    public static final String GAME_TITLE = "Super Dudester";
    public static final String GAME_VERSION = "1.0";
    public static final String GAME_PRICE_USD = "$19.95";
    public static final String GAME_PRICE_GBP = "GBP 14.95";
    public static final String GAME_PRICE_EUR = "EUR 19.95";
    private static final String DEFAULT_AFFILIATE = "puppygames";
    private static final int COMPILE_DAY = 10;
    private static final int COMPILE_MONTH = 11;
    private static final int COMPILE_YEAR = 2004;
    public static final boolean DEBUG = false;
    private static final boolean REGISTERED = false;
    private static final Preferences PREFS;
    public static final int FRAMERATE = 60;
    public static final int WIDTH = 800;
    public static final int HEIGHT = 600;
    private static final int MAX_LOGFILE_LENGTH = 65536;
    private static boolean f6WasDown;
    private static boolean pWasDown;
    private static boolean windowed;
    private static boolean registered;
    private static long installation;
    private static boolean dirPrefixExists;
    private static String dirPrefix;
    private static boolean finished;
    private static final String LOG_FILE;
    private static final String ERRLOG_FILE;
    private static final String GAMEINFO_FILE;
    private static final String HISCORES_FILE;
    private static String affiliate;
    private static Configuration configuration;
    private static RegistrationDetails registrationDetails;
    private static SoundPlayer soundPlayer;
    private static SoundEffect music;
    private static boolean paused;
    private static GameState game;
    private static GameInfo gameInfo;
    private static SpriteImage mousePointer;
    private static int panic;
    private static boolean lafInstalled;
    private static Hiscores hiscores;
    private static boolean pauseEnabled;
    private static boolean shutdown;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        File settingsDir;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("genesis.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PREFS = Preferences.userNodeForPackage(clazz);
        windowed = Boolean.getBoolean("windowed");
        registered = false;
        installation = PREFS.getLong("installation", 0L);
        if (installation == 0L) {
            installation = (long)(Math.random() * 9.223372036854776E18);
            PREFS.putLong("installation", installation);
        }
        dirPrefixExists = !(settingsDir = new File(System.getProperty("workdir", String.valueOf(Game.getSettingsDir()) + File.separator + GAME_TITLE + ' ' + GAME_VERSION))).exists() ? settingsDir.mkdir() : true;
        dirPrefix = dirPrefixExists ? String.valueOf(System.getProperty("workdir", String.valueOf(Game.getSettingsDir()) + File.separator + GAME_TITLE + ' ' + GAME_VERSION)) + File.separator : Game.getSettingsDir();
        LOG_FILE = String.valueOf(dirPrefix) + "out.log";
        ERRLOG_FILE = String.valueOf(dirPrefix) + "err.log";
        GAMEINFO_FILE = String.valueOf(dirPrefix) + "log.dat";
        HISCORES_FILE = String.valueOf(dirPrefix) + "hiscores.dat";
        pauseEnabled = true;
    }

    private Game() {
    }

    private static String getSettingsDir() {
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            return String.valueOf(System.getProperty("user.home", "")) + "/Library";
        }
        return System.getProperty("user.home", "");
    }

    private static void checkDate() {
        Calendar compileDate = Calendar.getInstance();
        compileDate.set(5, 10);
        compileDate.set(2, 11);
        compileDate.set(1, 2004);
        Calendar todaysDate = Calendar.getInstance();
        todaysDate.add(2, -2);
        int lastCheck = PREFS.getInt("lastdatecheck", 0);
        if (lastCheck <= 0 && todaysDate.after(compileDate)) {
            PREFS.putInt("lastdatecheck", 10);
            Sys.alert((String)"Old Version Warning", (String)"The version of Super Dudester you are about to play is over two months old!\nPlease check www.puppygames.net for an updated version with new features and bug fixes.");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        BrowserControl.openURL((String)"http://www.puppygames.net");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        } else {
            PREFS.putInt("lastdatecheck", lastCheck - 1);
        }
    }

    private static void checkRegistration() throws Exception {
        Game.setRegistrationDetails(RegistrationDetails.checkRegistration((String)GAME_TITLE));
    }

    public static net.puppygames.gamecommerce.shared.Game getGameDetails() {
        return new net.puppygames.gamecommerce.shared.Game(){

            public void setRegistrationDetails(RegistrationDetails newDetails) {
                Game.setRegistrationDetails(newDetails);
            }

            public String getTitle() {
                return Game.GAME_TITLE;
            }

            public String getVersion() {
                return Game.GAME_VERSION;
            }

            public String getAffiliate() {
                return affiliate;
            }

            public ConfigurationDetails getConfiguration() {
                return Game.getConfiguration();
            }

            public long getInstallation() {
                return Game.getInstallation();
            }

            public String getWebsite() {
                return Game.WEBSITE;
            }

            public String getPriceUSD() {
                return Game.GAME_PRICE_USD;
            }

            public String getPriceGBP() {
                return Game.GAME_PRICE_GBP;
            }

            public String getPriceEUR() {
                return Game.GAME_PRICE_EUR;
            }
        };
    }

    public static void setRegistrationDetails(RegistrationDetails registrationDetails) {
        Game.registrationDetails = registrationDetails;
        if (registrationDetails != null) {
            registered = true;
            registrationDetails.toPreferences();
            TitleScreen.updateRegistrationDetails();
        }
    }

    private static void createConfiguration() throws Exception {
        configuration = new Configuration();
        configuration.init();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(configuration);
        oos.flush();
        byte[] cfg = baos.toByteArray();
        PREFS.putByteArray("configuration", cfg);
        oos.close();
    }

    private static void init() throws Exception {
        block41: {
            ObjectInputStream ois;
            byte[] cfg;
            affiliate = PREFS.get("affiliate", "");
            if (affiliate.equals("")) {
                try {
                    try {
                        FileReader fr = new FileReader("affiliate.id");
                        BufferedReader br = new BufferedReader(fr);
                        affiliate = br.readLine();
                        fr.close();
                    }
                    catch (Exception fr) {}
                }
                finally {
                    if (affiliate == null || "".equals(affiliate.trim())) {
                        affiliate = System.getProperty("affiliate", DEFAULT_AFFILIATE);
                    }
                }
                PREFS.put("affiliate", affiliate);
            }
            if ((cfg = PREFS.getByteArray("configuration", null)) == null) {
                Game.createConfiguration();
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(cfg);
                ois = new ObjectInputStream(bais);
                try {
                    try {
                        configuration = (Configuration)ois.readObject();
                    }
                    catch (Exception e) {
                        Game.createConfiguration();
                    }
                }
                finally {
                    ois.close();
                }
            }
            Options.fromPreferences(PREFS);
            try {
                FileInputStream fis = new FileInputStream(HISCORES_FILE);
                ois = new ObjectInputStream(fis);
                hiscores = (Hiscores)ois.readObject();
            }
            catch (Exception e) {
                System.err.println("Failed to load hiscores table.");
                hiscores = new Hiscores();
                hiscores.defaultValues();
            }
            boolean wasBadExit = PREFS.getBoolean("badexit", false);
            gameInfo = new GameInfo(GAME_TITLE, GAME_VERSION, affiliate, installation, wasBadExit, org.lwjgl.opengl.Display.getAdapter(), org.lwjgl.opengl.Display.getVersion(), configuration.encode());
            System.setOut(Game.redirectOutput(System.out, LOG_FILE));
            System.setErr(Game.redirectOutput(System.err, ERRLOG_FILE));
            System.out.println("Starting Super Dudester 1.0");
            if (wasBadExit) {
                Sys.alert((String)GAME_TITLE, (String)"Super Dudester did not shut down correctly last time you tried to play.\nIf you are experiencing problems or bugs please contact support@puppygames.net\nand tell us! Remember our guarantee: If you find a bug in our code that\nprevents you from enjoying Super Dudester fully that we are unable to fix,\nwe will refund your money - no questions asked!");
                Support.doSupport("crash");
            }
            PREFS.putBoolean("badexit", true);
            Game.checkDate();
            try {
                AL.create();
                soundPlayer = new SoundPlayer(12);
                soundPlayer.create();
            }
            catch (Exception e) {
                e.printStackTrace();
                Sys.alert((String)GAME_TITLE, (String)"You need an OpenAL compatible sound card to to hear the sound effects and music in Super Dudester.\nYou may have a suitable card but not have appropriate drivers.\nPlease contact support@puppygames.net for assistance or visit our website if you need help\n finding drivers for your sound card.");
                Support.doSupport("openal");
            }
            org.lwjgl.opengl.Display.setTitle((String)GAME_TITLE);
            if (windowed) {
                org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)new DisplayMode(800, 600));
                org.lwjgl.opengl.Display.create();
            } else {
                try {
                    DisplayMode[] dm;
                    if (System.getProperty("os.name").startsWith("Mac OS")) {
                        if (System.getProperty("os.version").startsWith("10.2")) {
                            windowed = true;
                            org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)new DisplayMode(800, 600));
                        } else {
                            try {
                                dm = Display.getAvailableDisplayModes((int)640, (int)480, (int)-1, (int)-1, (int)-1, (int)-1, (int)60, (int)85);
                                Display.setDisplayMode((DisplayMode[])dm, (String[])new String[]{"width=800", "height=600", "freq=60", "bpp=" + org.lwjgl.opengl.Display.getDisplayMode().getBitsPerPixel()});
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                                windowed = true;
                                org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)new DisplayMode(800, 600));
                            }
                        }
                        org.lwjgl.opengl.Display.setFullscreen((!windowed ? 1 : 0) != 0);
                        org.lwjgl.opengl.Display.create();
                        break block41;
                    }
                    org.lwjgl.opengl.Display.setFullscreen((boolean)true);
                    org.lwjgl.opengl.Display.create();
                    try {
                        dm = Display.getAvailableDisplayModes((int)640, (int)480, (int)-1, (int)-1, (int)-1, (int)-1, (int)60, (int)85);
                        Display.setDisplayMode((DisplayMode[])dm, (String[])new String[]{"width=800", "height=600", "freq=60", "bpp=" + org.lwjgl.opengl.Display.getDisplayMode().getBitsPerPixel()});
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        windowed = true;
                        org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)new DisplayMode(800, 600));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Game.cleanup();
                    Sys.alert((String)GAME_TITLE, (String)"You need an OpenGL compatible graphics card to run Super Dudester.\nYou may have a suitable graphics card but not have OpenGL drivers.\nPlease contact support@puppygames.net for assistance or visit our website\nif you need help finding OpenGL drivers for your graphics card.");
                    Support.doSupport("opengl");
                    Game.exit();
                }
            }
        }
        NvidiaInitializer.initialize((int)0x400000, (int)0);
        GL11.glViewport((int)0, (int)0, (int)org.lwjgl.opengl.Display.getDisplayMode().getWidth(), (int)org.lwjgl.opengl.Display.getDisplayMode().getHeight());
        Mouse.setGrabbed((boolean)true);
        if (org.lwjgl.opengl.Display.getDisplayMode().getFrequency() == 60 && !GL11.glGetString((int)7936).equals("Matrox Graphics Inc.")) {
            org.lwjgl.opengl.Display.setVSyncEnabled((boolean)true);
        }
        Splash splash = new Splash();
        splash.create();
        OggVorbis.setCacheDirectory((String)dirPrefix);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("genesis.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Resources.load((InputStream)clazz.getResourceAsStream(RESOURCES_FILE));
        Feature.autoCreate();
        Resources.add((Resource)new SFX());
        Resources.put((Resource)new SpriteImage("spotlight.32.texture", "glowing.style", 16, 16));
        Resources.put((Resource)new SpriteImage("pointlight.32.texture", "glowing.style", 16, 16));
        SFX.createSFX();
        mousePointer = (SpriteImage)Resources.get((String)"spriteimage.mousepointer");
        splash.destroy();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glFrustum((double)-12.5, (double)12.5, (double)-9.375, (double)9.375, (double)8.0, (double)65536.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        try {
            Game.checkRegistration();
        }
        catch (Exception e) {
            e.printStackTrace();
            Sys.alert((String)GAME_TITLE, (String)"Your registration details could not be validated or are corrupted.\nPlease contact support@puppygames.net for assistance.");
            Support.doSupport("badregistration");
        }
        String glvendor = GL11.glGetString((int)7936);
        String glrenderer = GL11.glGetString((int)7937);
        String glversion = GL11.glGetString((int)7938);
        String gldriver = null;
        int i = glversion.indexOf(32);
        if (i != -1) {
            gldriver = glversion.substring(i + 1);
            glversion = glversion.substring(0, i);
        }
        gameInfo.update(glvendor, glrenderer, glversion, gldriver, registrationDetails);
        if (Game.isRegistered()) {
            TitleScreen.show();
        } else {
            RegisterScreen.show();
        }
    }

    private static void cleanup() {
        Options.toPreferences(PREFS);
        AL.destroy();
        org.lwjgl.opengl.Display.destroy();
    }

    public static void main(String[] args) {
        try {
            try {
                Game.init();
                Game.run();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                Sys.alert((String)GAME_TITLE, (String)"An error occured and the game will exit.\nPlease contact support@puppygames.net for assistance.");
            }
        }
        finally {
            Game.exit();
        }
    }

    private static void run() {
        while (!finished) {
            org.lwjgl.opengl.Display.update();
            org.lwjgl.opengl.Display.sync((int)60);
            if (org.lwjgl.opengl.Display.isCloseRequested()) {
                finished = true;
                continue;
            }
            if (org.lwjgl.opengl.Display.isActive()) {
                Game.tick();
                Game.render();
                continue;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Game.tick();
            if (!org.lwjgl.opengl.Display.isVisible() && !org.lwjgl.opengl.Display.isDirty()) continue;
            Game.render();
        }
    }

    private static void tick() {
        if (Keyboard.isKeyDown((int)1)) {
            if (++panic == 60) {
                Game.exit();
            }
        } else {
            panic = 0;
        }
        if (Keyboard.isKeyDown((int)64)) {
            if (!f6WasDown) {
                f6WasDown = true;
                Game.screenshot();
            }
        } else {
            f6WasDown = false;
        }
        if (Keyboard.isKeyDown((int)25) && pauseEnabled) {
            if (!pWasDown) {
                pWasDown = true;
                boolean bl = paused = !paused;
                if (game != null) {
                    if (paused) {
                        game.pauseTimer();
                    } else {
                        game.resumeTimer();
                    }
                }
            }
        } else {
            pWasDown = false;
        }
        if (!paused) {
            Timer.tick();
            Screen.tickAllScreens();
            Particle.tickAllParticles();
            if (AL.isCreated()) {
                soundPlayer.play();
            }
        }
    }

    private static void render() {
        GL11.glViewport((int)0, (int)0, (int)org.lwjgl.opengl.Display.getDisplayMode().getWidth(), (int)org.lwjgl.opengl.Display.getDisplayMode().getHeight());
        GL11.glClear((int)16384);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-400.0f, (float)-300.0f, (float)-256.0f);
        Screen.renderAllScreens();
        if (Screen.isMouseVisible()) {
            GL.glPushMatrix();
            try {
                int mouseX = (int)(800.0f * (float)Mouse.getX() / (float)org.lwjgl.opengl.Display.getDisplayMode().getWidth());
                int mouseY = (int)(600.0f * (float)Mouse.getY() / (float)org.lwjgl.opengl.Display.getDisplayMode().getHeight());
                GL.glTranslatef((float)(mouseX - mousePointer.getHotspotX()), (float)(mouseY - mousePointer.getHotspotY()), (float)0.0f);
                GL.glEnable((int)3553);
                GL.glEnable((int)3042);
                GL.glBlendFunc((int)770, (int)771);
                GL.glTexEnvi((int)8960, (int)8704, (int)7681);
                mousePointer.getTexture().render();
                GL.glBegin((int)7);
                GL.glTexCoord2f((float)mousePointer.getTx0(), (float)mousePointer.getTy1());
                GL.glVertex2i((int)0, (int)0);
                GL.glTexCoord2f((float)mousePointer.getTx1(), (float)mousePointer.getTy1());
                GL.glVertex2i((int)mousePointer.getWidth(), (int)0);
                GL.glTexCoord2f((float)mousePointer.getTx1(), (float)mousePointer.getTy0());
                GL.glVertex2i((int)mousePointer.getWidth(), (int)mousePointer.getHeight());
                GL.glTexCoord2f((float)mousePointer.getTx0(), (float)mousePointer.getTy0());
                GL.glVertex2i((int)0, (int)mousePointer.getHeight());
                GL.glEnd();
                GL.glDisable((int)3553);
                GL.glDisable((int)3042);
            }
            finally {
                GL.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
    }

    private static void writeTix() {
        int tix = PREFS.getInt("tix", 0);
        int newTix = GameScreen.getTix() / 60;
        gameInfo.addTime(newTix);
        PREFS.putInt("tix", tix += newTix);
    }

    private static void writeLog() {
        if (gameInfo == null) {
            System.out.println("No game info log");
        }
        File log = new File(GAMEINFO_FILE);
        List<Object> logList = null;
        if (log.exists()) {
            ObjectInputStream ois = null;
            BufferedInputStream bis = null;
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(log);
                    bis = new BufferedInputStream(fis);
                    ois = new ObjectInputStream(bis);
                    logList = (List)ois.readObject();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    logList = new ArrayList(1);
                }
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {}
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
                ois = null;
                bis = null;
                fis = null;
            }
        } else {
            logList = new ArrayList<GameInfo>(1);
        }
        if (gameInfo != null) {
            Game.writeTix();
            logList.add(gameInfo);
        }
        boolean submitted = false;
        if (CheckOnline.isOnline()) {
            try {
                System.out.print("Submitting log... ");
                GameInfoServerRemote server = (GameInfoServerRemote)Naming.lookup("//puppygames.net/puppygames_gameinfo_server");
                server.submit(logList);
                submitted = true;
                log.delete();
                System.out.println(" Log submitted.");
            }
            catch (Exception e) {
                System.out.println(" Failed to write log: " + e);
                e.printStackTrace(System.err);
            }
        }
        if (!submitted) {
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                try {
                    fos = new FileOutputStream(log);
                    bos = new BufferedOutputStream(fos);
                    oos = new ObjectOutputStream(bos);
                    oos.writeObject(logList);
                    oos.flush();
                    ((BufferedOutputStream)bos).flush();
                    fos.flush();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (Exception exception) {}
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static synchronized void exit() {
        if (!shutdown) {
            shutdown = true;
            PREFS.putBoolean("badexit", false);
            if (soundPlayer != null && soundPlayer.isCreated()) {
                soundPlayer.destroy();
            }
            Game.cleanup();
            Game.writeLog();
            System.exit(0);
        }
    }

    public static SoundEffect allocateSound(ALBuffer buffer) {
        SoundEffect effect;
        if (!AL.isCreated() || !Options.isSFXEnabled()) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("genesis.SFX");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((effect = soundPlayer.allocate(buffer, (Object)clazz)) != null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("genesis.SFX");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            effect.setAttenuated(false, (Object)clazz2);
        }
        return effect;
    }

    public static void playMusic(ALBuffer buf, int fade) {
        boolean xfade;
        boolean bl = xfade = music != null;
        if (xfade) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("genesis.SFX");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            music.setFade(fade, 0.0f, true, (Object)clazz);
        }
        if ((music = buf == null || !Options.isMusicEnabled() ? null : Game.allocateSound(buf)) != null) {
            if (xfade) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("genesis.SFX");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setGain(0.0f, (Object)clazz);
                float f = buf.getGain();
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("genesis.SFX");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setFade(fade, f, false, (Object)clazz2);
            } else {
                float f = buf.getGain();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("genesis.SFX");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setGain(f, (Object)clazz);
            }
        }
    }

    public static SoundEffect getMusic() {
        return music;
    }

    public static long getInstallation() {
        return installation;
    }

    public static boolean isRegistered() {
        return registered;
    }

    public static boolean isPaused() {
        return paused;
    }

    public static void beginNewGame() {
        if (!Game.isRegistered()) {
            int played = PREFS.getInt("played1.0", 0);
            played ^= 0xAF6AD755;
            played = played >> 16 & 0xFFFF | played << 16;
            if ((played ^= 0xCCCCCABE) == 463037908) {
                played = 0;
            }
            int tix = PREFS.getInt("tix", 0);
            if ((played < 0 || played > configuration.getMaxGames() && configuration.getMaxGames() > 0) && tix > configuration.getMaxTime() && configuration.getMaxTime() > 0) {
                NagScreen.show("Your demo has expired!", true);
                return;
            }
            ++played;
            played ^= 0xCCCCCABE;
            played = played >> 16 & 0xFFFF | played << 16;
            PREFS.putInt("played1.0", played ^= 0xAF6AD755);
            gameInfo.onNewGame();
        }
        game = new GameState();
        SFX.newGame();
        MapScreen.show();
    }

    public static void gameOver() {
        Game.writeTix();
        GameScreen.gameOver();
    }

    public static void endGame() {
        Game.writeTix();
        TitleScreen.show();
    }

    public static GameState getGameState() {
        return game;
    }

    private static void screenshot() {
        MultiBuffer data = new MultiBuffer(org.lwjgl.opengl.Display.getDisplayMode().getWidth() * org.lwjgl.opengl.Display.getDisplayMode().getHeight() * 3);
        GL11.glReadBuffer((int)1028);
        GL11.glReadPixels((int)0, (int)0, (int)org.lwjgl.opengl.Display.getDisplayMode().getWidth(), (int)org.lwjgl.opengl.Display.getDisplayMode().getHeight(), (int)6407, (int)5121, (ByteBuffer)data.bytes);
        GL11.glReadBuffer((int)1029);
        int i = 0;
        while (i < 99) {
            File f = new File(String.valueOf(i < 10 ? "screenshot0" : "screenshot") + i + ".raw");
            if (!f.exists()) {
                try {
                    FileOutputStream fos = new FileOutputStream(f);
                    byte[] buf = new byte[org.lwjgl.opengl.Display.getDisplayMode().getWidth() * org.lwjgl.opengl.Display.getDisplayMode().getHeight() * 3];
                    data.bytes.get(buf);
                    fos.write(buf);
                    fos.flush();
                    fos.close();
                    System.out.println("Wrote screenshot:" + f.getName());
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                break;
            }
            ++i;
        }
    }

    private static PrintStream redirectOutput(final PrintStream output, String fileName) throws FileNotFoundException {
        if (fileName == null || fileName.equals("")) {
            return output;
        }
        boolean append = true;
        File outFile = new File(fileName);
        if (outFile.exists() && outFile.length() > 65536L) {
            outFile.renameTo(new File(String.valueOf(fileName) + ".old"));
            append = false;
        }
        return new PrintStream((OutputStream)new FileOutputStream(fileName, append)){

            public void println(String s) {
                this.print(new Date());
                this.print('\t');
                super.println(s);
                output.println(s);
            }
        };
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static Hiscores getHiscores() {
        return hiscores;
    }

    public static void writeHiscores() {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            try {
                fos = new FileOutputStream(HISCORES_FILE);
                bos = new BufferedOutputStream(fos);
                oos = new ObjectOutputStream(bos);
                oos.writeObject(hiscores);
                oos.flush();
                ((BufferedOutputStream)bos).flush();
                fos.flush();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static RegistrationDetails getRegistrationDetails() {
        return registrationDetails;
    }

    public static void setPauseEnabled(boolean pauseEnabled) {
        Game.pauseEnabled = pauseEnabled;
        if (paused && !pauseEnabled) {
            paused = false;
        }
    }

    public static String getAffiliate() {
        return affiliate;
    }

    public static void buy() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    String page = "http://www.puppygames.net/purchase/buy.php?game=" + URLEncoder.encode(Game.GAME_TITLE, "utf-8") + "&configuration=" + URLEncoder.encode(configuration.encode(), "utf-8") + "&installation=" + URLEncoder.encode(String.valueOf(installation), "utf-8");
                    BrowserControl.openURL((String)page);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    Sys.alert((String)"How To Buy Super Dudester", (String)"Please open your web browser on the page http://www.puppygames.net/purchase");
                }
            }
        });
        Game.exit();
    }
}

