/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import genesis.Alien;
import genesis.Player;
import genesis.SpriteAllocator;
import org.lwjgl.util.ReadableColor;

public abstract class Entity {
    private static final Vector3i tempVector;
    public static final int MAX_ENTITIES = 32;
    private boolean alive = true;
    private final Vector3i position = new Vector3i();
    private final Vector3i velocity = new Vector3i();
    private int angle;
    private Sprite sprite;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("genesis.Entity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        tempVector = new Vector3i();
    }

    protected Entity() {
    }

    public void setAngle(int angle) {
        this.angle = angle & 0xFFFF;
    }

    public void adjustAngle(int delta) {
        this.setAngle(this.angle + delta);
    }

    public final int getAngle() {
        return this.angle;
    }

    protected final void setScale(int scale) {
        this.sprite.setScale(scale);
    }

    protected final int getScale() {
        if (this.sprite == null) {
            return 0;
        }
        return this.sprite.getScale();
    }

    protected final void setAlpha(int alpha) {
        if (this.sprite != null) {
            this.sprite.setAlpha(alpha);
        }
    }

    protected void setVisible(boolean visible) {
        this.sprite.setVisible(visible);
    }

    protected boolean isVisible() {
        return this.sprite.isVisible();
    }

    protected final void setColor(ReadableColor color) {
        if (this.sprite != null) {
            this.sprite.setColors(color.getRed(), color.getGreen(), color.getBlue(), 255);
        }
    }

    public final void setFlash(boolean flash) {
        if (this.sprite != null) {
            this.sprite.setFlash(flash);
        }
    }

    public final Vector3i getPosition() {
        return this.position;
    }

    public final Vector3i getVelocity() {
        return this.velocity;
    }

    public final void spawn(SpriteAllocator spriteAllocator) {
        if (!$assertionsDisabled && this.sprite != null) {
            throw new AssertionError();
        }
        this.sprite = spriteAllocator.allocateSprite(this);
        if (this.sprite == null) {
            this.remove();
            return;
        }
        this.doSpawn();
    }

    protected void doSpawn() {
    }

    public final void remove() {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        if (this.sprite != null) {
            this.sprite.deallocate();
            this.sprite = null;
        }
        this.doRemove();
    }

    protected void doRemove() {
    }

    public final boolean isTouching(Entity dest) {
        if (this.getRadius() == 0 || dest.getRadius() == 0) {
            return false;
        }
        Vector3i.sub((ReadableVector3i)dest.getPosition(), (ReadableVector3i)this.position, (WritableVector3i)tempVector);
        return tempVector.length() < this.getRadius() + dest.getRadius();
    }

    public final boolean isAlive() {
        return this.alive;
    }

    public abstract boolean canCollide();

    public abstract int getRadius();

    public abstract void onCollision(Entity var1);

    public abstract void onCollisionWithAlien(Alien var1);

    public abstract void onCollisionWithPlayer(Player var1);

    public final void tick() {
        if (this.sprite != null) {
            this.doTick();
            if (this.isAlive() && this.sprite != null) {
                this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            }
        } else {
            this.remove();
        }
    }

    protected abstract void doTick();

    public final void setAnimation(Animation animation) {
        if (this.sprite != null) {
            this.sprite.setAnimation(animation);
        }
    }

    public final void setImage(SpriteImage image) {
        if (this.sprite != null) {
            this.sprite.setAnimation(null);
            this.sprite.setImage(image);
        }
    }

    public final void setRotation(int rotation) {
        if (this.sprite != null) {
            this.sprite.setAngle(rotation);
        }
    }

    public final void setLayer(int layer) {
        if (this.sprite != null) {
            this.sprite.setLayer(layer);
        }
    }

    public final int getRotation() {
        if (this.sprite != null) {
            return this.sprite.getAngle();
        }
        return 0;
    }

    public final SpriteImage getImage() {
        return this.sprite.getImage();
    }

    public abstract void damage(int var1);
}

