/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import genesis.DieRoll;
import genesis.Particle;
import genesis.Range;
import genesis.Room;
import genesis.SpriteAllocator;

public class Emitter {
    private final Range waggle;
    private final Range wiggle;
    private final Range initialVelocity;
    private final Range finalVelocity;
    private final DieRoll duration;
    private final DieRoll numParticles;
    private final Animation animation;
    private final Range initialHue;
    private final Range finalHue;

    public Emitter(Animation animation) {
        this.animation = animation;
        float waggleRange = (float)Math.random() * 1.0f;
        this.waggle = new Range(-waggleRange, waggleRange);
        float wiggleRange = (float)Math.random() * 1.0f;
        this.wiggle = new Range(-wiggleRange, wiggleRange);
        this.initialVelocity = new Range((float)Math.random() * 12.0f, (float)Math.random() * 12.0f);
        this.finalVelocity = new Range((float)Math.random() * 1.0f, (float)Math.random() * 1.0f);
        this.initialHue = new Range((float)Math.random() * 1.0f, (float)Math.random() * 1.0f);
        this.finalHue = new Range((float)Math.random() * 1.0f, (float)Math.random() * 1.0f);
        this.duration = new DieRoll(Util.random((int)6, (int)10), Util.random((int)15, (int)20));
        this.numParticles = new DieRoll(1, 1, 1500);
    }

    public Emitter(Room room, int magic, Animation animation) {
        this.animation = animation;
        float waggleRange = room.getParameter(0 + magic, 0.0f, 0.25f);
        this.waggle = new Range(-waggleRange, waggleRange);
        float wiggleRange = room.getParameter(0 + magic, 0.0f, 0.1f);
        this.wiggle = new Range(-wiggleRange, wiggleRange);
        this.initialVelocity = new Range(room.getParameter(8 + magic, 1.0f, 12.0f), room.getParameter(9 + magic, 1.0f, 12.0f));
        this.finalVelocity = new Range(room.getParameter(10 + magic, 0.0f, 1.0f), room.getParameter(11 + magic, 0.0f, 1.0f));
        this.initialHue = new Range(room.getParameter(5 + magic, 0.0f, 1.0f), room.getParameter(6 + magic, 0.0f, 1.0f));
        this.finalHue = new Range(room.getParameter(7 + magic, 0.0f, 1.0f), room.getParameter(8 + magic, 0.0f, 1.0f));
        this.duration = new DieRoll((int)room.getParameter(12 + magic, 5.0f, 7.0f), (int)room.getParameter(13 + magic, 15.0f, 25.0f));
        this.numParticles = magic == 4 ? new DieRoll(1, 1, 1024) : new DieRoll((int)room.getParameter(14 + magic, 3.0f, 7.0f), (int)room.getParameter(15 + magic, 12.0f, 15.0f));
    }

    public void emit(Vector3i position, SpriteAllocator allocator) {
        int n;
        int i = n = this.numParticles.getValue();
        while (--i >= 0) {
            Sprite s = allocator.allocateSprite(this);
            if (s == null) break;
            s.setLayer(1);
            new Particle(s, this.animation, (ReadableVector3i)position, FPMath.ONE, 0, FPMath.fpValue((float)this.initialVelocity.getValue()), FPMath.fpValue((float)this.finalVelocity.getValue()), this.initialHue.getValue(), this.finalHue.getValue(), FPMath.fpValue((float)this.wiggle.getValue()), FPMath.fpValue((float)this.waggle.getValue()), this.duration.getValue());
        }
    }
}

