/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.WritableColor;

public class ColorPulse {
    private final Color color = new Color();
    private final Color baseColor = new Color();
    private final Color pulseColor = new Color();
    private float baseHue;
    private float pulseHue;
    private float saturation;
    private float brightness;
    private float frequency;
    private int tick;

    public ColorPulse() {
    }

    public ColorPulse(float baseHue, float pulseHue, float saturation, float brightness, float frequency) {
        this.baseHue = baseHue;
        this.pulseHue = pulseHue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.frequency = frequency;
        this.baseColor.fromHSB(baseHue, saturation, brightness);
        this.pulseColor.fromHSB(pulseHue, saturation, brightness);
    }

    public void tick() {
        float time = this.frequency * (float)this.tick;
        float ratio = ((float)Math.cos(time) + 1.0f) / 2.0f;
        ColorInterpolator.interpolate((ReadableColor)this.baseColor, (ReadableColor)this.pulseColor, (float)ratio, (Interpolator)LinearInterpolator.instance, (WritableColor)this.color);
        ++this.tick;
    }

    public ReadableColor getColor() {
        return this.color;
    }
}

