/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.PointParser;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Parseable;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import genesis.Alien;
import genesis.Appearance;
import genesis.DieRoll;
import genesis.Entity;
import genesis.Game;
import genesis.Movement;
import genesis.Player;
import genesis.Range;
import genesis.Room;
import genesis.SFX;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.lwjgl.util.Point;
import org.w3c.dom.Element;

public class Behaviour
extends Feature {
    public static final long serialVersionUID = 1L;
    private static final Vector3i scratch;
    private String id;
    private String master;
    private String appearance;
    private boolean bouncy;
    private boolean edgeBouncy;
    private boolean wrap;
    private boolean ignorePlayerBounce;
    private boolean oneHit;
    private int energy;
    private DieRoll duration;
    private int maxInstances;
    private int minInstances;
    private DieRoll spawnDelay;
    private DieRoll spawnDuration;
    private boolean spawnSolid;
    private String message;
    private Spawn spawn;
    private Movement movement;
    private List onCollide;
    private List onTimeout;
    private List onDrained;
    private List onReleased;
    private List onRemoved;
    private List onInit;
    private List onEvent;
    private transient Appearance appearanceFeature;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("genesis.Behaviour");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        scratch = new Vector3i();
    }

    public Behaviour() {
    }

    public Behaviour(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.spawn = XMLUtil.hasChild((Element)element, (String)"spawn") ? new Spawn(XMLUtil.getChild((Element)element, (String)"spawn")) : new Spawn();
        List collisionList = XMLUtil.getChildren((Element)element, (String)"oncollision");
        this.onCollide = new ArrayList(collisionList.size());
        Iterator i = collisionList.iterator();
        while (i.hasNext()) {
            CollisionEvent event = new CollisionEvent((Element)i.next());
            this.onCollide.add(event);
        }
        List timeoutList = XMLUtil.getChildren((Element)element, (String)"ontimeout");
        this.onTimeout = new ArrayList(timeoutList.size());
        Iterator i2 = timeoutList.iterator();
        while (i2.hasNext()) {
            Event event = new Event((Element)i2.next());
            this.onTimeout.add(event);
        }
        List drainedList = XMLUtil.getChildren((Element)element, (String)"ondrained");
        this.onDrained = new ArrayList(drainedList.size());
        Iterator i3 = drainedList.iterator();
        while (i3.hasNext()) {
            Event event = new Event((Element)i3.next());
            this.onDrained.add(event);
        }
        List eventList = XMLUtil.getChildren((Element)element, (String)"onevent");
        this.onEvent = new ArrayList(eventList.size());
        Iterator i4 = eventList.iterator();
        while (i4.hasNext()) {
            RoomEvent event = new RoomEvent((Element)i4.next());
            this.onEvent.add(event);
        }
        List releasedList = XMLUtil.getChildren((Element)element, (String)"onreleased");
        this.onReleased = new ArrayList(releasedList.size());
        Iterator i5 = releasedList.iterator();
        while (i5.hasNext()) {
            Event event = new Event((Element)i5.next());
            this.onReleased.add(event);
        }
        List removedList = XMLUtil.getChildren((Element)element, (String)"onremoved");
        this.onRemoved = new ArrayList(removedList.size());
        Iterator i6 = removedList.iterator();
        while (i6.hasNext()) {
            Event event = new Event((Element)i6.next());
            this.onRemoved.add(event);
        }
        List initList = XMLUtil.getChildren((Element)element, (String)"oninit");
        this.onInit = new ArrayList(initList.size());
        Iterator i7 = initList.iterator();
        while (i7.hasNext()) {
            Event event = new Event((Element)i7.next());
            this.onInit.add(event);
        }
        if (this.master == null) {
            this.master = this.id;
        }
        if (!$assertionsDisabled && this.edgeBouncy && this.wrap) {
            throw new AssertionError((Object)"Alien cannot be both edgeBouncy and wrapped");
        }
    }

    public void tick(Alien alien) {
        Movement m = alien.getMovement();
        if (m != null) {
            m.move(alien);
        }
    }

    private void init(Alien alien, Entity source, boolean bullet) {
        if (this.appearanceFeature != null) {
            alien.setAppearance(this.appearanceFeature);
        }
        if (this.energy > 0) {
            alien.setEnergy(this.energy);
        }
        if (this.duration != null) {
            alien.setTimeout(this.duration.getValue());
        }
        if (this.spawnDelay != null) {
            alien.setSpawnDelay(this.spawnDelay.getValue());
        } else {
            alien.setSpawnDelay(0);
        }
        if (this.spawnDuration != null) {
            alien.setSpawnDuration(this.spawnDuration.getValue());
        } else {
            alien.setSpawnDuration(0);
        }
        if (this.movement != null) {
            alien.setMovement(this.movement);
        }
        alien.setBehaviour(this);
        alien.setSpawnSource(source);
        alien.setBullet(bullet);
    }

    public String getMessage() {
        return this.message;
    }

    public String getID() {
        return this.id;
    }

    public String getMasterID() {
        return this.master;
    }

    public void handleCollision(Alien src, Alien dest) {
        if (this.bouncy && !src.ignoreBounce()) {
            Vector3i bounceVector = new Vector3i((ReadableVector3i)src.getVelocity());
            src.getVelocity().set((ReadableVector3i)dest.getVelocity());
            dest.getVelocity().set((ReadableVector3i)bounceVector);
            dest.setIgnoreBounce();
            src.setIgnoreBounce();
            double angle = Math.atan2(src.getVelocity().getY(), src.getVelocity().getX());
            src.setAngle(FPMath.fpYaklyDegrees((double)angle));
            angle = Math.atan2(dest.getVelocity().getY(), dest.getVelocity().getX());
            dest.setAngle(FPMath.fpYaklyDegrees((double)angle));
            SFX.alienBounce();
        }
        int i = 0;
        while (i < this.onCollide.size()) {
            CollisionEvent event = (CollisionEvent)this.onCollide.get(i);
            if (event.with.equals("*") && !src.getBehaviour().getID().equals(dest.getBehaviour().getID()) || event.with.equals(dest.getBehaviour().getID())) {
                event.doAction(src);
            }
            ++i;
        }
    }

    public void handleCollision(Alien src, Player dest) {
        if (this.oneHit && src.hasHitPlayer()) {
            return;
        }
        src.setHitPlayer();
        if (!this.ignorePlayerBounce && this.bouncy && !src.ignoreBounce()) {
            Vector3i bounceVector = new Vector3i((ReadableVector3i)src.getVelocity());
            src.getVelocity().set((ReadableVector3i)dest.getVelocity());
            dest.getVelocity().set((ReadableVector3i)bounceVector);
            double angle = Math.atan2(src.getVelocity().getY(), src.getVelocity().getX());
            src.setAngle(FPMath.fpYaklyDegrees((double)angle));
            SFX.alienBounce();
        }
        int i = 0;
        while (i < this.onCollide.size()) {
            CollisionEvent event = (CollisionEvent)this.onCollide.get(i);
            if (event.with.equals("player")) {
                event.doAction(src);
            }
            ++i;
        }
    }

    public void handleEvent(Alien alien, String eventName) {
        int i = 0;
        while (i < this.onEvent.size()) {
            RoomEvent event = (RoomEvent)this.onEvent.get(i);
            if (event.event.equals(eventName)) {
                event.doAction(alien);
            }
            ++i;
        }
    }

    public void handleTimeout(Alien alien) {
        int i = 0;
        while (i < this.onTimeout.size()) {
            Event event = (Event)this.onTimeout.get(i);
            event.doAction(alien);
            ++i;
        }
    }

    public void handleDrained(Alien alien) {
        int i = 0;
        while (i < this.onDrained.size()) {
            Event event = (Event)this.onDrained.get(i);
            event.doAction(alien);
            ++i;
        }
    }

    public void handleRemoved(Alien alien) {
        int i = 0;
        while (i < this.onRemoved.size()) {
            Event event = (Event)this.onRemoved.get(i);
            event.doAction(alien);
            ++i;
        }
    }

    public void handleReleased(Alien alien) {
        int i = 0;
        while (i < this.onReleased.size()) {
            Event event = (Event)this.onReleased.get(i);
            event.doAction(alien);
            ++i;
        }
    }

    public void handleInit(Alien alien) {
        int i = 0;
        while (i < this.onInit.size()) {
            Event event = (Event)this.onInit.get(i);
            event.doAction(alien);
            ++i;
        }
    }

    public void tick(boolean bullet) {
        this.spawn(null, bullet);
    }

    private Alien spawn(Alien source, boolean bullet) {
        Room room = Game.getGameState().getCurrentRoom();
        int currentInstances = room.getCount(this);
        if (currentInstances < this.minInstances || room.getNumEntities() < room.getMaxEntities() && (this.maxInstances == 0 || currentInstances < this.maxInstances)) {
            Alien alien = new Alien(room);
            room.addAlien(alien);
            this.init(alien, source, bullet);
            return alien;
        }
        return null;
    }

    public void spawnQueued(Entity source, Alien queued) {
        this.spawn.spawn(queued, source);
    }

    public String toString() {
        return this.id;
    }

    public boolean isSpawnSolid() {
        return this.spawnSolid;
    }

    public boolean isBouncy() {
        return this.bouncy;
    }

    public boolean isEdgeBouncy() {
        return this.edgeBouncy;
    }

    public boolean isWrapped() {
        return this.wrap;
    }

    public boolean isOneHit() {
        return this.oneHit;
    }

    public void doSpawn(Alien alien, Entity spawner) {
        this.spawn.spawn(alien, spawner);
    }

    public static class Spawn
    implements Serializable {
        static final long serialVersionUID = 1L;
        private static final int ANY_EDGE = 5;
        private static final int NORTH = 1;
        private static final int SOUTH = 2;
        private static final int EAST = 3;
        private static final int WEST = 4;
        private String source;
        private Point location;
        private int edge;
        private Range range;
        private boolean inheritVelocity;
        private boolean inheritAngle;
        private String target;
        private DieRoll angle;
        private DieRoll velocity;
        private boolean safe;
        private int safeRange;
        private boolean edgeAngle;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("genesis.Behaviour$Spawn");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        private Spawn() {
        }

        public Spawn(Element element) throws Exception {
            if (XMLUtil.hasAttribute((Element)element, (String)"source")) {
                this.source = XMLUtil.getString((Element)element, (String)"source");
            }
            if (XMLUtil.hasAttribute((Element)element, (String)"target")) {
                this.target = XMLUtil.getString((Element)element, (String)"target");
            }
            if (XMLUtil.hasAttribute((Element)element, (String)"range")) {
                this.range = new Range();
                this.range.fromString(XMLUtil.getString((Element)element, (String)"range"));
            }
            if (XMLUtil.hasAttribute((Element)element, (String)"angle")) {
                this.angle = new DieRoll();
                this.angle.fromString(XMLUtil.getString((Element)element, (String)"angle"));
            }
            if (XMLUtil.hasAttribute((Element)element, (String)"inheritvelocity")) {
                this.inheritVelocity = XMLUtil.getBoolean((Element)element, (String)"inheritvelocity");
            }
            if (XMLUtil.hasAttribute((Element)element, (String)"inheritangle")) {
                this.inheritAngle = XMLUtil.getBoolean((Element)element, (String)"inheritangle");
            }
            if (XMLUtil.hasAttribute((Element)element, (String)"edgeangle")) {
                this.edgeAngle = XMLUtil.getBoolean((Element)element, (String)"edgeangle");
            }
            if (XMLUtil.hasAttribute((Element)element, (String)"location")) {
                String data = XMLUtil.getString((Element)element, (String)"location");
                if (data.equals("edge")) {
                    this.edge = 5;
                } else if (data.equals("north")) {
                    this.edge = 1;
                } else if (data.equals("south")) {
                    this.edge = 2;
                } else if (data.equals("east")) {
                    this.edge = 3;
                } else if (data.equals("west")) {
                    this.edge = 4;
                } else {
                    this.location = PointParser.parse((String)data);
                }
            }
            if (XMLUtil.hasAttribute((Element)element, (String)"velocity")) {
                this.velocity = new DieRoll();
                this.velocity.fromString(XMLUtil.getString((Element)element, (String)"velocity"));
            }
            this.safe = XMLUtil.getBoolean((Element)element, (String)"safe", (boolean)false);
            this.safeRange = XMLUtil.getInt((Element)element, (String)"saferange", (int)40);
        }

        void spawn(Alien alien, Entity spawner) {
            int newVelocity;
            int y;
            int x;
            if (this.source != null) {
                if (this.source.equals("player")) {
                    spawner = Game.getGameState().getCurrentRoom().getPlayer();
                } else {
                    spawner = Game.getGameState().getCurrentRoom().findAlien(this.source);
                    if (spawner == null) {
                        alien.remove();
                        return;
                    }
                }
            }
            int newAngle = 0;
            if (this.edge != 0) {
                int choice = this.edge == 5 ? Util.random((int)1, (int)4) : this.edge;
                switch (choice) {
                    case 2: {
                        x = FPMath.fpValue((int)Util.random((int)0, (int)800));
                        y = 0;
                        newAngle = FPMath.QUARTER;
                        break;
                    }
                    case 1: {
                        x = FPMath.fpValue((int)Util.random((int)0, (int)800));
                        y = FPMath.fpValue((int)600);
                        newAngle = FPMath.QUARTER + FPMath.HALF;
                        break;
                    }
                    case 4: {
                        x = 0;
                        y = FPMath.fpValue((int)Util.random((int)0, (int)472));
                        newAngle = 0;
                        break;
                    }
                    case 3: {
                        x = FPMath.fpValue((int)800);
                        y = FPMath.fpValue((int)Util.random((int)0, (int)472));
                        newAngle = FPMath.HALF;
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        x = 0;
                        y = 0;
                        break;
                    }
                }
            } else if (this.location != null) {
                x = FPMath.fpValue((int)this.location.getX());
                y = FPMath.fpValue((int)this.location.getY());
            } else if (spawner != null) {
                x = spawner.getPosition().getX();
                y = spawner.getPosition().getY();
            } else {
                x = FPMath.fpValue((int)400);
                y = FPMath.fpValue((int)400);
            }
            if (this.range != null) {
                float dist = this.range.getValue();
                double a = Math.random() * 2.0 * Math.PI;
                x += FPMath.fpValue((double)(Math.cos(a) * (double)dist));
                y += FPMath.fpValue((double)(Math.sin(a) * (double)dist));
            }
            if (x < 0) {
                x = 0;
            } else if (x >= FPMath.fpValue((int)800)) {
                x = FPMath.fpValue((int)800);
            }
            if (y < 0) {
                y = 0;
            } else if (y >= FPMath.fpValue((int)600)) {
                y = FPMath.fpValue((int)600);
            }
            if (this.inheritAngle && spawner != null) {
                int a = this.angle != null ? this.angle.getValue() << 8 : 0;
                newAngle = spawner.getAngle() + a;
            } else if (this.target != null) {
                Alien a;
                Object t = this.target.equals("player") ? Game.getGameState().getCurrentRoom().getPlayer().getPosition() : ((a = Game.getGameState().getCurrentRoom().findAlien(this.target)) != null ? a.getPosition() : null);
                if (t == null) {
                    newAngle = Util.random((int)0, (int)FPMath.ONE);
                } else {
                    scratch.set(x, y, 0);
                    Vector3i.sub((ReadableVector3i)t, (ReadableVector3i)scratch, (WritableVector3i)scratch);
                    newAngle = FPMath.fpYaklyDegrees((double)Math.atan2(scratch.getY(), scratch.getX()));
                }
            } else if (this.edge != 0 && this.edgeAngle) {
                int a = this.angle != null ? this.angle.getValue() << 8 : 0;
                newAngle += Util.random((int)(-a), (int)a);
            } else {
                newAngle = this.angle != null ? this.angle.getValue() << 8 : Util.random((int)0, (int)FPMath.ONE);
            }
            alien.setAngle(newAngle);
            int n = newVelocity = this.velocity != null ? this.velocity.getValue() : 0;
            if (this.inheritVelocity && spawner != null) {
                alien.getVelocity().set((ReadableVector3i)spawner.getVelocity());
                int originalVelocity = alien.getVelocity().length();
                alien.getVelocity().normalize();
                alien.getVelocity().scale(originalVelocity + newVelocity);
            } else if (this.velocity != null) {
                alien.getVelocity().set(FPMath.cos((int)newAngle) * newVelocity, FPMath.sin((int)newAngle) * newVelocity, 0);
            } else {
                alien.getVelocity().set(0, 0, 0);
            }
            if (this.safe && !Game.getGameState().getCurrentRoom().checkSafe(alien, spawner, x, y, FPMath.fpValue((int)this.safeRange))) {
                alien.setQueued(spawner);
            } else {
                alien.dequeue();
                alien.getPosition().set(x, y, 0);
            }
        }
    }

    public class Action
    implements Parseable,
    Serializable {
        static final long serialVersionUID = 1L;
        private static final int NOTHING = 0;
        private static final int DRAIN = 1;
        private static final int EXPLODE = 2;
        private static final int REMOVE = 3;
        private static final int COLLECT = 4;
        private static final int UNCOLLECT = 5;
        private static final int BEHAVIOUR = 6;
        private static final int SPAWN = 7;
        private static final int SLOW = 8;
        private static final int ADD = 9;
        private static final int APPEARANCE = 10;
        private static final int SEQUENCE = 11;
        private static final int ANGLE = 12;
        private static final int VELOCITY = 13;
        private static final int PARTICLES = 14;
        private static final int DAMAGE = 15;
        private static final int SET = 16;
        private static final int XOR = 17;
        private static final int AND = 18;
        private static final int OR = 19;
        private static final int EVENT = 20;
        private static final int CRAZY = 21;
        private static final int SANE = 22;
        private static final int SOUND = 23;
        private static final int ROTATE = 24;
        private static final int RETARGET = 25;
        private static final int MOVEMENT = 26;
        private static final int SAY = 27;
        private static final int DURATION = 28;
        private static final int BEHAVIOUR_QUIET = 29;
        private static final int REPLENISH = 31;
        private static final int EXTRATIME = 32;
        private int type;
        private List mutateInto;
        private String var;
        private DieRoll amount;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("genesis.Behaviour$Action");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        Action() {
        }

        public void fromString(String src) throws Exception {
            if (src.equals("nothing")) {
                this.type = 0;
            } else if (src.equals("drain")) {
                this.type = 1;
            } else if (src.equals("retarget")) {
                this.type = 25;
            } else if (src.equals("explode")) {
                this.type = 2;
            } else if (src.equals("particles")) {
                this.type = 14;
            } else if (src.equals("remove")) {
                this.type = 3;
            } else if (src.equals("collect")) {
                this.type = 4;
            } else if (src.equals("uncollect")) {
                this.type = 5;
            } else if (src.equals("crazy")) {
                this.type = 21;
            } else if (src.equals("sane")) {
                this.type = 22;
            } else if (src.startsWith("behaviour ")) {
                this.type = 6;
                StringTokenizer st = new StringTokenizer(src.substring(10), ",", false);
                this.mutateInto = new ArrayList(1);
                while (st.hasMoreElements()) {
                    this.mutateInto.add(st.nextToken());
                }
            } else if (src.startsWith("behaviour_quiet ")) {
                this.type = 29;
                StringTokenizer st = new StringTokenizer(src.substring(16), ",", false);
                this.mutateInto = new ArrayList(1);
                while (st.hasMoreElements()) {
                    this.mutateInto.add(st.nextToken());
                }
            } else if (src.startsWith("event ")) {
                this.type = 20;
                StringTokenizer st = new StringTokenizer(src.substring(6), ",", false);
                this.mutateInto = new ArrayList(1);
                while (st.hasMoreElements()) {
                    this.mutateInto.add(st.nextToken());
                }
            } else if (src.startsWith("sequence ")) {
                this.type = 11;
                int idx = src.indexOf(32, 10);
                StringTokenizer st = idx == -1 ? new StringTokenizer(src.substring(9), ",", false) : new StringTokenizer(src.substring(9, idx), ",", false);
                this.mutateInto = new ArrayList(1);
                while (st.hasMoreElements()) {
                    this.mutateInto.add(st.nextToken());
                }
                if (idx != -1) {
                    this.var = src.substring(idx + 1);
                }
            } else if (src.startsWith("appearance ")) {
                this.type = 10;
                StringTokenizer st = new StringTokenizer(src.substring(11), ",", false);
                this.mutateInto = new ArrayList(1);
                while (st.hasMoreElements()) {
                    this.mutateInto.add(st.nextToken());
                }
            } else if (src.startsWith("slow ")) {
                this.type = 8;
                this.amount = new DieRoll();
                this.amount.fromString(src.substring(5));
            } else if (src.startsWith("movement ")) {
                this.type = 26;
                this.var = src.substring(9);
            } else if (src.startsWith("sound ")) {
                this.type = 23;
                int idx = src.indexOf(32);
                if (idx == -1) {
                    this.var = src.substring(6);
                } else {
                    this.var = src.substring(6, idx);
                    this.amount = new DieRoll();
                    this.amount.fromString(src.substring(idx + 1));
                }
            } else if (src.startsWith("damage ")) {
                this.type = 15;
                this.amount = new DieRoll();
                this.amount.fromString(src.substring(7));
            } else if (src.startsWith("add ")) {
                this.type = 9;
                int idx = src.indexOf(32, 5);
                this.var = src.substring(4, idx);
                this.amount = new DieRoll();
                this.amount.fromString(src.substring(idx + 1));
            } else if (src.startsWith("set ")) {
                this.type = 16;
                int idx = src.indexOf(32, 5);
                this.var = src.substring(4, idx);
                this.amount = new DieRoll();
                this.amount.fromString(src.substring(idx + 1));
            } else if (src.startsWith("xor ")) {
                this.type = 17;
                int idx = src.indexOf(32, 5);
                this.var = src.substring(4, idx);
                this.amount = new DieRoll();
                this.amount.fromString(src.substring(idx + 1));
            } else if (src.startsWith("and ")) {
                this.type = 18;
                int idx = src.indexOf(32, 5);
                this.var = src.substring(4, idx);
                this.amount = new DieRoll();
                this.amount.fromString(src.substring(idx + 1));
            } else if (src.startsWith("or ")) {
                this.type = 19;
                int idx = src.indexOf(32, 4);
                this.var = src.substring(3, idx);
                this.amount = new DieRoll();
                this.amount.fromString(src.substring(idx + 1));
            } else if (src.startsWith("spawn ")) {
                this.type = 7;
                int idx = src.indexOf(32, 7);
                if (idx > 0) {
                    this.var = src.substring(6, idx);
                    this.amount = new DieRoll();
                    this.amount.fromString(src.substring(idx + 1));
                } else {
                    this.var = src.substring(6);
                    this.amount = new DieRoll(0, 0, 1);
                }
            } else if (src.startsWith("angle ")) {
                this.type = 12;
                this.amount = new DieRoll();
                this.amount.fromString(src.substring(6));
            } else if (src.startsWith("rotate ")) {
                this.type = 24;
                this.amount = new DieRoll();
                this.amount.fromString(src.substring(7));
            } else if (src.startsWith("velocity ")) {
                this.type = 13;
                this.amount = new DieRoll();
                this.amount.fromString(src.substring(9));
            } else if (src.startsWith("say ")) {
                this.type = 27;
                this.var = src.substring(4);
            } else if (src.startsWith("duration ")) {
                this.type = 28;
                this.amount = new DieRoll();
                this.amount.fromString(src.substring(9));
            } else if (src.equals("replenish")) {
                this.type = 31;
            } else if (src.equals("extratime")) {
                this.type = 32;
            } else {
                throw new Exception("Unknown action " + src);
            }
        }

        private void doAction(Alien alien) {
            block5 : switch (this.type) {
                case 0: {
                    break;
                }
                case 1: {
                    alien.drain();
                    break;
                }
                case 2: {
                    Game.getGameState().getCurrentRoom().alienExplosionEffect(alien);
                    alien.remove();
                    break;
                }
                case 3: {
                    alien.remove();
                    break;
                }
                case 25: {
                    Behaviour.this.movement.retarget(alien);
                    break;
                }
                case 26: {
                    Movement m = new Movement();
                    try {
                        m.fromString(this.var);
                        alien.setMovement(m);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 4: {
                    Game.getGameState().getCurrentRoom().getPlayer().collect(alien);
                    break;
                }
                case 5: {
                    Game.getGameState().getCurrentRoom().getPlayer().uncollect(true);
                    break;
                }
                case 6: {
                    int n = Util.random((int)0, (int)(this.mutateInto.size() - 1));
                    SFX.alienMutate();
                    Game.getGameState().getCurrentRoom().getBehaviour((String)this.mutateInto.get(n)).init(alien, null, false);
                    break;
                }
                case 29: {
                    int n = Util.random((int)0, (int)(this.mutateInto.size() - 1));
                    Game.getGameState().getCurrentRoom().getBehaviour((String)this.mutateInto.get(n)).init(alien, null, false);
                    break;
                }
                case 20: {
                    int n = Util.random((int)0, (int)(this.mutateInto.size() - 1));
                    Game.getGameState().getCurrentRoom().fireEvent((String)this.mutateInto.get(n));
                    break;
                }
                case 7: {
                    int n = this.amount.getValue();
                    Behaviour behaviour = Game.getGameState().getCurrentRoom().getBehaviour(this.var);
                    if (behaviour == null) break;
                    int i = 0;
                    while (i < n) {
                        if (behaviour.spawn(alien, false) == null) break block5;
                        ++i;
                    }
                    break;
                }
                case 8: {
                    alien.getVelocity().scale(FPMath.fpValue((float)((float)this.amount.getValue() / 100.0f)));
                    break;
                }
                case 9: {
                    Game.getGameState().getCurrentRoom().addVariable(this.var, this.amount.getValue());
                    break;
                }
                case 18: {
                    Game.getGameState().getCurrentRoom().andVariable(this.var, this.amount.getValue());
                    break;
                }
                case 19: {
                    Game.getGameState().getCurrentRoom().orVariable(this.var, this.amount.getValue());
                    break;
                }
                case 17: {
                    Game.getGameState().getCurrentRoom().xorVariable(this.var, this.amount.getValue());
                    break;
                }
                case 10: {
                    int n = Util.random((int)0, (int)(this.mutateInto.size() - 1));
                    SFX.alienMorph();
                    try {
                        alien.setAppearance((Appearance)Resources.get((String)((String)this.mutateInto.get(n))));
                        break;
                    }
                    catch (Exception e) {
                        System.out.println("Failed to set appearance: " + (String)this.mutateInto.get(n));
                        e.printStackTrace(System.err);
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                case 11: {
                    Appearance appearance = alien.getAppearance();
                    String id = appearance.getName();
                    int idx = this.mutateInto.indexOf(id);
                    if (idx == -1) {
                        idx = 0;
                    } else {
                        if (idx == this.mutateInto.size() - 1) {
                            if (this.var == null) break;
                            Behaviour.this.handleEvent(alien, this.var);
                            break;
                        }
                        ++idx;
                    }
                    try {
                        SFX.alienMorph();
                        alien.setAppearance((Appearance)Resources.get((String)((String)this.mutateInto.get(idx))));
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                case 23: {
                    try {
                        ALBuffer sound = (ALBuffer)Resources.get((String)this.var);
                        SoundEffect fx = Game.allocateSound(sound);
                        if (fx == null || this.amount == null) break;
                        float f = (float)this.amount.getValue() / 100.0f + 1.0f;
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("genesis.SFX");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        fx.setPitch(f, (Object)clazz);
                        break;
                    }
                    catch (Exception e) {
                        System.out.println("Failed to play sound " + this.var);
                        e.printStackTrace(System.err);
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                case 12: {
                    alien.setAngle(this.amount.getValue() << 8);
                    break;
                }
                case 24: {
                    alien.adjustAngle(this.amount.getValue() << 8);
                    break;
                }
                case 13: {
                    int angle = alien.getAngle();
                    alien.getVelocity().set(FPMath.cos((int)angle), FPMath.sin((int)angle), 0);
                    alien.getVelocity().scale(FPMath.fpValue((int)this.amount.getValue()));
                    break;
                }
                case 14: {
                    Game.getGameState().getCurrentRoom().spuriousParticleEffect(alien);
                    break;
                }
                case 15: {
                    Game.getGameState().getCurrentRoom().getPlayer().damage(this.amount.getValue());
                    break;
                }
                case 21: {
                    alien.setCrazyColours(true);
                    break;
                }
                case 22: {
                    alien.setCrazyColours(false);
                    break;
                }
                case 16: {
                    Game.getGameState().getCurrentRoom().setVariable(this.var, this.amount.getValue());
                    break;
                }
                case 27: {
                    alien.setLabel(this.var, 120);
                    break;
                }
                case 28: {
                    alien.setTimeout(this.amount.getValue());
                    break;
                }
                case 31: {
                    alien.replenish(Behaviour.this.energy);
                    break;
                }
                case 32: {
                    Game.getGameState().extraTime();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
    }

    public class Event
    implements Serializable {
        static final long serialVersionUID = 1L;
        private int chance;
        private Action[] action;
        private Action[] elseAction;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("genesis.Behaviour$Event");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        protected Event(Element element) throws Exception {
            String actionsString = XMLUtil.getString((Element)element, (String)"action");
            String elseActionsString = null;
            int cix = actionsString.indexOf(37);
            if (cix > -1) {
                this.chance = Integer.parseInt(actionsString.substring(0, cix));
                int elseIndex = actionsString.indexOf(47);
                if (elseIndex == -1) {
                    actionsString = actionsString.substring(cix + 1).trim();
                } else {
                    elseActionsString = actionsString.substring(elseIndex + 1);
                    actionsString = actionsString.substring(cix + 1, elseIndex).trim();
                }
                if (!($assertionsDisabled || this.chance > 0 && this.chance <= 100)) {
                    throw new AssertionError();
                }
            } else {
                this.chance = 100;
            }
            ArrayList<Action> actionsList = new ArrayList<Action>(1);
            StringTokenizer st = new StringTokenizer(actionsString, ";", false);
            while (st.hasMoreElements()) {
                Action a = new Action();
                a.fromString(st.nextToken().trim());
                actionsList.add(a);
            }
            this.action = new Action[actionsList.size()];
            actionsList.toArray(this.action);
            ArrayList<Action> elseActionsList = new ArrayList<Action>(1);
            if (elseActionsString != null) {
                st = new StringTokenizer(elseActionsString, ";", false);
                while (st.hasMoreElements()) {
                    Action a = new Action();
                    a.fromString(st.nextToken().trim());
                    elseActionsList.add(a);
                }
                this.elseAction = new Action[elseActionsList.size()];
                elseActionsList.toArray(this.elseAction);
            }
        }

        void doAction(Alien alien) {
            if (Util.random((int)0, (int)100) > this.chance) {
                if (this.elseAction != null) {
                    int i = 0;
                    while (i < this.elseAction.length) {
                        this.elseAction[i].doAction(alien);
                        ++i;
                    }
                }
                return;
            }
            int i = 0;
            while (i < this.action.length) {
                this.action[i].doAction(alien);
                ++i;
            }
        }
    }

    public class CollisionEvent
    extends Event {
        static final long serialVersionUID = 1L;
        private String with;

        private CollisionEvent(Element element) throws Exception {
            super(element);
            this.with = XMLUtil.getString((Element)element, (String)"with");
        }
    }

    public class RoomEvent
    extends Event {
        static final long serialVersionUID = 1L;
        private String event;

        private RoomEvent(Element element) throws Exception {
            super(element);
            this.event = XMLUtil.getString((Element)element, (String)"event");
        }
    }
}

