/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import genesis.SFX;
import genesis.Screen;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableDimension;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.Rectangle;

public class Area
extends Feature {
    public static final long serialVersionUID = 1L;
    private String id;
    private String mouseOff;
    private String mouseOn;
    private String disabled;
    private Point position;
    private Dimension size;
    private boolean noClick;
    private int layer;
    private boolean visible = true;
    private transient SpriteImage mouseOnResource;
    private transient SpriteImage mouseOffResource;
    private transient SpriteImage disabledResource;
    private transient Sprite sprite;
    private transient Rectangle bounds;
    private transient Screen screen;
    private transient boolean ignoreMouse;
    private transient boolean enabled;

    protected void doCreate() throws Exception {
        super.doCreate();
        this.bounds = this.mouseOffResource != null ? new Rectangle(this.position.getX() - this.mouseOffResource.getHotspotX(), this.position.getY() - this.mouseOffResource.getHotspotY(), this.mouseOffResource.getWidth(), this.mouseOffResource.getHeight()) : new Rectangle((ReadablePoint)this.position, (ReadableDimension)this.size);
        this.enabled = true;
    }

    public void init(Screen screen) {
        this.screen = screen;
        if (this.mouseOffResource != null) {
            this.sprite = screen.allocateSprite((Object)this);
            this.sprite.setLayer(this.layer);
            this.sprite.setLocation(this.position.getX(), this.position.getY(), 0);
        }
    }

    public void cleanup() {
        if (this.sprite != null) {
            this.sprite.deallocate();
            this.sprite = null;
        }
    }

    public void tick() {
        boolean mouseOver = this.bounds.contains(this.screen.getMouseX(), this.screen.getMouseY());
        if (this.sprite != null) {
            if (this.mouseOnResource != null && mouseOver && this.enabled) {
                if (this.sprite.getImage() != this.mouseOnResource) {
                    if (!this.noClick) {
                        SFX.buttonHover();
                    }
                    this.sprite.setImage(this.mouseOnResource);
                }
            } else if (this.enabled && this.mouseOffResource != null) {
                this.sprite.setImage(this.mouseOffResource);
            } else if (this.disabledResource != null) {
                this.sprite.setImage(this.disabledResource);
            }
        }
        if (Mouse.isButtonDown((int)0) && this.visible && mouseOver && !this.noClick && !this.ignoreMouse && this.enabled) {
            SFX.buttonClick();
            this.ignoreMouse = true;
            this.screen.onClicked(this.id);
        } else if (!Mouse.isButtonDown((int)0)) {
            this.ignoreMouse = false;
        }
    }

    public String getID() {
        return this.id;
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (visible) {
            this.ignoreMouse = true;
        }
        if (this.sprite != null) {
            this.sprite.setVisible(visible);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.sprite != null) {
            if (enabled) {
                this.sprite.setImage(this.mouseOffResource);
            } else {
                this.sprite.setImage(this.disabledResource);
            }
        }
    }
}

