/*
 * Decompiled with CFR 0.152.
 */
package genesis;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.util.FPMath;
import genesis.Appearance;
import genesis.Behaviour;
import genesis.Effect;
import genesis.Entity;
import genesis.LabelEffect;
import genesis.Movement;
import genesis.Player;
import genesis.Room;
import genesis.SFX;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class Alien
extends Entity {
    private final Room room;
    private Behaviour behaviour;
    private int phase;
    private static final int WAITING = 0;
    private static final int QUEUED = 1;
    private static final int SPAWNING = 2;
    private static final int ALIVE = 3;
    private Movement movement;
    private int tick;
    private int spawnDuration;
    private int spawnDelay;
    private int energy;
    private int timeout;
    private boolean ignoreBounce;
    private boolean inCollision;
    private Appearance appearance;
    private Entity target;
    private boolean collected;
    private int damaged;
    private boolean hitPlayer;
    private boolean touchingPlayer;
    private int waggleTick;
    private boolean crazyColours;
    private static final Color crazyColour;
    private LabelEffect labelEffect;
    private Entity spawner;
    private boolean bullet;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("genesis.Alien");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        crazyColour = new Color();
    }

    public Alien(Room room) {
        this.room = room;
    }

    public boolean canCollide() {
        return this.appearance != null && !this.collected && (this.phase == 3 || this.phase == 2 && this.getBehaviour().isSpawnSolid());
    }

    public int getRadius() {
        return this.appearance == null ? 0 : FPMath.mul((int)this.getScale(), (int)this.appearance.getRadius());
    }

    public void onEvent(String event) {
        if (!this.isAlive()) {
            return;
        }
        this.behaviour.handleEvent(this, event);
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithAlien(this);
    }

    public void onCollisionWithAlien(Alien alien) {
        this.inCollision = true;
        this.behaviour.handleCollision(this, alien);
    }

    public void onCollisionWithPlayer(Player player) {
        this.touchingPlayer = true;
        this.behaviour.handleCollision(this, player);
    }

    protected void doTick() {
        if (!this.inCollision) {
            this.ignoreBounce = false;
        }
        this.inCollision = false;
        if (!this.touchingPlayer) {
            this.hitPlayer = false;
        }
        this.touchingPlayer = false;
        if (this.collected) {
            return;
        }
        try {
            switch (this.phase) {
                case 0: {
                    this.waitTick();
                    break;
                }
                case 1: {
                    ++this.tick;
                    if (this.tick > 60) {
                        this.remove();
                    } else {
                        this.getBehaviour().spawnQueued(this.spawner, this);
                    }
                    break;
                }
                case 2: {
                    this.spawnTick();
                    break;
                }
                case 3: {
                    this.aliveTick();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Entity crashed in doTick: " + (Object)((Object)this.behaviour) + "/" + (Object)((Object)this.appearance) + "/" + this.phase);
            e.printStackTrace(System.err);
            this.remove();
        }
    }

    protected void doSpawn() {
        this.setVisible(false);
        if (this.labelEffect != null) {
            this.labelEffect.setVisible(false);
        }
    }

    protected void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.labelEffect != null) {
            this.labelEffect.setVisible(visible);
        }
    }

    protected void doRemove() {
        if (this.behaviour != null) {
            this.behaviour.handleRemoved(this);
        }
        if (this.labelEffect != null) {
            this.labelEffect.finish();
            this.labelEffect = null;
        }
    }

    private void waitTick() {
        ++this.tick;
        if (this.tick >= this.spawnDelay) {
            this.phase = 2;
            this.tick = 0;
            this.setScale(0);
            this.setVisible(true);
            this.behaviour.doSpawn(this, this.spawner);
            if (this.labelEffect != null) {
                this.labelEffect.setVisible(true);
                this.labelEffect.setLocation(FPMath.intValue((int)this.getPosition().getX()), FPMath.intValue((int)this.getPosition().getY()) + 32);
            }
        }
    }

    private void spawnTick() {
        ++this.tick;
        if (this.tick >= this.spawnDuration) {
            this.phase = 3;
            this.tick = 0;
            this.setScale(FPMath.ONE);
        } else if ((float)this.spawnDuration > 0.0f) {
            this.setScale(FPMath.fpValue((float)((float)this.tick / (float)this.spawnDuration)));
        }
        this.aliveTick();
    }

    private void aliveTick() {
        this.behaviour.tick(this);
        this.updateAppearance();
        if (this.timeout > 0 && this.isAlive()) {
            --this.timeout;
            if (this.timeout == 0) {
                this.behaviour.handleTimeout(this);
            }
        }
    }

    public void updateAppearance() {
        if (this.appearance != null) {
            if (this.damaged > 0) {
                --this.damaged;
                this.setColor(Color.WHITE);
                if (this.damaged == 0) {
                    this.setFlash(false);
                }
            } else if (this.crazyColours) {
                crazyColour.fromHSB((float)Math.random(), 1.0f, 1.0f);
                this.setColor((ReadableColor)crazyColour);
            } else {
                this.setFlash(false);
                this.setColor(Color.WHITE);
            }
            if (this.appearance.getFacesHeading()) {
                this.setRotation(this.getAngle());
            } else if (this.appearance.getRotation() != 0) {
                this.setRotation(this.getRotation() + (this.appearance.getRotation() << 8));
            } else if (this.appearance.getWaggle() != 0) {
                this.setRotation(FPMath.mul((int)this.appearance.getWaggle(), (int)FPMath.sin((int)(this.waggleTick * this.appearance.getWiggle() / 60))));
                ++this.waggleTick;
            }
        }
        if (this.labelEffect != null) {
            this.labelEffect.setLocation(FPMath.intValue((int)this.getPosition().getX()), FPMath.intValue((int)this.getPosition().getY()) + 32);
        }
    }

    public void setCrazyColours(boolean crazyFlag) {
        this.crazyColours = crazyFlag;
    }

    public Behaviour getBehaviour() {
        return this.behaviour;
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public void setAppearance(Appearance appearance) {
        this.waggleTick = 0;
        this.setRotation(0);
        if (appearance == null) {
            this.appearance = null;
            this.setAnimation(null);
            this.setImage(null);
            this.setVisible(false);
        } else {
            if (appearance.getAnimation() != null) {
                this.setAnimation(appearance.getAnimation());
            } else if (appearance.getImage() != null) {
                this.setImage(appearance.getImage());
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            if (this.appearance == null && this.phase == 3) {
                this.setVisible(true);
            }
            this.appearance = appearance;
        }
    }

    public void drain() {
        this.damage(1);
    }

    public void replenish(int max) {
        if (this.energy >= max) {
            return;
        }
        ++this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void setSpawnDelay(int spawnDelay) {
        this.spawnDelay = spawnDelay;
    }

    public void setSpawnDuration(int spawnDuration) {
        this.spawnDuration = spawnDuration;
    }

    public void setTimeout(int timeOut) {
        this.timeout = timeOut;
    }

    public boolean ignoreBounce() {
        return this.ignoreBounce;
    }

    public void setIgnoreBounce() {
        this.ignoreBounce = true;
    }

    public Entity getTarget() {
        return this.target;
    }

    public void setTarget(Entity target) {
        this.target = target;
    }

    public void setBehaviour(Behaviour behaviour) {
        if (!$assertionsDisabled && behaviour == null) {
            throw new AssertionError();
        }
        this.behaviour = behaviour;
        behaviour.handleInit(this);
        if (this.labelEffect != null) {
            this.labelEffect.finish();
            this.labelEffect = null;
        }
        if (behaviour.getMessage() != null) {
            this.setLabel(behaviour.getMessage(), 500);
        }
    }

    public void setLabel(String text, int duration) {
        try {
            this.labelEffect = new LabelEffect((GLFont)Resources.get((String)"impact-plain-18.glfont"), text, duration);
            if (this.isVisible() && this.isAlive()) {
                this.labelEffect.setVisible(true);
            }
            Effect.addEffect(this.labelEffect);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public String toString() {
        return "Alien[" + (Object)((Object)this.getBehaviour()) + ", " + (Object)((Object)this.appearance) + "]";
    }

    public boolean isCollected() {
        return this.collected;
    }

    public void setCollected(boolean collected) {
        this.collected = collected;
        if (this.labelEffect != null) {
            this.labelEffect.finish();
            this.labelEffect = null;
        }
        if (collected) {
            this.setAlpha(128);
        } else {
            this.setAlpha(255);
        }
        if (!collected) {
            this.behaviour.handleReleased(this);
        }
    }

    public void damage(int amount) {
        SFX.alienDamaged();
        this.energy -= amount;
        this.setFlash(true);
        this.damaged = 2;
        if (this.energy <= 0) {
            this.behaviour.handleDrained(this);
        }
    }

    public boolean hasHitPlayer() {
        return this.hitPlayer;
    }

    public void setHitPlayer() {
        this.hitPlayer = true;
    }

    public Movement getMovement() {
        return this.movement;
    }

    public void setMovement(Movement movement) {
        this.movement = movement;
        movement.retarget(this);
    }

    public void setQueued(Entity spawner) {
        this.spawner = spawner;
        this.phase = 1;
    }

    public void dequeue() {
        if (this.phase == 1) {
            this.phase = 0;
        }
        if (this.bullet) {
            SFX.shoot();
        } else {
            SFX.alienSpawn();
        }
    }

    public void setSpawnSource(Entity spawner) {
        this.spawner = spawner;
    }

    public void setBullet(boolean bullet) {
        this.bullet = bullet;
    }

    public void setAngle(int angle) {
        super.setAngle(angle);
        int v = this.getVelocity().length();
        if (v != 0) {
            this.getVelocity().set(FPMath.mul((int)FPMath.cos((int)this.getAngle()), (int)v), FPMath.mul((int)FPMath.sin((int)this.getAngle()), (int)v), 0);
        }
    }
}

