/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLTexture;
import com.shavenpuppy.jglib.sprites.ImageBank;
import com.shavenpuppy.jglib.sprites.Style;
import org.lwjgl.opengl.OpenGLException;
import org.w3c.dom.Element;

public class SpriteImage
extends Resource {
    public static final long serialVersionUID = 1L;
    private transient ImageBank imageBank;
    private String imageBankName;
    private transient GLTexture texture;
    private transient Style style;
    private String styleName;
    private int x;
    private int y;
    private int w;
    private int h;
    private int hotspotx;
    private int hotspoty;
    private float tx0;
    private float tx1;
    private float ty0;
    private float ty1;

    SpriteImage(String name, String imageBankName, String styleName) {
        this(name);
        this.imageBankName = imageBankName;
        this.styleName = styleName;
    }

    SpriteImage(String name, String imageBankName, String styleName, int x, int y, int w, int h, int hotspotx, int hotspoty) {
        this(name, imageBankName, styleName);
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.hotspotx = hotspotx;
        this.hotspoty = hotspoty;
    }

    public SpriteImage(String texture, String styleName, int hotspotx, int hotspoty) throws Exception {
        this(String.valueOf(texture) + "-image");
        this.texture = (GLTexture)Resources.get(texture);
        this.style = (Style)((Object)Resources.get(styleName));
        this.hotspotx = hotspotx;
        this.hotspoty = hotspoty;
        this.w = this.texture.getWidth();
        this.h = this.texture.getHeight();
        this.tx1 = 1.0f;
        this.ty1 = 1.0f;
    }

    private SpriteImage(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) {
        this.x = Integer.parseInt(element.getAttribute("x"));
        this.y = Integer.parseInt(element.getAttribute("y"));
        this.w = Integer.parseInt(element.getAttribute("w"));
        this.h = Integer.parseInt(element.getAttribute("h"));
        this.hotspotx = Integer.parseInt(element.getAttribute("hx"));
        this.hotspoty = Integer.parseInt(element.getAttribute("hy"));
        this.styleName = element.getAttribute("style");
    }

    private void calculateTextureCoordinates() {
        double tw = this.texture.getWidth();
        double th = this.texture.getHeight();
        double txw = (double)this.w / tw;
        double txh = (double)this.h / th;
        this.tx0 = (float)((double)this.x / tw);
        this.tx1 = (float)((double)(this.x + this.w) / tw);
        this.ty0 = (float)((double)this.y / th);
        this.ty1 = (float)((double)(this.y + this.h) / th);
    }

    protected void doCreate() throws Exception {
        if (this.texture == null) {
            this.imageBank = (ImageBank)Resources.get(this.imageBankName);
            if (this.imageBank == null) {
                throw new OpenGLException("Imagebank " + this.imageBankName + " does not exist");
            }
            this.texture = this.imageBank.texture;
            if (this.texture == null) {
                throw new OpenGLException("Imagebank " + this.imageBankName + " has no texture");
            }
            this.calculateTextureCoordinates();
            if (this.styleName == null || "".equals(this.styleName)) {
                this.styleName = this.imageBank.getDefaultStyleName();
            }
            this.style = (Style)((Object)Resources.get(this.styleName));
        }
    }

    protected void doDestroy() {
        this.imageBank = null;
        this.texture = null;
    }

    public final int getWidth() {
        return this.w;
    }

    public final int getHeight() {
        return this.h;
    }

    public final float getTx0() {
        return this.tx0;
    }

    public final float getTx1() {
        return this.tx1;
    }

    public final float getTy0() {
        return this.ty0;
    }

    public final float getTy1() {
        return this.ty1;
    }

    public final int getHotspotX() {
        return this.hotspotx;
    }

    public final int getHotspotY() {
        return this.hotspoty;
    }

    public final GLTexture getTexture() {
        return this.texture;
    }

    protected Class getAllocatorType() {
        return null;
    }

    public Style getStyle() {
        return this.style;
    }
}

