/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.SpriteEngine;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.WritableColor;

public class Sprite
implements Animated {
    int index;
    private final SpriteEngine engine;
    private Object owner;
    private boolean allocated;
    private Animation animation;
    private SpriteImage image;
    private int tick;
    private int sequence;
    private int layer;
    private int x;
    private int y;
    private int z;
    private int ox;
    private int oy;
    private int oz;
    private boolean flash;
    private final Color[] color = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255)};
    private static final int NO_SCALE;
    private int scale = NO_SCALE;
    private int alpha = 255;
    private int angle = 0;
    private boolean visible = true;
    private boolean active = true;
    private int event;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.sprites.Sprite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NO_SCALE = FPMath.fpValue(1);
    }

    Sprite(SpriteEngine engine) {
        this.engine = engine;
    }

    public void init(Object newOwner) {
        if (!$assertionsDisabled && this.allocated) {
            throw new AssertionError((Object)(this + "Already allocated: " + newOwner + " can't have it!"));
        }
        this.allocated = true;
        this.owner = newOwner;
        this.active = true;
        this.visible = true;
        this.animation = null;
        this.image = null;
        this.flash = false;
        this.ox = 0;
        this.oy = 0;
        this.oz = 0;
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.color[0].set(255, 255, 255, 255);
        this.color[1].set(255, 255, 255, 255);
        this.color[2].set(255, 255, 255, 255);
        this.color[3].set(255, 255, 255, 255);
        this.layer = 0;
        this.scale = NO_SCALE;
        this.sequence = 0;
        this.tick = 0;
        this.alpha = 255;
        this.angle = 0;
        this.event = 0;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
        this.rewind();
    }

    public void rewind() {
        if (this.animation != null) {
            this.sequence = 0;
            this.tick = -1;
            this.tick();
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public Vector3i getLocation(Vector3i ret) {
        if (ret == null) {
            ret = new Vector3i(this.x, this.y, this.z);
        } else {
            ret.set(this.x, this.y, this.z);
        }
        return ret;
    }

    public void setLocation(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i getOffset(Vector3i ret) {
        if (ret == null) {
            ret = new Vector3i(this.ox, this.oy, this.oz);
        } else {
            ret.set(this.ox, this.oy, this.oz);
        }
        return ret;
    }

    public void setOffset(int ox, int oy, int oz) {
        this.ox = ox;
        this.oy = oy;
        this.oz = oz;
    }

    public void setOffset(Vector3i location) {
        this.ox = location.getX();
        this.oy = location.getY();
        this.oz = location.getZ();
    }

    public void tick() {
        if (!this.active || this.animation == null) {
            return;
        }
        this.animation.animate(this, this.engine.getTickRate());
    }

    public void setFlash(boolean flash) {
        this.flash = flash;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void hide() {
        this.setVisible(false);
    }

    public void setColor(int index, int r, int g, int b, int a) {
        this.color[index].set(r, g, b, a);
    }

    public void setColors(int r, int g, int b, int a) {
        this.color[0].set(r, g, b, a);
        this.color[1].set(r, g, b, a);
        this.color[2].set(r, g, b, a);
        this.color[3].set(r, g, b, a);
    }

    public void setColor(int index, ReadableColor src) {
        this.color[index].setColor(src);
    }

    public void setColors(ReadableColor src) {
        this.color[0].setColor(src);
        this.color[1].setColor(src);
        this.color[2].setColor(src);
        this.color[3].setColor(src);
    }

    public void setAngle(int angle) {
        this.angle = angle % 65535;
    }

    public int getAngle() {
        return this.angle;
    }

    public void adjustAngle(int delta) {
        this.angle = (this.angle + delta) % 65535;
    }

    public WritableColor getColor(int index, WritableColor dest) {
        if (dest == null) {
            return new Color((ReadableColor)this.color[index]);
        }
        dest.setColor((ReadableColor)this.color[index]);
        return dest;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getTick() {
        return this.tick;
    }

    public void eventReceived(int event) {
    }

    public void setImage(SpriteImage image) {
        this.image = image;
    }

    public void setSequence(int newSeq) {
        this.sequence = newSeq;
    }

    public void setTick(int newTick) {
        this.tick = newTick;
    }

    public void deactivate() {
        this.setActive(false);
    }

    public SpriteImage getImage() {
        return this.image;
    }

    public void moveLocation(int dx, int dy, int dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    public void moveOffset(int dx, int dy, int dz) {
        this.ox += dx;
        this.oy += dy;
        this.oz += dz;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public void deallocate() {
        if (!$assertionsDisabled && !this.allocated) {
            throw new AssertionError();
        }
        this.allocated = false;
        this.engine.deallocate(this);
    }

    public int getEvent() {
        return this.event;
    }

    public void setEvent(int event) {
        this.event = event;
    }

    public String toString() {
        return "Sprite[owner=" + this.owner + ", image=" + this.image + ", animation=" + this.animation + ", event=" + this.event + ", active=" + this.active + ", visible=" + this.visible + ", position=" + this.x + "," + this.y + "," + this.z + "]";
    }

    public boolean isFlashing() {
        return this.flash;
    }
}

