/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLGlyph;
import com.shavenpuppy.jglib.opengl.GLGlyphBuffer;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.WritableRectangle;

public class GLString
implements GLRenderable {
    private GLFont font;
    private char[] text;
    private int[] x;
    private int[] ox;
    private int[] y;
    private int[] oy;
    private GLGlyphBuffer buffer;
    private int xpos;
    private int ypos;
    private int length;
    private boolean changed;
    private static final Rectangle temp = new Rectangle();
    private final Rectangle size = new Rectangle();
    private boolean resized = false;

    public GLString(int length) {
        this.text = new char[length];
        this.x = new int[length];
        this.y = new int[length];
        this.ox = new int[length];
        this.oy = new int[length];
        this.buffer = new GLGlyphBuffer(length);
        this.length = 0;
    }

    public int capacity() {
        return this.text.length;
    }

    public int getCharIndexAt(float xx, float yy) {
        this.layout();
        this.getBounds(this.size);
        int i = 0;
        while (i < this.buffer.length) {
            if (this.buffer.glyph[i] != null) {
                temp.setBounds(this.x[i] + this.xpos, this.size.getY(), this.buffer.glyph[i].getWidth(), this.size.getHeight());
                if (temp.contains((int)xx, (int)yy)) {
                    return i;
                }
            }
            ++i;
        }
        if (yy >= (float)this.size.getY() && yy <= (float)(this.size.getY() + this.size.getHeight()) && xx >= (float)(this.size.getX() + this.size.getWidth())) {
            return this.buffer.length;
        }
        if (yy >= (float)this.size.getY() && yy <= (float)(this.size.getY() + this.size.getHeight()) && xx < (float)this.size.getX()) {
            return 0;
        }
        return -1;
    }

    public GLGlyph getGlyph(int index) {
        return this.buffer.glyph[index];
    }

    public int getGlyphIndexAt(float xx, float yy) {
        this.layout();
        int i = 0;
        while (i < this.buffer.glyph.length) {
            if (this.buffer.glyph[i] != null) {
                temp.setBounds(this.x[i] + this.ox[i] + this.xpos, this.y[i] + this.oy[i] + this.ypos, this.x[i] + this.ox[i] + this.xpos + this.buffer.glyph[i].getWidth(), this.y[i] + this.oy[i] + this.ypos + this.buffer.glyph[i].getHeight());
                if (temp.contains((int)xx, (int)yy)) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public Rectangle getBounds(Rectangle ret) {
        this.layout();
        if (ret == null) {
            ret = new Rectangle();
        }
        if (!this.resized) {
            ret.setBounds((ReadableRectangle)this.size);
            return ret;
        }
        boolean doneOne = false;
        int i = 0;
        while (i < this.length) {
            GLGlyph g = this.buffer.glyph[i];
            if (g != null) {
                if (!doneOne) {
                    ret.setBounds(this.x[i] + this.ox[i] + this.xpos, this.y[i] + this.oy[i] + this.ypos, this.buffer.glyph[i].getWidth(), this.buffer.glyph[i].getHeight());
                    doneOne = true;
                } else {
                    temp.setBounds(this.x[i] + this.ox[i] + this.xpos, this.y[i] + this.oy[i] + this.ypos, this.buffer.glyph[i].getWidth(), this.buffer.glyph[i].getHeight());
                    ret.union((ReadableRectangle)temp, (WritableRectangle)ret);
                }
            }
            ++i;
        }
        this.size.setBounds((ReadableRectangle)ret);
        this.resized = false;
        return ret;
    }

    public String getText() {
        return new String(this.text, 0, this.length);
    }

    public String getText(int start, int count) {
        return new String(this.text, start, count);
    }

    protected boolean isChanged() {
        return this.changed;
    }

    public void layout() {
        if (this.font == null || !this.isChanged()) {
            return;
        }
        this.buffer = this.font.getGlyphBuffer(this.text, 0, this.length, this.buffer);
        int i = 0;
        while (i < this.buffer.length) {
            if (this.buffer.glyph[i] != null) {
                this.x[i] = this.buffer.glyph[i].getXpos();
                this.y[i] = this.buffer.glyph[i].getYpos();
            }
            ++i;
        }
        this.setChanged(false);
        this.resized = true;
    }

    public int length() {
        return this.length;
    }

    public void render() throws OpenGLException {
        this.layout();
        this.font.getTexture().render();
        GL11.glBegin((int)7);
        int i = 0;
        while (i < this.buffer.length) {
            GLGlyph g = this.buffer.glyph[i];
            if (g != null) {
                g.setLocation(this.x[i] + this.ox[i] + this.xpos, this.y[i] + this.oy[i] + this.ypos);
                g.render();
            }
            ++i;
        }
        GL11.glEnd();
    }

    protected void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setFont(GLFont font) {
        if (this.font == font) {
            return;
        }
        if (font == null) {
            throw new NullPointerException("Can't set font to null");
        }
        this.setChanged(true);
        this.font = font;
        this.resized = true;
    }

    public GLFont getFont() {
        return this.font;
    }

    public Rectangle getGlyphBounds(int index, Rectangle dest) {
        if (dest == null) {
            dest = new Rectangle();
        }
        if (index < 0) {
            dest.setBounds(this.xpos, this.ypos, 0, this.font.getAscent() + this.font.getDescent());
        } else {
            GLGlyph g = this.buffer.glyph[index];
            if (g != null) {
                dest.setBounds(this.x[index] + this.ox[index] + this.xpos, this.y[index] + this.oy[index] + this.ypos, g.getAdvance(), this.font.getAscent() + this.font.getDescent());
            }
        }
        return dest;
    }

    public void setGlyphLocation(int index, int xx, int yy) {
        this.x[index] = xx;
        this.y[index] = yy;
        this.resized = true;
    }

    public void setGlyphOffset(int index, int xx, int yy) {
        this.ox[index] = xx;
        this.oy[index] = yy;
        this.resized = true;
    }

    public void setLength(int length) {
        this.length = Math.min(this.capacity(), length);
        this.setChanged(true);
        this.resized = true;
    }

    public void setLocation(int xp, int yp) {
        if (this.xpos != xp || this.ypos != yp) {
            this.xpos = xp;
            this.ypos = yp;
            this.resized = true;
        }
    }

    public int getX() {
        return this.xpos;
    }

    public int getY() {
        return this.ypos;
    }

    public Point getLocation(Point ret) {
        if (ret == null) {
            ret = new Point();
        }
        ret.setLocation(this.xpos, this.ypos);
        return ret;
    }

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        this.length = Math.min(this.text.length, s.length());
        s.getChars(0, this.length, this.text, 0);
        this.setChanged(true);
        this.resized = true;
    }

    public void setText(String s, int start, int end, int destpos) {
        if (s == null) {
            s = "";
        }
        this.length = Math.max(destpos + (end - start), this.length);
        s.getChars(start, end, this.text, destpos);
        this.setChanged(true);
        this.resized = true;
    }

    public String toString() {
        return "GLString[" + new String(this.text) + "," + this.x + ", " + this.y + "]";
    }
}

