/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.mouse;

import com.shavenpuppy.jglib.mouse.OpenGLMouseEvent;
import com.shavenpuppy.jglib.mouse.OpenGLMouseEventListener;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MouseEventGenerator {
    private Vector2f previousPosition;
    private boolean[] previousButtonStates;
    private Vector2f[] buttonPressLocations;
    private OpenGLMouseEventListener eventListener;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.mouse.MouseEventGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public MouseEventGenerator(OpenGLMouseEventListener eventListener) {
        if (!$assertionsDisabled && eventListener == null) {
            throw new AssertionError();
        }
        this.eventListener = eventListener;
        this.previousPosition = new Vector2f();
        this.previousButtonStates = new boolean[Mouse.getButtonCount()];
        this.buttonPressLocations = new Vector2f[Mouse.getButtonCount()];
        int i = 0;
        while (i < this.buttonPressLocations.length) {
            this.buttonPressLocations[i] = new Vector2f();
            ++i;
        }
    }

    public void update(boolean generateMouseEvents) {
        int i = 0;
        while (i < Mouse.getButtonCount()) {
            if (Mouse.isButtonDown((int)i) && generateMouseEvents) {
                if (this.previousButtonStates[i]) {
                    if ((float)Mouse.getX() != this.previousPosition.x || (float)Mouse.getY() != this.previousPosition.y) {
                        OpenGLMouseEvent draggedEvent = new OpenGLMouseEvent(3, i, (ReadableVector2f)new Vector2f((float)Mouse.getX(), (float)Mouse.getY()), (ReadableVector2f)this.previousPosition);
                        if (this.eventListener != null) {
                            this.eventListener.mouseDragged(draggedEvent);
                        }
                    }
                } else {
                    OpenGLMouseEvent pressedEvent = new OpenGLMouseEvent(1, i, (ReadableVector2f)new Vector2f((float)Mouse.getX(), (float)Mouse.getY()), (ReadableVector2f)this.previousPosition);
                    if (this.eventListener != null) {
                        this.eventListener.mousePressed(pressedEvent);
                    }
                    this.buttonPressLocations[i].set((float)Mouse.getX(), (float)Mouse.getY());
                }
            } else if (this.previousButtonStates[i]) {
                OpenGLMouseEvent releasedEvent = new OpenGLMouseEvent(2, i, (ReadableVector2f)new Vector2f((float)Mouse.getX(), (float)Mouse.getY()), (ReadableVector2f)this.previousPosition);
                if (this.eventListener != null) {
                    this.eventListener.mouseReleased(releasedEvent);
                }
                if (this.buttonPressLocations[i].x == (float)Mouse.getX() && this.buttonPressLocations[i].y == (float)Mouse.getY()) {
                    OpenGLMouseEvent clickedEvent = new OpenGLMouseEvent(0, i, (ReadableVector2f)new Vector2f((float)Mouse.getX(), (float)Mouse.getY()), (ReadableVector2f)this.previousPosition);
                    if (this.eventListener != null) {
                        this.eventListener.mouseClicked(clickedEvent);
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.previousButtonStates.length) {
            this.previousButtonStates[i] = Mouse.isButtonDown((int)i);
            ++i;
        }
        this.previousPosition.set((float)Mouse.getX(), (float)Mouse.getY());
    }

    public boolean isDragging() {
        boolean flag = false;
        int i = 0;
        while (i < this.previousButtonStates.length) {
            flag |= this.previousButtonStates[i];
            ++i;
        }
        return flag;
    }
}

