/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.interpolators;

import com.shavenpuppy.jglib.interpolators.InterpolatorBase;
import com.shavenpuppy.jglib.util.FPMath;
import java.io.ObjectInput;
import java.io.ObjectStreamException;

public final class LinearInterpolator
extends InterpolatorBase {
    public static final LinearInterpolator instance = new LinearInterpolator();

    private LinearInterpolator() {
    }

    public float interpolate(float a, float b, float ratio) {
        if (ratio < 0.0f) {
            ratio = 0.0f;
        } else if (ratio > 1.0f) {
            ratio = 1.0f;
        }
        return a * (1.0f - ratio) + b * ratio;
    }

    public int interpolate(int a, int b, int ratio) {
        if (ratio < 0) {
            ratio = 0;
        } else if (ratio > FPMath.ONE) {
            ratio = FPMath.ONE;
        }
        return FPMath.mul(a, FPMath.ONE - ratio) + FPMath.mul(b, ratio);
    }

    private Object readResolve(ObjectInput oi) throws ObjectStreamException {
        return instance;
    }
}

