/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry;

import com.shavenpuppy.jglib.geometry.Box;
import com.shavenpuppy.jglib.geometry.Classifier;
import com.shavenpuppy.jglib.geometry.Plane;
import java.io.Serializable;
import org.lwjgl.util.vector.Vector3f;

public class Sphere
implements Serializable,
Classifier {
    public float x;
    public float y;
    public float z;
    public float radius;

    public Sphere() {
    }

    public Sphere(float x, float y, float z, float radius) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
    }

    public Classifier.Classification classify(float xx, float yy, float zz) {
        if ((this.x - xx) * (this.x - xx) + (this.y - yy) * (this.y - yy) + (this.z - zz) * (this.z - zz) <= this.radius) {
            return Classifier.INSIDE;
        }
        return Classifier.OUTSIDE;
    }

    public Classifier.Classification classify(float xx, float yy, float zz, float radius2) {
        float d = (this.x - xx) * (this.x - xx) + (this.y - yy) * (this.y - yy) + (this.z - zz) * (this.z - zz);
        if (d + radius2 < this.radius) {
            return Classifier.INSIDE;
        }
        if (d < radius2 + this.radius) {
            return Classifier.SPANNING;
        }
        if (d > this.radius + radius2) {
            return Classifier.OUTSIDE;
        }
        return Classifier.ENCLOSING;
    }

    public Classifier.Classification classify(Box box) {
        return box.classify(this).invert();
    }

    public Plane.Classification classify(Plane p) {
        float d = p.distanceTo(this.x, this.y, this.z);
        if (d >= this.radius) {
            return Plane.IN_FRONT_OF;
        }
        if (d <= -this.radius) {
            return Plane.BEHIND;
        }
        return Plane.SPANNING;
    }

    public Classifier.Classification classify(Sphere sphere) {
        return this.classify(sphere.x, sphere.y, sphere.z, sphere.radius);
    }

    public Classifier.Classification classify(Vector3f v) {
        return this.classify(v.x, v.y, v.z);
    }
}

