/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry;

import com.shavenpuppy.jglib.geometry.Line;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;

public final class Plane
implements Externalizable {
    public float a;
    public float b;
    public float c;
    public float d;
    private Vector3f normal;
    public static final Classification IN_FRONT_OF = new Classification("In front of"){

        public Classification add(Classification c) {
            if (c == BEHIND || c == SPANNING) {
                return SPANNING;
            }
            return this;
        }
    };
    public static final Classification BEHIND = new Classification("Behind"){

        public Classification add(Classification c) {
            if (c == IN_FRONT_OF || c == SPANNING) {
                return SPANNING;
            }
            return this;
        }
    };
    public static final Classification SPANNING = new Classification("Spanning"){

        public Classification add(Classification c) {
            return SPANNING;
        }
    };
    public static final Classification COINCIDENT = new Classification("Coincident"){

        public Classification add(Classification c) {
            return c;
        }
    };
    private static final float EPSILON = 1.0E-6f;
    private static final Vector3f temp = new Vector3f();

    public Plane() {
        this.a = 1.0f;
        this.b = 0.0f;
        this.c = 0.0f;
        this.d = 0.0f;
    }

    public Plane(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public Classification classify(Vector3f[] vec) {
        Classification c = COINCIDENT;
        int i = 0;
        while (i < vec.length) {
            c = c.add(this.classify(vec[i]));
            ++i;
        }
        return c;
    }

    public Classification classify(float x, float y, float z) {
        float distance = this.distanceTo(x, y, z);
        if (distance < -1.0E-6f) {
            return BEHIND;
        }
        if (distance > 1.0E-6f) {
            return IN_FRONT_OF;
        }
        return COINCIDENT;
    }

    public Classification classify(Vector3f v) {
        float distance = this.distanceTo(v);
        if (distance < -1.0E-6f) {
            return BEHIND;
        }
        if (distance > 1.0E-6f) {
            return IN_FRONT_OF;
        }
        return COINCIDENT;
    }

    public float distanceTo(float x, float y, float z) {
        return this.a * x + this.b * y + this.c * z + this.d;
    }

    public float distanceTo(Vector3f v) {
        return this.distanceTo(v.x, v.y, v.z);
    }

    public Vector3f getNormal() {
        if (this.normal == null) {
            this.normal = new Vector3f(this.a, this.b, this.c);
        }
        return this.normal;
    }

    public boolean intersect(Plane rkPlane1, Line rkLine) {
        float fN00 = this.getNormal().lengthSquared();
        float fN01 = Vector3f.dot((Vector3f)this.getNormal(), (Vector3f)rkPlane1.getNormal());
        float fN11 = rkPlane1.getNormal().lengthSquared();
        float fDet = fN00 * fN11 - fN01 * fN01;
        if (Math.abs(fDet) < 1.0E-6f) {
            return false;
        }
        float fInvDet = 1.0f / fDet;
        float fC0 = (fN11 * this.d - fN01 * rkPlane1.d) * fInvDet;
        float fC1 = (fN00 * rkPlane1.d - fN01 * this.d) * fInvDet;
        Vector3f.cross((Vector3f)this.getNormal(), (Vector3f)rkPlane1.getNormal(), (Vector3f)rkLine.direction);
        temp.set((ReadableVector3f)this.getNormal());
        temp.scale(fC0);
        rkLine.origin.set((ReadableVector3f)temp);
        temp.set((ReadableVector3f)rkPlane1.getNormal());
        temp.scale(fC1);
        Vector3f.add((Vector3f)rkLine.origin, (Vector3f)temp, (Vector3f)rkLine.origin);
        return true;
    }

    public float intersect(Vector3f start, Vector3f end, Vector3f result) {
        float t = -(this.d + (start.x * this.a + start.y * this.b + start.z * this.c)) / (end.x * this.a + end.y * this.b + end.z * this.c);
        result.set(start.x + end.x * t, start.y + end.y * t, start.z + end.z * t);
        return t;
    }

    public Plane normalize() {
        float t = (float)Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c);
        this.a /= t;
        this.b /= t;
        this.c /= t;
        this.d /= t;
        return this;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.a = in.readFloat();
        this.b = in.readFloat();
        this.c = in.readFloat();
        this.d = in.readFloat();
        this.normal = null;
    }

    public void set(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.normal = null;
    }

    public boolean testIntersection(Plane rkPlane1) {
        Vector3f.cross((Vector3f)this.getNormal(), (Vector3f)rkPlane1.getNormal(), (Vector3f)temp);
        float fSqrLength = temp.lengthSquared();
        return fSqrLength > 1.0E-6f;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("Plane[A:");
        sb.append(this.a);
        sb.append(" B:");
        sb.append(this.b);
        sb.append(" C:");
        sb.append(this.c);
        sb.append(" D:");
        sb.append(this.d);
        sb.append(']');
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.a);
        out.writeFloat(this.b);
        out.writeFloat(this.c);
        out.writeFloat(this.d);
    }

    public static abstract class Classification {
        private final String classification;

        protected Classification(String c) {
            this.classification = c;
        }

        public abstract Classification add(Classification var1);

        public String toString() {
            return this.classification;
        }
    }
}

