/*
 * Decompiled with CFR 0.152.
 */
package com.kaioa.tools.jnlp.muffin;

import com.kaioa.tools.jnlp.muffin.FileMuffin;
import com.kaioa.tools.jnlp.muffin.Muffin;
import com.kaioa.tools.jnlp.muffin.MuffinException;
import com.kaioa.tools.jnlp.muffin.WebstartMuffin;
import java.io.File;
import java.net.URL;
import javax.jnlp.ServiceManager;

public class MuffinProvider {
    private static boolean webstart = false;

    static {
        webstart = true;
        try {
            Class.forName("javax.jnlp.ServiceManager");
            ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
        }
        catch (Exception e) {
            System.err.println("MuffinProvider: No webstart detected");
            webstart = false;
        }
    }

    public static void setMuffinDirectory(String muffinDirectory, boolean useHome) {
        if (!webstart) {
            if (useHome) {
                String userHome = System.getProperty("user.home");
                if (!userHome.endsWith(File.separator)) {
                    userHome = String.valueOf(userHome) + File.separator;
                }
                FileMuffin.setMuffinDirectory(String.valueOf(userHome) + muffinDirectory);
            } else {
                FileMuffin.setMuffinDirectory(muffinDirectory);
            }
        }
    }

    public static String[] getNames() throws MuffinException {
        if (webstart) {
            return WebstartMuffin.getNames();
        }
        return FileMuffin.getNames();
    }

    public static String[] getNames(URL url) throws MuffinException {
        if (webstart) {
            return WebstartMuffin.getNames(url);
        }
        return FileMuffin.getNames(url);
    }

    public static Muffin getMuffin(String name) throws MuffinException {
        if (webstart) {
            return new WebstartMuffin(name);
        }
        return new FileMuffin(name);
    }

    public static Muffin getMuffin(URL url) throws MuffinException {
        if (webstart) {
            return new WebstartMuffin(url);
        }
        return new FileMuffin(url);
    }
}

