/*
 * Decompiled with CFR 0.152.
 */
import com.kaioa.tools.jnlp.muffin.Muffin;
import com.kaioa.tools.jnlp.muffin.MuffinException;
import com.kaioa.tools.jnlp.muffin.MuffinProvider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MuffinTest
implements ActionListener {
    private JFrame frame;
    private JTextArea txt;
    private DebugText debug;
    private JTextField tf;
    private JButton next;
    private CardLayout cl;
    private JPanel cards;
    private JPanel card1;
    private JPanel card2;
    private static final String LOAD = "Load";
    private static final String SAVE = "Save";
    private static final String DEL = "Delete muffins";
    private static final String NEXT = "Continue with manual testing";
    private static final String WAIT = "Performing test. Please wait.";
    private static final String P1 = "Panel one";
    private static final String P2 = "Panel two";
    private static final String TITLE = "Muffin Test4c";

    public MuffinTest() {
        MuffinProvider.setMuffinDirectory(TITLE, true);
        this.frame = new JFrame(TITLE);
        this.frame.setDefaultCloseOperation(3);
        this.txt = new JTextArea();
        this.tf = new JTextField(30);
        this.debug = new DebugText();
        this.next = new JButton(WAIT);
        this.next.setActionCommand(NEXT);
        this.next.setEnabled(false);
        this.next.addActionListener(this);
        this.card1 = new JPanel();
        this.card1.setLayout(new BorderLayout());
        this.card1.add((Component)new JScrollPane(this.debug), "Center");
        this.card1.add((Component)this.next, "South");
        this.card2 = new JPanel();
        this.card2.setLayout(new BorderLayout());
        this.card2.add((Component)this.buildNamePanel(), "North");
        this.card2.add((Component)new JScrollPane(this.txt), "Center");
        this.card2.add((Component)this.buildControlPanel(), "South");
        this.cl = new CardLayout();
        this.cards = new JPanel(this.cl);
        this.cards.add((Component)this.card1, P1);
        this.cards.add((Component)this.card2, P2);
        this.frame.setContentPane(this.cards);
        this.frame.setSize(500, 400);
        this.frame.show();
        this.test();
    }

    private JPanel buildControlPanel() {
        JPanel p = new JPanel();
        JButton load = new JButton(LOAD);
        JButton save = new JButton(SAVE);
        JButton del = new JButton(DEL);
        load.addActionListener(this);
        save.addActionListener(this);
        del.addActionListener(this);
        p.add(load);
        p.add(save);
        p.add(del);
        return p;
    }

    private JPanel buildNamePanel() {
        JPanel p = new JPanel();
        p.add(new JLabel("Muffin name:"));
        p.add(this.tf);
        return p;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(LOAD)) {
            this.load();
        } else if (cmd.equals(SAVE)) {
            this.save();
        } else if (cmd.equals(DEL)) {
            this.delete();
        } else if (cmd.equals(NEXT)) {
            this.cl.show(this.cards, P2);
        }
    }

    private void load() {
        try {
            String msg = (String)JOptionPane.showInputDialog(this.frame, "Please select a muffin", LOAD, 3, null, MuffinProvider.getNames(), null);
            if (msg == null) {
                return;
            }
            Muffin muffin = MuffinProvider.getMuffin(msg);
            this.txt.setText(muffin.readPlainText());
            this.tf.setText(msg);
        }
        catch (MuffinException e) {
            e.printStackTrace();
        }
    }

    private void save() {
        String muffinName = this.tf.getText();
        if (muffinName == null || muffinName.length() == 0) {
            JOptionPane.showMessageDialog(this.frame, "Please enter a muffin name", "Moo!", 2);
            return;
        }
        try {
            Muffin muffin = MuffinProvider.getMuffin(muffinName);
            muffin.writePlainText(this.txt.getText());
        }
        catch (MuffinException e) {
            e.printStackTrace();
        }
    }

    private void delete() {
        try {
            String msg = (String)JOptionPane.showInputDialog(this.frame, "Please select a muffin", "Delete", 3, null, MuffinProvider.getNames(), null);
            if (msg == null) {
                return;
            }
            Muffin muffin = MuffinProvider.getMuffin(msg);
            muffin.delete();
        }
        catch (MuffinException e) {
            e.printStackTrace();
        }
    }

    private void test() {
        Muffin testMuffin2;
        String read;
        Muffin testMuffin;
        int i;
        String testText = "test, testing, test, test...";
        byte testByte = 35;
        short testShort = 5;
        int ok = 0;
        int bad = 0;
        try {
            this.debug.printMessage("getNames()");
            String[] names = MuffinProvider.getNames();
            this.debug.printInfo(" ok\n");
            this.debug.printMessage(String.valueOf(names.length) + " muffins found.\n");
            i = 0;
            while (i < names.length) {
                this.debug.printMessage("   " + names[i] + "\n");
                ++i;
            }
            ++ok;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("Muffin(String name)");
            testMuffin = MuffinProvider.getMuffin("autotest");
            this.debug.printInfo(" ok\n");
            ++ok;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            this.debug.printError("can't create. abort.");
            return;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("exists() #1");
            boolean exists = testMuffin.exists();
            this.debug.printInfo(exists ? " Muffin exists\n" : " Muffin doesn't exist\n");
        }
        catch (MuffinException me) {
            this.debug.printException(me);
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("writePlainText(String text)");
            testMuffin.writePlainText(testText);
            this.debug.printInfo(" ok\n");
            ++ok;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("exists() #2");
            if (testMuffin.exists()) {
                this.debug.printInfo(" Muffin exists\n");
                ++ok;
            } else {
                this.debug.printError(" Muffin doesn't exist\n");
                ++bad;
            }
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("getNames() #2");
            String[] names = MuffinProvider.getNames();
            this.debug.printInfo(" ok\n");
            this.debug.printMessage(String.valueOf(names.length) + " muffins found.\n");
            i = 0;
            while (i < names.length) {
                this.debug.printMessage("   " + names[i] + "\n");
                ++i;
            }
            ++ok;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("readPlainText()");
            String read2 = testMuffin.readPlainText();
            if (read2.equals(testText)) {
                this.debug.printInfo(" ok\n");
            }
            ++ok;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("delete()");
            testMuffin.delete();
            this.debug.printInfo(" ok\n");
            ++ok;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("exists() #3");
            if (!testMuffin.exists()) {
                this.debug.printInfo(" Muffin doesn't exist\n");
                ++ok;
            } else {
                this.debug.printError(" Muffin exists\n");
                ++bad;
            }
            boolean exists = testMuffin.exists();
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("readPlainText() - ");
            this.debug.printInfo("should fail (see above)\n");
            read = testMuffin.readPlainText();
            if (read.equals(testText)) {
                this.debug.printError("worked - duh?!\n");
            }
            ++bad;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            this.debug.printInfo("the exception above was ok\n");
            ++ok;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("getOutputStream()");
            DataOutputStream os = new DataOutputStream(testMuffin.getOutputStream());
            os.writeByte(testByte);
            os.writeShort(testShort);
            os.flush();
            os.close();
            this.debug.printInfo(" ok\n");
            ++ok;
        }
        catch (IOException ioe) {
            this.debug.printException(ioe);
            ++bad;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("getInputStream()");
            DataInputStream is = new DataInputStream(testMuffin.getInputStream());
            byte readb = is.readByte();
            short reads = is.readShort();
            is.close();
            if (readb == testByte && reads == testShort) {
                this.debug.printInfo(" ok\n");
            }
            ++ok;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        catch (IOException ioe) {
            this.debug.printException(ioe);
            ++bad;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("delete()");
            testMuffin.delete();
            this.debug.printInfo(" ok\n");
            ++ok;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("Muffin(URL url)");
            testMuffin2 = MuffinProvider.getMuffin(testMuffin.getURL());
            this.debug.printInfo(" ok\n");
            ++ok;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            this.debug.printError("can't create #2. abort.");
            return;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("writePlainText(String text)");
            testMuffin2.writePlainText(testText);
            this.debug.printInfo(" ok\n");
            ++ok;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("readPlainText()");
            read = testMuffin2.readPlainText();
            if (read.equals(testText)) {
                this.debug.printInfo(" ok\n");
            }
            ++ok;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        this.debug.printMessage("\n");
        try {
            this.debug.printMessage("delete()");
            testMuffin2.delete();
            this.debug.printInfo(" ok\n");
            ++ok;
        }
        catch (MuffinException me) {
            this.debug.printException(me);
            ++bad;
        }
        this.debug.printMessage("\n");
        this.debug.printInfo("Succeeded: " + ok + "\n");
        this.debug.printInfo("Failed   : " + bad);
        this.next.setText(NEXT);
        this.next.setEnabled(true);
    }

    public static void main(String[] args) {
        MuffinTest mt = new MuffinTest();
    }
}

